/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.rar.containers;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.replaymod.replaystudio.lib.guava.collect.ListMultimap;
import com.replaymod.replaystudio.lib.guava.collect.Multimaps;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.PaletteType;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.packets.PacketBlockChange;
import com.replaymod.replaystudio.protocol.packets.PacketChunkData;
import com.replaymod.replaystudio.protocol.registry.DimensionType;
import com.replaymod.replaystudio.rar.PacketSink;
import com.replaymod.replaystudio.rar.containers.DiffStateTree;
import com.replaymod.replaystudio.util.IPosition;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class BlockStateTree
extends DiffStateTree<Collection<BlockChange>> {
    private final PacketTypeRegistry registry;

    public BlockStateTree(PacketTypeRegistry registry, int index) {
        super(index);
        this.registry = registry;
    }

    @Override
    protected Collection<BlockChange> read(NetInput in) throws IOException {
        LinkedList<BlockChange> list = new LinkedList<BlockChange>();
        for (int j = in.readVarInt(); j > 0; --j) {
            list.add(new BlockChange(Packet.Reader.readPosition(this.registry, in), in.readVarInt(), in.readVarInt()));
        }
        return list;
    }

    @Override
    protected void discard(Collection<BlockChange> value) {
    }

    @Override
    protected void play(PacketSink sink, Collection<BlockChange> value) throws IOException {
        for (BlockChange change : value) {
            sink.accept(new PacketBlockChange(change.pos, change.to).write(this.registry));
        }
    }

    @Override
    protected void rewind(PacketSink sink, Collection<BlockChange> value) throws IOException {
        Iterator it = ((LinkedList)value).descendingIterator();
        while (it.hasNext()) {
            BlockChange update = (BlockChange)it.next();
            sink.accept(PacketBlockChange.write(this.registry, update.pos, update.from));
        }
    }

    public static class BlockChange {
        public IPosition pos;
        public int from;
        public int to;

        public BlockChange(IPosition pos, int from, int to) {
            this.pos = pos;
            this.from = from;
            this.to = to;
        }
    }

    public static class Builder
    extends DiffStateTree.Builder<Collection<BlockChange>> {
        private final PacketTypeRegistry registry;
        private final DimensionType dimensionType;
        private final ListMultimap<Integer, BlockChange> blocks;
        private final PacketChunkData.PalettedStorage[] currentBlockState;

        public Builder(PacketTypeRegistry registry, DimensionType dimensionType, PacketChunkData.Column column) {
            this.blocks = Multimaps.newListMultimap(this.map, LinkedList::new);
            this.registry = registry;
            this.dimensionType = dimensionType;
            this.currentBlockState = new PacketChunkData.PalettedStorage[dimensionType.getSections()];
            PacketChunkData.Chunk[] chunks = column.chunks;
            for (int i = 0; i < this.currentBlockState.length; ++i) {
                this.currentBlockState[i] = i >= chunks.length || chunks[i] == null ? new PacketChunkData.PalettedStorage(PaletteType.BLOCKS, registry) : chunks[i].blocks.copy();
            }
        }

        public void update(int time, PacketBlockChange record) {
            IPosition pos = record.getPosition();
            int sectionIndex = this.dimensionType.sectionYToIndex(pos.getY() >> 4);
            if (sectionIndex < 0 || sectionIndex >= this.currentBlockState.length) {
                return;
            }
            PacketChunkData.PalettedStorage blockStorage = this.currentBlockState[sectionIndex];
            int x = pos.getX() & 0xF;
            int y = pos.getY() & 0xF;
            int z = pos.getZ() & 0xF;
            int prevState = blockStorage.get(x, y, z);
            int newState = record.getId();
            blockStorage.set(x, y, z, newState);
            this.blocks.put(time, new BlockChange(pos, prevState, newState));
        }

        public void update(int time, PacketChunkData.Column column) {
            int sectionY = this.dimensionType.getMinY();
            int sectionIndex = 0;
            for (PacketChunkData.Chunk section : column.chunks) {
                if (section == null) {
                    ++sectionY;
                    ++sectionIndex;
                    continue;
                }
                PacketChunkData.PalettedStorage toBlocks = section.blocks;
                PacketChunkData.PalettedStorage fromBlocks = this.currentBlockState[sectionIndex];
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            int toState;
                            int fromState = fromBlocks.get(x, y, z);
                            if (fromState == (toState = toBlocks.get(x, y, z))) continue;
                            IPosition pos = new IPosition(column.x << 4 | x, sectionY << 4 | y, column.z << 4 | z);
                            this.blocks.put(time, new BlockChange(pos, fromState, toState));
                        }
                    }
                }
                this.currentBlockState[sectionIndex] = toBlocks;
                ++sectionY;
                ++sectionIndex;
            }
        }

        @Override
        protected void write(NetOutput out, Collection<BlockChange> value, int time) throws IOException {
            out.writeVarInt(value.size());
            for (BlockChange blockChange : value) {
                Packet.Writer.writePosition(this.registry, out, blockChange.pos);
                out.writeVarInt(blockChange.from);
                out.writeVarInt(blockChange.to);
            }
        }

        @Override
        protected void discard(Collection<BlockChange> value) {
        }
    }
}

