/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.util.IPosition;
import com.replaymod.replaystudio.util.Location;
import java.io.IOException;

public class SpawnEntity {
    public static Location getLocation(Packet packet) throws IOException {
        PacketType type = packet.getType();
        switch (type) {
            case SpawnExpOrb: {
                try (Packet.Reader in = packet.reader();){
                    in.readVarInt();
                    if (packet.atLeast(ProtocolVersion.v1_9)) {
                        Location location = new Location(in.readDouble(), in.readDouble(), in.readDouble(), 0.0f, 0.0f);
                        return location;
                    }
                    Location location = new Location((double)in.readInt() / 32.0, (double)in.readInt() / 32.0, (double)in.readInt() / 32.0, 0.0f, 0.0f);
                    return location;
                }
            }
            case SpawnObject: 
            case SpawnMob: {
                try (Packet.Reader in = packet.reader();){
                    in.readVarInt();
                    if (packet.atLeast(ProtocolVersion.v1_9)) {
                        in.readUUID();
                    }
                    if (packet.atLeast(ProtocolVersion.v1_11)) {
                        in.readVarInt();
                    } else {
                        in.readUnsignedByte();
                    }
                    Location location = SpawnEntity.readXYZYaPi(packet, in, type == PacketType.SpawnObject);
                    return location;
                }
            }
            case SpawnPlayer: {
                try (Packet.Reader in = packet.reader();){
                    in.readVarInt();
                    if (packet.atLeast(ProtocolVersion.v1_8)) {
                        in.readUUID();
                    } else {
                        in.readString();
                        in.readString();
                        int properties = in.readVarInt();
                        for (int i = 0; i < properties; ++i) {
                            in.readString();
                            in.readString();
                            in.readString();
                        }
                    }
                    Location properties = SpawnEntity.readXYZYaPi(packet, in, false);
                    return properties;
                }
            }
            case SpawnPainting: {
                try (Packet.Reader in = packet.reader();){
                    in.readVarInt();
                    if (packet.atLeast(ProtocolVersion.v1_9)) {
                        in.readUUID();
                    }
                    if (packet.atLeast(ProtocolVersion.v1_13)) {
                        in.readVarInt();
                    } else {
                        in.readString();
                    }
                    if (packet.atLeast(ProtocolVersion.v1_8)) {
                        IPosition pos = in.readPosition();
                        Location location = new Location(pos.getX(), pos.getY(), pos.getZ(), 0.0f, 0.0f);
                        return location;
                    }
                    Location location = new Location(in.readInt(), in.readInt(), in.readInt(), 0.0f, 0.0f);
                    return location;
                }
            }
        }
        return null;
    }

    static Location readXYZYaPi(Packet packet, Packet.Reader in, boolean flippedYawPitch) throws IOException {
        double z;
        double y;
        double x;
        if (packet.atLeast(ProtocolVersion.v1_9)) {
            x = in.readDouble();
            y = in.readDouble();
            z = in.readDouble();
        } else {
            x = (double)in.readInt() / 32.0;
            y = (double)in.readInt() / 32.0;
            z = (double)in.readInt() / 32.0;
        }
        float yaw = (float)in.readByte() / 256.0f * 360.0f;
        float pitch = (float)in.readByte() / 256.0f * 360.0f;
        if (flippedYawPitch) {
            float tmp = pitch;
            pitch = yaw;
            yaw = tmp;
        }
        return new Location(x, y, z, yaw, pitch);
    }

    static void writeXYZYaPi(Packet packet, Packet.Writer out, Location loc) throws IOException {
        if (packet.atLeast(ProtocolVersion.v1_9)) {
            out.writeDouble(loc.getX());
            out.writeDouble(loc.getY());
            out.writeDouble(loc.getZ());
        } else {
            out.writeInt((int)(loc.getX() * 32.0));
            out.writeInt((int)(loc.getY() * 32.0));
            out.writeInt((int)(loc.getZ() * 32.0));
        }
        out.writeByte((int)(loc.getYaw() / 360.0f * 256.0f));
        out.writeByte((int)(loc.getPitch() / 360.0f * 256.0f));
    }
}

