/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.interpolation;

import com.replaymod.replaystudio.pathing.interpolation.AbstractInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.InterpolationParameters;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.replaystudio.pathing.property.PropertyPart;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class LinearInterpolator
extends AbstractInterpolator {
    private Map<Property, Set<Keyframe>> framesToProperty = new HashMap<Property, Set<Keyframe>>();

    private void addToMap(Property property, Keyframe keyframe) {
        Set<Keyframe> set = this.framesToProperty.get(property);
        if (set == null) {
            set = new LinkedHashSet<Keyframe>();
            this.framesToProperty.put(property, set);
        }
        set.add(keyframe);
    }

    @Override
    protected Map<PropertyPart, InterpolationParameters> bakeInterpolation(Map<PropertyPart, InterpolationParameters> parameters) {
        this.framesToProperty.clear();
        for (PathSegment segment : this.getSegments()) {
            for (Property property : this.getKeyframeProperties()) {
                if (segment.getStartKeyframe().getValue(property).isPresent()) {
                    this.addToMap(property, segment.getStartKeyframe());
                }
                if (!segment.getEndKeyframe().getValue(property).isPresent()) continue;
                this.addToMap(property, segment.getEndKeyframe());
            }
        }
        Keyframe lastKeyframe = this.getSegments().get(this.getSegments().size() - 1).getEndKeyframe();
        HashMap<PropertyPart, InterpolationParameters> lastParameters = new HashMap<PropertyPart, InterpolationParameters>();
        for (Property property : this.getKeyframeProperties()) {
            Optional optionalValue = lastKeyframe.getValue(property);
            if (!optionalValue.isPresent()) continue;
            Object value = optionalValue.get();
            for (PropertyPart part : property.getParts()) {
                lastParameters.put(part, new InterpolationParameters(part.toDouble(value), 1.0, 0.0));
            }
        }
        return lastParameters;
    }

    @Override
    public <T> Optional<T> getValue(Property<T> property, long time) {
        Set<Keyframe> kfSet = this.framesToProperty.get(property);
        if (kfSet == null) {
            return Optional.empty();
        }
        Keyframe kfBefore = null;
        Keyframe kfAfter = null;
        for (Keyframe keyframe : kfSet) {
            if (keyframe.getTime() == time) {
                return keyframe.getValue(property);
            }
            if (keyframe.getTime() < time) {
                kfBefore = keyframe;
                continue;
            }
            if (keyframe.getTime() <= time) continue;
            kfAfter = keyframe;
            break;
        }
        if (kfBefore == null || kfAfter == null) {
            return Optional.empty();
        }
        T valueBefore = kfBefore.getValue(property).get();
        T valueAfter = kfAfter.getValue(property).get();
        double fraction = (double)(time - kfBefore.getTime()) / (double)(kfAfter.getTime() - kfBefore.getTime());
        T interpolated = valueBefore;
        for (PropertyPart<T> part : property.getParts()) {
            if (!part.isInterpolatable()) continue;
            double before = part.toDouble(valueBefore);
            double after = part.toDouble(valueAfter);
            double bound = part.getUpperBound();
            if (!Double.isNaN(bound)) {
                before = this.mod(before, bound);
                if (Math.abs((after = this.mod(after, bound)) - before) > bound / 2.0) {
                    after = before < bound / 2.0 ? (after -= bound) : (after += bound);
                }
            }
            double value = (after - before) * fraction + before;
            if (!Double.isNaN(bound)) {
                value = this.mod(value, bound);
            }
            interpolated = part.fromDouble(interpolated, value);
        }
        return Optional.of(interpolated);
    }

    private double mod(double val, double m) {
        double off = Math.floor(val / m);
        return val - off * m;
    }
}

