/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.io;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.ByteBufAllocator;
import com.github.steveice10.netty.buffer.PooledByteBufAllocator;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetInput;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.packets.PacketConfigRegistries;
import com.replaymod.replaystudio.protocol.packets.PacketJoinGame;
import com.replaymod.replaystudio.protocol.packets.PacketLoginSuccess;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import com.replaymod.replaystudio.stream.PacketStream;
import com.replaymod.replaystudio.studio.StudioPacketStream;
import com.replaymod.replaystudio.util.Utils;
import com.replaymod.replaystudio.viaversion.ViaVersionPacketConverter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;

public class ReplayInputStream
extends InputStream {
    private static final ByteBufAllocator ALLOC = PooledByteBufAllocator.DEFAULT;
    private PacketTypeRegistry rawRegistry;
    private PacketTypeRegistry registry;
    private CompoundTag mcRegistries;
    private final InputStream in;
    private ViaVersionPacketConverter viaVersionConverter;
    private boolean loginPhase;
    private boolean outputLoginPhase;
    private Queue<PacketData> buffer = new ArrayDeque<PacketData>();

    public ReplayInputStream(PacketTypeRegistry registry, InputStream in, int fileFormatVersion, int fileProtocol) throws IOException {
        boolean includeLoginPhase = fileFormatVersion >= 14;
        this.registry = registry;
        this.loginPhase = includeLoginPhase;
        boolean bl = this.outputLoginPhase = registry.getState() == State.LOGIN;
        if (!includeLoginPhase && this.outputLoginPhase) {
            this.buffer.offer(new PacketData(0L, new PacketLoginSuccess(UUID.nameUUIDFromBytes(new byte[0]), "Player", Collections.emptyList()).write(registry)));
            this.registry = PacketTypeRegistry.get(registry.getVersion(), State.PLAY);
        } else if (includeLoginPhase && !this.outputLoginPhase) {
            this.registry = PacketTypeRegistry.get(registry.getVersion(), State.LOGIN);
        }
        this.in = in;
        this.viaVersionConverter = ViaVersionPacketConverter.createForFileVersion(fileFormatVersion, fileProtocol, registry.getVersion().getOriginalVersion());
        this.rawRegistry = PacketTypeRegistry.get(ReplayMetaData.getProtocolVersion(fileFormatVersion, fileProtocol), this.registry.getState());
        if (this.rawRegistry.atLeast(ProtocolVersion.v1_20_2) && this.rawRegistry.getState() == State.PLAY) {
            throw new IllegalArgumentException("Cannot go directly to PLAY phase on 1.20.2+, only LOGIN and CONFIGURATION are valid.");
        }
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public PacketTypeRegistry getRegistry() {
        return this.registry;
    }

    public PacketData readPacket() throws IOException {
        this.fillBuffer();
        return this.buffer.poll();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void fillBuffer() throws IOException {
        while (this.buffer.isEmpty()) {
            next = Utils.readInt(this.in);
            if (next == -1 || length == -1) break;
            if (length == 0) continue;
            buf = ReplayInputStream.ALLOC.buffer(length);
            for (length = Utils.readInt(this.in); length > 0; length -= read) {
                read = buf.writeBytes(this.in, length);
                if (read != -1) continue;
                throw new EOFException();
            }
            rawPacketId = new ByteBufNetInput(buf).readVarInt();
            rawPacket = new Packet(this.rawRegistry, rawPacketId, buf);
            switch (1.$SwitchMap$com$replaymod$replaystudio$protocol$PacketType[rawPacket.getType().ordinal()]) {
                case 1: {
                    this.rawRegistry = this.rawRegistry.withLoginSuccess();
                    break;
                }
                case 2: {
                    this.rawRegistry = this.rawRegistry.withState(State.CONFIGURATION);
                    break;
                }
                case 3: {
                    this.mcRegistries = PacketConfigRegistries.read(rawPacket);
                    break;
                }
                case 4: {
                    this.rawRegistry = this.rawRegistry.withState(State.PLAY);
                    break;
                }
                case 5: {
                    joinGame = PacketJoinGame.read(rawPacket, this.mcRegistries);
                    joinGame.entityId ^= -1;
                    joinGame.gameMode = (byte)3;
                    writer = rawPacket.overwrite();
                    var8_9 = null;
                    joinGame.write(rawPacket, writer);
                    if (writer == null) break;
                    if (var8_9 == null) ** GOTO lbl41
                    try {
                        writer.close();
                    }
                    catch (Throwable var9_10) {
                        var8_9.addSuppressed(var9_10);
                    }
                    break;
lbl41:
                    // 1 sources

                    writer.close();
                    break;
                    catch (Throwable var9_11) {
                        try {
                            var8_9 = var9_11;
                            throw var9_11;
                        }
                        catch (Throwable var10_14) {
                            if (writer != null) {
                                if (var8_9 != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable var11_15) {
                                        var8_9.addSuppressed(var11_15);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                            throw var10_14;
                        }
                    }
                }
            }
            buf.resetReaderIndex();
            decoded = new LinkedList<Packet>();
            try {
                for (Object packet : this.viaVersionConverter.convertPacket(buf, rawPacket.getType().getState())) {
                    packetId = new ByteBufNetInput((ByteBuf)packet).readVarInt();
                    decoded.add(new Packet(this.registry, packetId, this.registry.getType(packetId), (ByteBuf)packet));
                }
            }
            catch (Exception e) {
                throw e instanceof IOException != false ? (IOException)e : new IOException("decoding", e);
            }
            buf.release();
            for (Object packet : decoded) {
                type = packet.getType();
                if (type == PacketType.KeepAlive) {
                    packet.release();
                    continue;
                }
                if (type == PacketType.LoginSuccess) {
                    this.loginPhase = false;
                    this.registry = this.registry.withLoginSuccess();
                    if (this.registry.atLeast(ProtocolVersion.v1_20_2)) {
                        this.viaVersionConverter.loginAcknowledged();
                    }
                }
                if ((this.loginPhase || type == PacketType.LoginSuccess) && !this.outputLoginPhase) {
                    packet.release();
                    continue;
                }
                if (type == PacketType.ConfigFinish) {
                    this.registry = this.registry.withState(State.PLAY);
                    if (this.registry.atLeast(ProtocolVersion.v1_20_2)) {
                        this.viaVersionConverter.finishConfiguration();
                    }
                }
                if (type == PacketType.Reconfigure) {
                    this.registry = this.registry.withState(State.CONFIGURATION);
                }
                this.buffer.offer(new PacketData(next, (Packet)packet));
            }
        }
    }

    public PacketStream asPacketStream() {
        return new StudioPacketStream(this);
    }
}

