/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.gui.screen;

import com.google.common.util.concurrent.SettableFuture;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.core.gui.GuiReplaySettings;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.render.gui.GuiRenderQueue;
import com.replaymod.render.rendering.VideoRenderer;
import com.replaymod.render.utils.RenderJob;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.Setting;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiContainer;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiImage;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.GuiTextField;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.element.advanced.AbstractGuiResourceLoadingList;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.popup.AbstractGuiPopup;
import de.johni0702.minecraft.gui.popup.GuiYesNoPopup;
import de.johni0702.minecraft.gui.utils.Colors;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.Image;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GuiReplayViewer
extends GuiScreen {
    private final ReplayModReplay mod;
    public final GuiReplayList list = (GuiReplayList)((GuiReplayList)new GuiReplayList(this).onSelectionChanged(this::updateButtons)).onSelectionDoubleClicked(() -> {
        if (this.loadButton.isEnabled()) {
            this.loadButton.onClick();
        }
    });
    public final GuiButton loadButton = (GuiButton)((GuiButton)new GuiButton().onClick(new Runnable(){
        private boolean loading = false;

        @Override
        public void run() {
            if (this.loading) {
                return;
            }
            this.loading = true;
            GuiReplayViewer.this.loadButton.setDisabled();
            List selected = GuiReplayViewer.this.list.getSelected();
            if (selected.size() == 1) {
                File file = ((GuiReplayEntry)selected.get((int)0)).file;
                ReplayModReplay.LOGGER.info("Opening replay in viewer: " + file);
                try {
                    GuiReplayViewer.this.mod.startReplay(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Iterator<Pair<File, List<RenderJob>>> replays = selected.stream().filter(it -> !it.renderQueue.isEmpty()).map(it -> Pair.of((Object)it.file, it.renderQueue)).iterator();
                GuiRenderQueue.processMultipleReplays(GuiReplayViewer.this, GuiReplayViewer.this.mod, replays, () -> {
                    this.loading = false;
                    GuiReplayViewer.this.updateButtons();
                    GuiReplayViewer.this.display();
                });
            }
        }
    })).setSize(150, 20);
    public final GuiButton folderButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton().onClick(new Runnable(){

        @Override
        public void run() {
            try {
                File folder = GuiReplayViewer.this.mod.getCore().folders.getReplayFolder().toFile();
                MCVer.openFile(folder);
            }
            catch (IOException e) {
                GuiReplayViewer.this.mod.getLogger().error("Cannot open file", (Throwable)e);
            }
        }
    })).setSize(150, 20)).setI18nLabel("replaymod.gui.viewer.replayfolder", new Object[0]);
    public final GuiButton renameButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)new GuiButton().onClick(new Runnable(){

        @Override
        public void run() {
            Path path = ((GuiReplayEntry)GuiReplayViewer.this.list.getSelected().get((int)0)).file.toPath();
            String name = Utils.fileNameToReplayName(path.getFileName().toString());
            GuiTextField nameField = (GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField().setSize(200, 20)).setFocused(true)).setText(name);
            final GuiYesNoPopup popup = GuiYesNoPopup.open(GuiReplayViewer.this, ((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.viewer.rename.name", new Object[0])).setColor(Colors.BLACK), nameField).setYesI18nLabel("replaymod.gui.rename", new Object[0]).setNoI18nLabel("replaymod.gui.cancel", new Object[0]);
            ((VerticalLayout)popup.getInfo().getLayout()).setSpacing(7);
            ((GuiTextField)nameField.onEnter(new Runnable(){

                @Override
                public void run() {
                    if (popup.getYesButton().isEnabled()) {
                        popup.getYesButton().onClick();
                    }
                }
            })).onTextChanged(obj -> popup.getYesButton().setEnabled(!nameField.getText().isEmpty() && Files.notExists(Utils.replayNameToPath(path.getParent(), nameField.getText()), new LinkOption[0])));
            popup.onAccept(() -> {
                String newName = nameField.getText().trim();
                Path targetPath = Utils.replayNameToPath(path.getParent(), newName);
                try {
                    Files.move(path, targetPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    GuiReplayViewer.this.getMinecraft().m_91152_((Screen)new AlertScreen(GuiReplayViewer.this::display, (Component)Component.m_237115_((String)"replaymod.gui.viewer.delete.failed1"), (Component)Component.m_237115_((String)"replaymod.gui.viewer.delete.failed2")));
                    return;
                }
                GuiReplayViewer.this.list.load();
            });
        }
    })).setSize(73, 20)).setI18nLabel("replaymod.gui.rename", new Object[0])).setDisabled();
    public final GuiButton deleteButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)new GuiButton().onClick(() -> {
        for (GuiReplayEntry entry : this.list.getSelected()) {
            String name = entry.name.getText();
            GuiYesNoPopup.open(this, ((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.viewer.delete.linea", new Object[0])).setColor(Colors.BLACK), ((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.viewer.delete.lineb", new Object[]{name + ChatFormatting.RESET})).setColor(Colors.BLACK)).setYesI18nLabel("replaymod.gui.delete", new Object[0]).setNoI18nLabel("replaymod.gui.cancel", new Object[0]).onAccept(() -> {
                try {
                    FileUtils.forceDelete((File)entry.file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.list.load();
            });
        }
    })).setSize(73, 20)).setI18nLabel("replaymod.gui.delete", new Object[0])).setDisabled();
    public final GuiButton settingsButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)new GuiButton(this).setSize(20, 20)).setTexture(ReplayMod.TEXTURE, 256)).setSpriteUV(20, 0)).setTooltip((GuiElement)new GuiTooltip().setI18nText("replaymod.gui.settings", new Object[0]))).onClick(() -> new GuiReplaySettings(this.toMinecraft(), this.getMod().getCore().getSettingsRegistry()).display());
    public final GuiButton cancelButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton().onClick(new Runnable(){

        @Override
        public void run() {
            GuiReplayViewer.this.getMinecraft().m_91152_(null);
        }
    })).setSize(73, 20)).setI18nLabel("replaymod.gui.cancel", new Object[0]);
    public final List<GuiButton> replaySpecificButtons = new ArrayList<GuiButton>();
    public final GuiPanel editorButton;
    public final GuiPanel upperButtonPanel;
    public final GuiPanel lowerButtonPanel;
    public final GuiPanel buttonPanel;
    private static final GuiImage DEFAULT_THUMBNAIL = (GuiImage)new GuiImage().setTexture(Utils.DEFAULT_THUMBNAIL);

    public GuiReplayViewer(ReplayModReplay mod) {
        this.replaySpecificButtons.addAll(Arrays.asList(this.renameButton));
        this.editorButton = new GuiPanel();
        this.upperButtonPanel = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new HorizontalLayout().setSpacing(5))).addElements(null, new GuiElement[]{this.loadButton});
        this.lowerButtonPanel = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new HorizontalLayout().setSpacing(5))).addElements(null, new GuiElement[]{this.renameButton, this.deleteButton, this.editorButton, this.cancelButton});
        this.buttonPanel = (GuiPanel)((GuiPanel)new GuiPanel(this).setLayout(new VerticalLayout().setSpacing(5))).addElements(null, new GuiElement[]{this.upperButtonPanel, this.lowerButtonPanel});
        this.mod = mod;
        try {
            this.list.setFolder(mod.getCore().folders.getReplayFolder().toFile());
        }
        catch (IOException e) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)e, (String)"Getting replay folder"));
        }
        this.setTitle((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.replayviewer", new Object[0]));
        this.setLayout(new CustomLayout<GuiScreen>(){

            @Override
            protected void layout(GuiScreen container, int width, int height) {
                this.pos(GuiReplayViewer.this.buttonPanel, width / 2 - this.width(GuiReplayViewer.this.buttonPanel) / 2, height - 10 - this.height(GuiReplayViewer.this.buttonPanel));
                this.pos(GuiReplayViewer.this.list, 0, 30);
                this.size(GuiReplayViewer.this.list, width, this.y(GuiReplayViewer.this.buttonPanel) - 10 - this.y(GuiReplayViewer.this.list));
                this.pos(GuiReplayViewer.this.settingsButton, width - this.width(GuiReplayViewer.this.settingsButton) - 5, 5);
            }
        });
        this.updateButtons();
    }

    public ReplayModReplay getMod() {
        return this.mod;
    }

    private void updateButtons() {
        List selected = this.list.getSelected();
        int count = selected.size();
        this.replaySpecificButtons.forEach((? super T b) -> b.setEnabled(count == 1));
        this.deleteButton.setEnabled(count > 0);
        if (count > 1) {
            Set jobs = selected.stream().flatMap(entry -> entry.renderQueue.stream()).collect(Collectors.toSet());
            String[] tooltipLines = (String[])jobs.stream().map(RenderJob::getName).toArray(String[]::new);
            this.loadButton.setI18nLabel("replaymod.gui.viewer.bulkrender", new Object[]{jobs.size()});
            this.loadButton.setTooltip((GuiElement)new GuiTooltip().setText(tooltipLines));
            this.loadButton.setEnabled(!jobs.isEmpty());
            String[] compatError = VideoRenderer.checkCompat(jobs.stream().map(RenderJob::getSettings));
            if (compatError != null) {
                ((GuiButton)this.loadButton.setDisabled()).setTooltip((GuiElement)new GuiTooltip().setText(compatError));
            }
        } else {
            this.loadButton.setI18nLabel("replaymod.gui.load", new Object[0]);
            this.loadButton.setTooltip(null);
            this.loadButton.setEnabled(count == 1 && !((GuiReplayEntry)selected.get((int)0)).incompatible);
        }
    }

    public static class GuiReplayList
    extends AbstractGuiResourceLoadingList<GuiReplayList, GuiReplayEntry>
    implements Typeable {
        private File folder = null;
        private final GuiTextField filterTextField = (GuiTextField)new GuiTextField().setFocused(true);

        public GuiReplayList(GuiContainer container) {
            super(container);
            ((GuiReplayList)((GuiReplayList)this.onLoad(results -> {
                File[] files = this.folder.listFiles((FileFilter)new SuffixFileFilter(".mcpr", IOCase.INSENSITIVE));
                if (files == null) {
                    ReplayModReplay.LOGGER.warn("Failed to list files in {}", (Object)this.folder);
                    return;
                }
                HashMap lastModified = new HashMap();
                Arrays.sort(files, Comparator.comparingLong(f -> lastModified.computeIfAbsent(f, File::lastModified)).reversed());
                for (File file : files) {
                    if (Thread.interrupted()) break;
                    try (ReplayFile replayFile = ReplayMod.instance.files.open(file.toPath());){
                        Image thumb = Optional.ofNullable(replayFile.getThumbBytes().orNull()).flatMap(stream -> {
                            Optional<Image> optional;
                            block8: {
                                InputStream in = stream;
                                try {
                                    optional = Optional.of(Image.read(in));
                                    if (in == null) break block8;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (in != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        return Optional.empty();
                                    }
                                }
                                in.close();
                            }
                            return optional;
                        }).orElse(null);
                        ReplayMetaData metaData = replayFile.getMetaData();
                        List<RenderJob> renderQueue = RenderJob.readQueue(replayFile);
                        if (metaData == null) continue;
                        results.consume(() -> new GuiReplayEntry(file, metaData, thumb, renderQueue){

                            @Override
                            public ReadableDimension calcMinSize() {
                                if (this.isFiltered(this)) {
                                    return new Dimension(-4, -4);
                                }
                                return super.calcMinSize();
                            }
                        });
                    }
                    catch (Exception e) {
                        ReplayModReplay.LOGGER.error("Could not load Replay File {}", (Object)file.getName(), (Object)e);
                    }
                }
            })).setDrawShadow(true)).setDrawSlider(true);
        }

        public void setFolder(File folder) {
            this.folder = folder;
        }

        private boolean isFiltered(GuiReplayEntry entry) {
            String filter = this.filterTextField.getText().toLowerCase();
            if (filter.isEmpty()) {
                return false;
            }
            return !entry.name.getText().toLowerCase().contains(filter);
        }

        @Override
        public boolean typeKey(ReadablePoint mousePosition, int keyCode, char keyChar, boolean ctrlDown, boolean shiftDown) {
            boolean filterHasPriority;
            if (keyCode == 290) {
                SettingsRegistry reg;
                reg.set(Setting.SHOW_SERVER_IPS, (reg = ReplayMod.instance.getSettingsRegistry()).get(Setting.SHOW_SERVER_IPS) == false);
                reg.save();
                this.load();
            }
            boolean bl = filterHasPriority = !this.filterTextField.getText().isEmpty();
            if (filterHasPriority && this.filterTextField.typeKey(mousePosition, keyCode, keyChar, ctrlDown, shiftDown)) {
                this.scrollY(0);
                return true;
            }
            if (super.typeKey(mousePosition, keyCode, keyChar, ctrlDown, shiftDown)) {
                return true;
            }
            if (!filterHasPriority && this.filterTextField.typeKey(mousePosition, keyCode, keyChar, ctrlDown, shiftDown)) {
                this.scrollY(0);
                return true;
            }
            return false;
        }

        @Override
        public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
            super.draw(renderer, size, renderInfo);
            String filter = this.filterTextField.getText();
            if (!filter.isEmpty()) {
                boolean anyMatches = this.getListPanel().calcMinSize().getHeight() > 0;
                Font fontRenderer = de.johni0702.minecraft.gui.versions.MCVer.getFontRenderer();
                int filterTextWidth = fontRenderer.m_92895_(filter);
                Objects.requireNonNull(fontRenderer);
                int filterTextHeight = 9;
                renderer.drawRect(size.getWidth() - 3 - 2 - filterTextWidth - 2, size.getHeight() - 3 - 2 - filterTextHeight - 2, 2 + filterTextWidth + 2, 2 + filterTextHeight + 2, Colors.WHITE);
                renderer.drawString(size.getWidth() - 3 - 2 - filterTextWidth, size.getHeight() - 3 - 2 - filterTextHeight, anyMatches ? Colors.BLACK : Colors.DARK_RED, filter);
            }
        }

        @Override
        protected GuiReplayList getThis() {
            return this;
        }
    }

    public static class GuiReplayEntry
    extends AbstractGuiContainer<GuiReplayEntry>
    implements Comparable<GuiReplayEntry> {
        public final File file;
        public final GuiLabel name = new GuiLabel();
        public final GuiLabel server = (GuiLabel)new GuiLabel().setColor(Colors.LIGHT_GRAY);
        public final GuiLabel date = (GuiLabel)new GuiLabel().setColor(Colors.LIGHT_GRAY);
        public final GuiPanel infoPanel = (GuiPanel)((GuiPanel)new GuiPanel(this).setLayout(new VerticalLayout().setSpacing(2))).addElements(null, new GuiElement[]{this.name, this.server, this.date});
        public final GuiLabel version = (GuiLabel)new GuiLabel(this).setColor(Colors.RED);
        public final GuiImage thumbnail;
        public final GuiLabel duration = new GuiLabel();
        public final GuiPanel durationPanel = (GuiPanel)((GuiPanel)((GuiPanel)new GuiPanel().setBackgroundColor(Colors.HALF_TRANSPARENT)).addElements(null, new GuiElement[]{this.duration})).setLayout(new CustomLayout<GuiPanel>(){

            @Override
            protected void layout(GuiPanel container, int width, int height) {
                this.pos(duration, 2, 2);
            }

            @Override
            public ReadableDimension calcMinSize(GuiContainer<?> container) {
                ReadableDimension dimension = duration.calcMinSize();
                return new Dimension(dimension.getWidth() + 2, dimension.getHeight() + 2);
            }
        });
        public final GuiImage renderQueueIcon = (GuiImage)((GuiImage)new GuiImage().setSize(10, 10)).setTexture(ReplayMod.TEXTURE, 40, 0, 20, 20);
        private final long dateMillis;
        private final boolean incompatible;
        private final List<RenderJob> renderQueue;

        public GuiReplayEntry(File file, ReplayMetaData metaData, Image thumbImage, List<RenderJob> renderQueue) {
            this.file = file;
            this.renderQueue = renderQueue;
            this.name.setText(ChatFormatting.UNDERLINE + Utils.fileNameToReplayName(file.getName()));
            if (!StringUtils.isEmpty((CharSequence)metaData.getCustomServerName())) {
                this.server.setText(metaData.getCustomServerName());
            } else if (StringUtils.isEmpty((CharSequence)metaData.getServerName()) || !ReplayMod.instance.getSettingsRegistry().get(Setting.SHOW_SERVER_IPS).booleanValue()) {
                ((GuiLabel)this.server.setI18nText("replaymod.gui.iphidden", new Object[0])).setColor(Colors.DARK_RED);
            } else {
                this.server.setText(metaData.getServerName());
            }
            boolean bl = this.incompatible = !ReplayMod.isCompatible(metaData.getFileFormatVersion(), metaData.getRawProtocolVersionOr0());
            if (this.incompatible) {
                this.version.setText("Minecraft " + metaData.getMcVersion());
            }
            this.dateMillis = metaData.getDate();
            this.date.setText(new SimpleDateFormat().format(new Date(this.dateMillis)));
            if (thumbImage == null) {
                this.thumbnail = (GuiImage)new GuiImage(DEFAULT_THUMBNAIL).setSize(53, 30);
                this.addElements(null, new GuiElement[]{this.thumbnail});
            } else {
                this.thumbnail = (GuiImage)((GuiImage)new GuiImage(this).setTexture(thumbImage)).setSize(53, 30);
            }
            this.duration.setText(Utils.convertSecondsToShortString(metaData.getDuration() / 1000));
            this.addElements(null, new GuiElement[]{this.durationPanel});
            if (!renderQueue.isEmpty()) {
                this.renderQueueIcon.setTooltip((GuiElement)new GuiTooltip().setText((String[])renderQueue.stream().map(RenderJob::getName).toArray(String[]::new)));
                this.addElements(null, new GuiElement[]{this.renderQueueIcon});
            }
            this.setLayout(new CustomLayout<GuiReplayEntry>(){

                @Override
                protected void layout(GuiReplayEntry container, int width, int height) {
                    this.pos(thumbnail, 0, 0);
                    this.x(durationPanel, this.width(thumbnail) - this.width(durationPanel));
                    this.y(durationPanel, this.height(thumbnail) - this.height(durationPanel));
                    this.pos(infoPanel, this.width(thumbnail) + 5, 0);
                    this.pos(version, width - this.width(version), 0);
                    if (renderQueueIcon.getContainer() != null) {
                        this.pos(renderQueueIcon, this.width(thumbnail) - this.width(renderQueueIcon), 0);
                    }
                }

                @Override
                public ReadableDimension calcMinSize(GuiContainer<?> container) {
                    return new Dimension(300, thumbnail.getMinSize().getHeight());
                }
            });
        }

        @Override
        protected GuiReplayEntry getThis() {
            return this;
        }

        @Override
        public int compareTo(GuiReplayEntry o) {
            return Long.compare(o.dateMillis, this.dateMillis);
        }
    }

    public static class GuiSelectReplayPopup
    extends AbstractGuiPopup<GuiSelectReplayPopup> {
        private final SettableFuture<File> future = SettableFuture.create();
        private final GuiReplayList list = new GuiReplayList(this.popup);
        private final GuiButton acceptButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton(this.popup).setI18nLabel("gui.done", new Object[0])).setSize(50, 20)).setDisabled();
        private final GuiButton cancelButton = (GuiButton)((GuiButton)new GuiButton(this.popup).setI18nLabel("gui.cancel", new Object[0])).setSize(50, 20);

        public static GuiSelectReplayPopup openGui(GuiContainer container, File folder) {
            GuiSelectReplayPopup popup = new GuiSelectReplayPopup(container, folder);
            popup.list.load();
            popup.open();
            return popup;
        }

        public GuiSelectReplayPopup(GuiContainer container, File folder) {
            super(container);
            this.list.setFolder(folder);
            ((GuiReplayList)this.list.onSelectionChanged(() -> this.acceptButton.setEnabled(this.list.getSelected() != null))).onSelectionDoubleClicked(() -> {
                this.close();
                this.future.set((Object)((GuiReplayEntry)this.list.getSelected().get((int)0)).file);
            });
            this.acceptButton.onClick(() -> {
                this.future.set((Object)((GuiReplayEntry)this.list.getSelected().get((int)0)).file);
                this.close();
            });
            this.cancelButton.onClick(() -> {
                this.future.set(null);
                this.close();
            });
            this.popup.setLayout(new CustomLayout<GuiPanel>(){

                @Override
                protected void layout(GuiPanel container, int width, int height) {
                    this.pos(cancelButton, width - this.width(cancelButton), height - this.height(cancelButton));
                    this.pos(acceptButton, this.x(cancelButton) - 5 - this.width(acceptButton), this.y(cancelButton));
                    this.pos(list, 0, 5);
                    this.size(list, width, height - this.height(cancelButton) - 10);
                }

                @Override
                public ReadableDimension calcMinSize(GuiContainer container) {
                    return new Dimension(330, 200);
                }
            });
        }

        public SettableFuture<File> getFuture() {
            return this.future;
        }

        public GuiReplayList getList() {
            return this.list;
        }

        public GuiButton getAcceptButton() {
            return this.acceptButton;
        }

        public GuiButton getCancelButton() {
            return this.cancelButton;
        }

        @Override
        protected GuiSelectReplayPopup getThis() {
            return this;
        }
    }
}

