/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.camera;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.replaymod.replay.Setting;
import com.replaymod.replay.camera.CameraController;
import com.replaymod.replay.camera.CameraEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CameraControllerRegistry {
    private final Map<String, Function<CameraEntity, CameraController>> constructors = new ConcurrentHashMap<String, Function<CameraEntity, CameraController>>();

    public void register(String name, Function<CameraEntity, CameraController> constructor) {
        Preconditions.checkState((!this.constructors.containsKey(name) ? 1 : 0) != 0, (Object)("Controller " + name + " is already registered."));
        this.constructors.put(name, constructor);
        Setting.CAMERA.setChoices(new ArrayList<String>(this.getControllers()));
    }

    public Set<String> getControllers() {
        return Collections.unmodifiableSet(this.constructors.keySet());
    }

    public CameraController create(String name, CameraEntity cameraEntity) {
        return (CameraController)this.constructors.get(name).apply((Object)cameraEntity);
    }
}

