/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay;

import java.util.AbstractList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;

public final class ButtonList
extends AbstractList<AbstractWidget> {
    private final List<Renderable> drawables;
    private final List<NarratableEntry> selectables;
    private final List<GuiEventListener> children;

    public ButtonList(List<Renderable> drawables, List<NarratableEntry> selectables, List<GuiEventListener> children) {
        this.drawables = drawables;
        this.selectables = selectables;
        this.children = children;
    }

    @Override
    public AbstractWidget get(int index) {
        int drawableIndex = this.translateIndex(this.drawables, index, false);
        return (AbstractWidget)this.drawables.get(drawableIndex);
    }

    @Override
    public AbstractWidget set(int index, AbstractWidget element) {
        int drawableIndex = this.translateIndex(this.drawables, index, false);
        this.drawables.set(drawableIndex, (Renderable)element);
        int selectableIndex = this.translateIndex(this.selectables, index, false);
        this.selectables.set(selectableIndex, (NarratableEntry)element);
        int childIndex = this.translateIndex(this.children, index, false);
        return (AbstractWidget)this.children.set(childIndex, (GuiEventListener)element);
    }

    @Override
    public void add(int index, AbstractWidget element) {
        int duplicateIndex = this.drawables.indexOf(element);
        if (duplicateIndex >= 0) {
            this.drawables.remove(element);
            this.selectables.remove(element);
            this.children.remove(element);
            if (duplicateIndex <= this.translateIndex(this.drawables, index, true)) {
                --index;
            }
        }
        int drawableIndex = this.translateIndex(this.drawables, index, true);
        this.drawables.add(drawableIndex, (Renderable)element);
        int selectableIndex = this.translateIndex(this.selectables, index, true);
        this.selectables.add(selectableIndex, (NarratableEntry)element);
        int childIndex = this.translateIndex(this.children, index, true);
        this.children.add(childIndex, (GuiEventListener)element);
    }

    @Override
    public AbstractWidget remove(int index) {
        index = this.translateIndex(this.drawables, index, false);
        AbstractWidget removedButton = (AbstractWidget)this.drawables.remove(index);
        this.selectables.remove(removedButton);
        this.children.remove(removedButton);
        return removedButton;
    }

    @Override
    public int size() {
        int ret = 0;
        for (Renderable drawable : this.drawables) {
            if (!(drawable instanceof AbstractWidget)) continue;
            ++ret;
        }
        return ret;
    }

    private int translateIndex(List<?> list, int index, boolean allowAfter) {
        int remaining = index;
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            if (!(list.get(i) instanceof AbstractWidget)) continue;
            if (remaining == 0) {
                return i;
            }
            --remaining;
        }
        if (allowAfter && remaining == 0) {
            return list.size();
        }
        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, index - remaining));
    }
}

