/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.replaymod.render.hooks.ForceChunkLoadingHook;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.util.thread.ProcessorMailbox;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkRenderDispatcher.class})
public abstract class Mixin_BlockOnChunkRebuilds
implements ForceChunkLoadingHook.IBlockOnChunkRebuilds {
    @Shadow
    @Final
    private Queue<ChunkBufferBuilderPack> f_112674_;
    @Shadow
    @Final
    private ProcessorMailbox<Runnable> f_112679_;
    @Shadow
    @Final
    private Queue<Runnable> f_112675_;
    private final Lock waitingForWorkLock = new ReentrantLock();
    private final Condition newWork = this.waitingForWorkLock.newCondition();
    private volatile boolean allDone;
    private int totalBufferCount;

    @Unique
    private int getAvailableBufferCount() {
        return this.f_112674_.size();
    }

    @Unique
    private boolean upload() {
        Runnable runnable;
        boolean anything = false;
        while ((runnable = this.f_112675_.poll()) != null) {
            runnable.run();
            anything = true;
        }
        return anything;
    }

    @Shadow
    protected abstract void m_112734_();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void rememberTotalThreads(CallbackInfo ci) {
        this.totalBufferCount = this.getAvailableBufferCount();
    }

    @Inject(method={"scheduleRunTasks"}, at={@At(value="RETURN")})
    private void notifyMainThreadIfEverythingIsDone(CallbackInfo ci) {
        if (this.getAvailableBufferCount() == this.totalBufferCount) {
            this.waitingForWorkLock.lock();
            try {
                this.allDone = true;
                this.newWork.signalAll();
            }
            finally {
                this.waitingForWorkLock.unlock();
            }
        } else {
            this.allDone = false;
        }
    }

    @Inject(method={"scheduleUpload"}, at={@At(value="RETURN")})
    private void notifyMainThreadOfNewUpload(CallbackInfoReturnable<CompletableFuture<Void>> ci) {
        this.waitingForWorkLock.lock();
        try {
            this.newWork.signal();
        }
        finally {
            this.waitingForWorkLock.unlock();
        }
    }

    private boolean waitForMainThreadWork() {
        boolean allDone = (Boolean)this.f_112679_.m_18720_(reply -> () -> {
            this.m_112734_();
            reply.m_6937_((Object)(this.getAvailableBufferCount() == this.totalBufferCount ? 1 : 0));
        }).join();
        if (allDone) {
            return true;
        }
        this.waitingForWorkLock.lock();
        try {
            while (true) {
                RenderSystem.replayQueue();
                if (this.allDone) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.f_112675_.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.newWork.awaitUninterruptibly();
            }
        }
        finally {
            this.waitingForWorkLock.unlock();
        }
    }

    @Override
    public boolean uploadEverythingBlocking() {
        boolean allChunksBuilt;
        boolean anything = false;
        do {
            allChunksBuilt = this.waitForMainThreadWork();
            while (this.upload()) {
                anything = true;
            }
        } while (!allChunksBuilt);
        return anything;
    }
}

