/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.capturer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.replaymod.core.versions.MCVer;
import com.replaymod.render.capturer.CaptureData;
import com.replaymod.render.capturer.RenderInfo;
import com.replaymod.render.capturer.WorldRenderer;
import com.replaymod.render.frame.OpenGlFrame;
import com.replaymod.render.rendering.Frame;
import com.replaymod.render.rendering.FrameCapturer;
import com.replaymod.render.utils.ByteBufferPool;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.WritableDimension;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public abstract class OpenGlFrameCapturer<F extends Frame, D extends CaptureData>
implements FrameCapturer<F> {
    protected final WorldRenderer worldRenderer;
    protected final RenderInfo renderInfo;
    protected int framesDone;
    private RenderTarget frameBuffer;
    protected final Minecraft mc = MCVer.getMinecraft();
    protected final ReadableDimension frameSize = new ReadableDimension(){

        public int getWidth() {
            return OpenGlFrameCapturer.this.getFrameWidth();
        }

        public int getHeight() {
            return OpenGlFrameCapturer.this.getFrameHeight();
        }

        public void getSize(WritableDimension dest) {
            dest.setSize(this.getWidth(), this.getHeight());
        }
    };

    public OpenGlFrameCapturer(WorldRenderer worldRenderer, RenderInfo renderInfo) {
        this.worldRenderer = worldRenderer;
        this.renderInfo = renderInfo;
    }

    protected int getFrameWidth() {
        return this.renderInfo.getFrameSize().getWidth();
    }

    protected int getFrameHeight() {
        return this.renderInfo.getFrameSize().getHeight();
    }

    protected RenderTarget frameBuffer() {
        if (this.frameBuffer == null) {
            this.frameBuffer = this.mc.m_91385_();
        }
        return this.frameBuffer;
    }

    @Override
    public boolean isDone() {
        return this.framesDone >= this.renderInfo.getTotalFrames();
    }

    protected OpenGlFrame renderFrame(int frameId, float partialTicks) {
        return this.renderFrame(frameId, partialTicks, null);
    }

    protected OpenGlFrame renderFrame(int frameId, float partialTicks, D captureData) {
        MCVer.resizeMainWindow(this.mc, this.getFrameWidth(), this.getFrameHeight());
        MCVer.pushMatrix();
        this.frameBuffer().m_83947_(true);
        RenderSystem.clear((int)16640, (boolean)false);
        this.worldRenderer.renderWorld(partialTicks, (CaptureData)captureData);
        this.frameBuffer().m_83970_();
        MCVer.popMatrix();
        return this.captureFrame(frameId, captureData);
    }

    protected OpenGlFrame captureFrame(int frameId, D captureData) {
        ByteBuffer buffer = ByteBufferPool.allocate(this.getFrameWidth() * this.getFrameHeight() * 4);
        this.frameBuffer().m_83947_(true);
        GL11.glReadPixels((int)0, (int)0, (int)this.getFrameWidth(), (int)this.getFrameHeight(), (int)32993, (int)5121, (ByteBuffer)buffer);
        this.frameBuffer().m_83970_();
        buffer.rewind();
        return new OpenGlFrame(frameId, (ReadableDimension)new Dimension(this.getFrameWidth(), this.getFrameHeight()), 4, buffer);
    }

    @Override
    public void close() throws IOException {
    }
}

