/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.capturer;

import com.replaymod.render.RenderSettings;
import com.replaymod.render.capturer.CubicOpenGlFrameCapturer;
import com.replaymod.render.capturer.CubicPboOpenGlFrameCapturer;
import com.replaymod.render.capturer.RenderInfo;
import com.replaymod.render.capturer.WorldRenderer;
import com.replaymod.render.frame.CubicOpenGlFrame;
import com.replaymod.render.frame.ODSOpenGlFrame;
import com.replaymod.render.frame.OpenGlFrame;
import com.replaymod.render.hooks.FogStateCallback;
import com.replaymod.render.hooks.Texture2DStateCallback;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.FrameCapturer;
import com.replaymod.render.shader.Program;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.resources.ResourceLocation;

public class ODSFrameCapturer
implements FrameCapturer<ODSOpenGlFrame> {
    private static final ResourceLocation vertexResource = new ResourceLocation("replaymod", "shader/ods.vert");
    private static final ResourceLocation fragmentResource = new ResourceLocation("replaymod", "shader/ods.frag");
    private final CubicPboOpenGlFrameCapturer left;
    private final CubicPboOpenGlFrameCapturer right;
    private final Program shaderProgram;
    private final Program.Uniform directionVariable;
    private final Program.Uniform leftEyeVariable;
    private EventRegistrations renderStateEvents;

    public ODSFrameCapturer(WorldRenderer worldRenderer, final RenderInfo renderInfo, int frameSize) {
        RenderInfo fakeInfo = new RenderInfo(){
            private int call;
            private float partialTicks;

            @Override
            public ReadableDimension getFrameSize() {
                return renderInfo.getFrameSize();
            }

            @Override
            public int getFramesDone() {
                return renderInfo.getFramesDone();
            }

            @Override
            public int getTotalFrames() {
                return renderInfo.getTotalFrames();
            }

            @Override
            public float updateForNextFrame() {
                if (this.call++ % 2 == 0) {
                    ODSFrameCapturer.this.unbindProgram();
                    this.partialTicks = renderInfo.updateForNextFrame();
                    ODSFrameCapturer.this.bindProgram();
                }
                return this.partialTicks;
            }

            @Override
            public RenderSettings getRenderSettings() {
                return renderInfo.getRenderSettings();
            }
        };
        this.left = new CubicStereoFrameCapturer(worldRenderer, fakeInfo, frameSize);
        this.right = new CubicStereoFrameCapturer(worldRenderer, fakeInfo, frameSize);
        try {
            this.shaderProgram = new Program(vertexResource, fragmentResource);
            this.leftEyeVariable = this.shaderProgram.getUniformVariable("leftEye");
            this.directionVariable = this.shaderProgram.getUniformVariable("direction");
        }
        catch (Exception e) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)e, (String)"Creating ODS shaders"));
        }
    }

    private void bindProgram() {
        this.shaderProgram.use();
        this.setTexture("texture", 0);
        this.setTexture("overlay", 1);
        this.setTexture("lightMap", 2);
        this.renderStateEvents = new EventRegistrations();
        Program.Uniform[] texture2DUniforms = new Program.Uniform[]{this.shaderProgram.getUniformVariable("textureEnabled"), this.shaderProgram.getUniformVariable("overlayEnabled"), this.shaderProgram.getUniformVariable("lightMapEnabled")};
        this.renderStateEvents.on(Texture2DStateCallback.EVENT, (id, enabled) -> {
            if (id >= 0 && id < texture2DUniforms.length) {
                texture2DUniforms[id].set(enabled);
            }
        });
        Program.Uniform fogUniform = this.shaderProgram.getUniformVariable("fogEnabled");
        this.renderStateEvents.on(FogStateCallback.EVENT, fogUniform::set);
        this.renderStateEvents.register();
    }

    private void unbindProgram() {
        this.renderStateEvents.unregister();
        this.renderStateEvents = null;
        this.shaderProgram.stopUsing();
    }

    private void setTexture(String texture, int i) {
        this.shaderProgram.getUniformVariable(texture).set(i);
    }

    @Override
    public boolean isDone() {
        return this.left.isDone() && this.right.isDone();
    }

    @Override
    public Map<Channel, ODSOpenGlFrame> process() {
        this.bindProgram();
        this.leftEyeVariable.set(true);
        Map leftChannels = this.left.process();
        this.leftEyeVariable.set(false);
        Map rightChannels = this.right.process();
        this.unbindProgram();
        if (leftChannels != null && rightChannels != null) {
            HashMap<Channel, ODSOpenGlFrame> result = new HashMap<Channel, ODSOpenGlFrame>();
            for (Channel channel : Channel.values()) {
                CubicOpenGlFrame leftFrame = (CubicOpenGlFrame)leftChannels.get((Object)channel);
                CubicOpenGlFrame rightFrame = (CubicOpenGlFrame)rightChannels.get((Object)channel);
                if (leftFrame == null || rightFrame == null) continue;
                result.put(channel, new ODSOpenGlFrame(leftFrame, rightFrame));
            }
            return result;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.left.close();
        this.right.close();
        this.shaderProgram.delete();
    }

    private class CubicStereoFrameCapturer
    extends CubicPboOpenGlFrameCapturer {
        public CubicStereoFrameCapturer(WorldRenderer worldRenderer, RenderInfo renderInfo, int frameSize) {
            super(worldRenderer, renderInfo, frameSize);
        }

        @Override
        protected OpenGlFrame renderFrame(int frameId, float partialTicks, CubicOpenGlFrameCapturer.Data captureData) {
            ODSFrameCapturer.this.directionVariable.set(captureData.ordinal());
            return super.renderFrame(frameId, partialTicks, captureData);
        }
    }
}

