/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.render.RenderSettings;
import com.replaymod.replay.camera.CameraEntity;
import de.javagl.jgltf.impl.v2.Accessor;
import de.javagl.jgltf.impl.v2.Animation;
import de.javagl.jgltf.impl.v2.AnimationChannel;
import de.javagl.jgltf.impl.v2.AnimationChannelTarget;
import de.javagl.jgltf.impl.v2.AnimationSampler;
import de.javagl.jgltf.impl.v2.Asset;
import de.javagl.jgltf.impl.v2.Buffer;
import de.javagl.jgltf.impl.v2.BufferView;
import de.javagl.jgltf.impl.v2.Camera;
import de.javagl.jgltf.impl.v2.CameraPerspective;
import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.impl.v2.Node;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.io.v2.GltfAssetWriterV2;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Quaternion;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector4f;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.io.FilenameUtils;

public class CameraPathExporter {
    private final Minecraft mc = MCVer.getMinecraft();
    private final RenderSettings settings;
    private int framesDone;
    private ByteBuffer timeBuffer;
    private ByteBuffer cameraTranslationBuffer;
    private ByteBuffer cameraRotationBuffer;

    public CameraPathExporter(RenderSettings settings) {
        this.settings = settings;
    }

    public void setup(int totalFrames) {
        this.timeBuffer = ByteBuffer.allocate(4 * totalFrames).order(ByteOrder.LITTLE_ENDIAN);
        this.cameraTranslationBuffer = ByteBuffer.allocate(4 * totalFrames * 3).order(ByteOrder.LITTLE_ENDIAN);
        this.cameraRotationBuffer = ByteBuffer.allocate(4 * totalFrames * 4).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void recordFrame(float tickDelta) {
        LocalPlayer entity = this.mc.m_91288_() == null ? this.mc.f_91074_ : this.mc.m_91288_();
        net.minecraft.client.Camera camera = this.mc.f_91063_.m_109153_();
        Vec3 vec = camera.m_90583_();
        float x = (float)vec.m_7096_();
        float y = (float)vec.m_7098_();
        float z = (float)vec.m_7094_();
        float yaw = camera.m_90590_() + 180.0f;
        float pitch = camera.m_90589_();
        float roll = entity instanceof CameraEntity ? ((CameraEntity)entity).roll : 0.0f;
        Quaternion quatYaw = new Quaternion();
        Quaternion quatPitch = new Quaternion();
        Quaternion quatRoll = new Quaternion();
        quatYaw.setFromAxisAngle(new Vector4f(0.0f, -1.0f, 0.0f, (float)Math.toRadians(yaw)));
        quatPitch.setFromAxisAngle(new Vector4f(-1.0f, 0.0f, 0.0f, (float)Math.toRadians(pitch)));
        quatRoll.setFromAxisAngle(new Vector4f(0.0f, 0.0f, -1.0f, (float)Math.toRadians(roll)));
        Quaternion quaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        Quaternion.mul((Quaternion)quaternion, (Quaternion)quatYaw, (Quaternion)quaternion);
        Quaternion.mul((Quaternion)quaternion, (Quaternion)quatPitch, (Quaternion)quaternion);
        Quaternion.mul((Quaternion)quaternion, (Quaternion)quatRoll, (Quaternion)quaternion);
        quaternion.normalise(quaternion);
        float[] translation = new float[]{x, y, z};
        float[] rotation = new float[]{quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getW()};
        this.timeBuffer.putFloat((float)this.framesDone / (float)this.settings.getFramesPerSecond());
        for (float f : translation) {
            this.cameraTranslationBuffer.putFloat(f);
        }
        for (float f : rotation) {
            this.cameraRotationBuffer.putFloat(f);
        }
        ++this.framesDone;
    }

    public void finish() throws IOException {
        Path glbBasePath;
        int timeBufferSize = this.timeBuffer.rewind().remaining();
        int cameraTranslationBufferSize = this.cameraTranslationBuffer.rewind().remaining();
        int cameraRotationBufferSize = this.cameraRotationBuffer.rewind().remaining();
        int binaryDataSize = 0;
        binaryDataSize += timeBufferSize;
        binaryDataSize += cameraTranslationBufferSize;
        ByteBuffer binaryData = ByteBuffer.allocate(binaryDataSize += cameraRotationBufferSize);
        int timeBufferOffset = binaryData.position();
        binaryData.put(this.timeBuffer);
        int cameraTranslationBufferOffset = binaryData.position();
        binaryData.put(this.cameraTranslationBuffer);
        int cameraRotationBufferOffset = binaryData.position();
        binaryData.put(this.cameraRotationBuffer);
        binaryData.rewind();
        GlTF glTF = new GlTF();
        glTF.setAsset(Utils.configure(new Asset(), asset -> {
            asset.setVersion("2.0");
            asset.setGenerator("ReplayMod v" + ReplayMod.instance.getVersion());
        }));
        glTF.addAnimations(Utils.configure(new Animation(), animation -> {
            animation.addChannels(Utils.configure(new AnimationChannel(), channel -> {
                channel.setTarget(Utils.configure(new AnimationChannelTarget(), target -> {
                    target.setNode(Integer.valueOf(0));
                    target.setPath("translation");
                }));
                channel.setSampler(Integer.valueOf(0));
            }));
            animation.addChannels(Utils.configure(new AnimationChannel(), channel -> {
                channel.setTarget(Utils.configure(new AnimationChannelTarget(), target -> {
                    target.setNode(Integer.valueOf(0));
                    target.setPath("rotation");
                }));
                channel.setSampler(Integer.valueOf(1));
            }));
            animation.addSamplers(Utils.configure(new AnimationSampler(), sampler -> {
                sampler.setInput(Integer.valueOf(0));
                sampler.setOutput(Integer.valueOf(1));
            }));
            animation.addSamplers(Utils.configure(new AnimationSampler(), sampler -> {
                sampler.setInput(Integer.valueOf(0));
                sampler.setOutput(Integer.valueOf(2));
            }));
        }));
        glTF.addCameras(Utils.configure(new Camera(), camera -> {
            camera.setType("perspective");
            camera.setPerspective(Utils.configure(new CameraPerspective(), perspective -> {
                float aspectRatio = (float)this.settings.getVideoWidth() / (float)this.settings.getVideoHeight();
                perspective.setAspectRatio(Float.valueOf(aspectRatio));
                perspective.setYfov(Float.valueOf((float)Math.toRadians(((Integer)this.mc.f_91066_.m_231837_().m_231551_()).intValue())));
                perspective.setZnear(Float.valueOf(0.05f));
                perspective.setZfar(Float.valueOf((float)((Integer)this.mc.f_91066_.m_231984_().m_231551_()).intValue() * 16.0f * 4.0f));
            }));
        }));
        glTF.addNodes(Utils.configure(new Node(), node -> node.setCamera(Integer.valueOf(0))));
        glTF.addBuffers(Utils.configure(new Buffer(), buffer -> buffer.setByteLength(Integer.valueOf(binaryData.limit()))));
        glTF.addBufferViews(Utils.configure(new BufferView(), bufferView -> {
            bufferView.setBuffer(Integer.valueOf(0));
            bufferView.setByteOffset(Integer.valueOf(timeBufferOffset));
            bufferView.setByteLength(Integer.valueOf(timeBufferSize));
        }));
        glTF.addAccessors(Utils.configure(new Accessor(), accessor -> {
            accessor.setBufferView(Integer.valueOf(0));
            accessor.setType("SCALAR");
            accessor.setComponentType(Integer.valueOf(5126));
            accessor.setCount(Integer.valueOf(this.framesDone));
        }));
        glTF.addBufferViews(Utils.configure(new BufferView(), bufferView -> {
            bufferView.setBuffer(Integer.valueOf(0));
            bufferView.setByteOffset(Integer.valueOf(cameraTranslationBufferOffset));
            bufferView.setByteLength(Integer.valueOf(cameraTranslationBufferSize));
        }));
        glTF.addAccessors(Utils.configure(new Accessor(), accessor -> {
            accessor.setBufferView(Integer.valueOf(1));
            accessor.setType("VEC3");
            accessor.setComponentType(Integer.valueOf(5126));
            accessor.setCount(Integer.valueOf(this.framesDone));
        }));
        glTF.addBufferViews(Utils.configure(new BufferView(), bufferView -> {
            bufferView.setBuffer(Integer.valueOf(0));
            bufferView.setByteOffset(Integer.valueOf(cameraRotationBufferOffset));
            bufferView.setByteLength(Integer.valueOf(cameraRotationBufferSize));
        }));
        glTF.addAccessors(Utils.configure(new Accessor(), accessor -> {
            accessor.setBufferView(Integer.valueOf(2));
            accessor.setType("VEC4");
            accessor.setComponentType(Integer.valueOf(5126));
            accessor.setCount(Integer.valueOf(this.framesDone));
        }));
        Path videoPath = this.settings.getOutputFile().toPath();
        Path glbPath = glbBasePath = Files.isDirectory(videoPath, new LinkOption[0]) ? videoPath.resolve("camera.glb") : videoPath.resolveSibling(FilenameUtils.getBaseName((String)videoPath.getFileName().toString()) + ".glb");
        int i = 0;
        while (Files.exists(glbPath, new LinkOption[0])) {
            String baseName = FilenameUtils.getBaseName((String)glbBasePath.getFileName().toString());
            glbPath = glbBasePath.resolveSibling(baseName + "." + i + ".glb");
            ++i;
        }
        try (OutputStream out = Files.newOutputStream(glbPath, new OpenOption[0]);){
            GltfAssetV2 asset2 = new GltfAssetV2(glTF, binaryData);
            new GltfAssetWriterV2().writeBinary(asset2, out);
        }
    }
}

