/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.handler;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.core.gui.GuiReplayButton;
import com.replaymod.recording.ServerInfoExt;
import com.replaymod.recording.Setting;
import com.replaymod.recording.mixin.AddServerScreenAccessor;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.container.VanillaGuiScreen;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiCheckbox;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiToggleButton;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.popup.GuiInfoPopup;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.InitScreenCallback;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.language.I18n;

public class GuiHandler
extends EventRegistrations {
    private final ReplayMod mod;

    public GuiHandler(ReplayMod mod) {
        this.on(InitScreenCallback.EVENT, (screen, buttons) -> this.onGuiInit(screen));
        this.mod = mod;
    }

    private void onGuiInit(Screen gui) {
        if (gui instanceof SelectWorldScreen || gui instanceof JoinMultiplayerScreen) {
            boolean sp = gui instanceof SelectWorldScreen;
            SettingsRegistry settingsRegistry = this.mod.getSettingsRegistry();
            Setting<Boolean> setting = sp ? Setting.RECORD_SINGLEPLAYER : Setting.RECORD_SERVER;
            final GuiCheckbox recordingCheckbox = (GuiCheckbox)((GuiCheckbox)new GuiCheckbox().setI18nLabel("replaymod.gui.settings.record" + (sp ? "singleplayer" : "server"), new Object[0])).setChecked(settingsRegistry.get(setting));
            recordingCheckbox.onClick(() -> {
                settingsRegistry.set(setting, recordingCheckbox.isChecked());
                settingsRegistry.save();
            });
            VanillaGuiScreen vanillaGui = VanillaGuiScreen.wrap(gui);
            ((GuiScreen)vanillaGui.setLayout(new CustomLayout<GuiScreen>(vanillaGui.getLayout()){

                @Override
                protected void layout(GuiScreen container, int width, int height) {
                    this.pos(recordingCheckbox, width - this.width(recordingCheckbox) - 5, 5);
                }
            })).addElements(null, new GuiElement[]{recordingCheckbox});
        }
        if (gui instanceof EditServerScreen) {
            VanillaGuiScreen vanillaGui = VanillaGuiScreen.wrap(gui);
            final GuiButton replayButton = (GuiButton)new GuiReplayButton().onClick(() -> {
                ServerData serverInfo = ((AddServerScreenAccessor)gui).getServer();
                ServerInfoExt serverInfoExt = ServerInfoExt.from(serverInfo);
                Boolean state = serverInfoExt.getAutoRecording();
                GuiToggleButton autoRecording = (GuiToggleButton)((GuiToggleButton)((GuiToggleButton)new GuiToggleButton().setI18nLabel("replaymod.gui.settings.autostartrecording", new Object[0])).setValues(new String[]{I18n.m_118938_((String)"replaymod.gui.settings.default", (Object[])new Object[0]), I18n.m_118938_((String)"options.off", (Object[])new Object[0]), I18n.m_118938_((String)"options.on", (Object[])new Object[0])})).setSelected(state == null ? 0 : (state != false ? 2 : 1));
                autoRecording.onClick(() -> {
                    int selected = autoRecording.getSelected();
                    serverInfoExt.setAutoRecording(selected == 0 ? null : Boolean.valueOf(selected == 2));
                });
                GuiInfoPopup.open((GuiContainer)vanillaGui, autoRecording);
            });
            ((GuiScreen)vanillaGui.setLayout(new CustomLayout<GuiScreen>(vanillaGui.getLayout()){

                @Override
                protected void layout(GuiScreen container, int width, int height) {
                    this.size(replayButton, 20, 20);
                    this.pos(replayButton, width - this.width(replayButton) - 5, 5);
                }
            })).addElements(null, new GuiElement[]{replayButton});
        }
    }
}

