/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.gui;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.recording.packet.PacketListener;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.container.VanillaGuiScreen;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.InitScreenCallback;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;

public class GuiRecordingControls
extends EventRegistrations {
    private ReplayMod core;
    private PacketListener packetListener;
    private boolean paused;
    private boolean stopped;
    private GuiPanel panel = (GuiPanel)new GuiPanel().setLayout(new HorizontalLayout().setSpacing(4));
    private GuiButton buttonPauseResume = (GuiButton)((GuiButton)new GuiButton(this.panel).onClick(() -> {
        if (Utils.ifMinimalModeDoPopup(this.panel, () -> {})) {
            return;
        }
        if (this.paused) {
            this.packetListener.addMarker("_RM_END_CUT");
        } else {
            this.packetListener.addMarker("_RM_START_CUT");
        }
        this.paused = !this.paused;
        this.updateState();
    })).setSize(98, 20);
    private GuiButton buttonStartStop = (GuiButton)((GuiButton)new GuiButton(this.panel).onClick(() -> {
        if (Utils.ifMinimalModeDoPopup(this.panel, () -> {})) {
            return;
        }
        if (this.stopped) {
            this.paused = false;
            this.packetListener.addMarker("_RM_END_CUT");
            this.core.printInfoToChat("replaymod.chat.recordingstarted", new Object[0]);
        } else {
            int timestamp = (int)this.packetListener.getCurrentDuration();
            if (!this.paused) {
                this.packetListener.addMarker("_RM_START_CUT", timestamp);
            }
            this.packetListener.addMarker("_RM_SPLIT", timestamp + 1);
        }
        this.stopped = !this.stopped;
        this.updateState();
    })).setSize(98, 20);

    public GuiRecordingControls(ReplayMod core, PacketListener packetListener, boolean autoStart) {
        this.on(InitScreenCallback.EVENT, this::injectIntoIngameMenu);
        this.core = core;
        this.packetListener = packetListener;
        this.stopped = !autoStart;
        this.paused = this.stopped;
        this.updateState();
    }

    private void updateState() {
        this.buttonPauseResume.setI18nLabel("replaymod.gui.recording." + (this.paused ? "resume" : "pause"), new Object[0]);
        this.buttonStartStop.setI18nLabel("replaymod.gui.recording." + (this.stopped ? "start" : "stop"), new Object[0]);
        this.buttonPauseResume.setEnabled(!this.stopped);
    }

    private void injectIntoIngameMenu(Screen guiScreen, Collection<AbstractWidget> buttonList) {
        if (!(guiScreen instanceof PauseScreen)) {
            return;
        }
        if (buttonList.isEmpty()) {
            return;
        }
        final Function<Integer, Integer> yPos = MCVer.findButton(buttonList, "menu.returnToMenu", 1).map(Optional::of).orElse(MCVer.findButton(buttonList, "menu.disconnect", 1)).map(it -> height -> it.m_252907_()).orElse(height -> height / 4 + 120 - 16);
        VanillaGuiScreen vanillaGui = VanillaGuiScreen.wrap(guiScreen);
        ((GuiScreen)vanillaGui.setLayout(new CustomLayout<GuiScreen>(vanillaGui.getLayout()){

            @Override
            protected void layout(GuiScreen container, int width, int height) {
                this.pos(GuiRecordingControls.this.panel, width / 2 - 100, (Integer)yPos.apply(height) + 16 + 8);
            }
        })).addElements(null, new GuiElement[]{this.panel});
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

