/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording;

import com.replaymod.core.KeyBindingRegistry;
import com.replaymod.core.Module;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.Restrictions;
import com.replaymod.recording.Setting;
import com.replaymod.recording.handler.ConnectionEventHandler;
import com.replaymod.recording.handler.GuiHandler;
import com.replaymod.recording.mixin.NetworkManagerAccessor;
import com.replaymod.recording.packet.PacketListener;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplayModRecording
implements Module {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AttributeKey<Void> ATTR_CHECKED = AttributeKey.newInstance((String)"ReplayModRecording_checked");
    public static ReplayModRecording instance;
    private ReplayMod core;
    private ConnectionEventHandler connectionEventHandler;

    public ReplayModRecording(ReplayMod mod) {
        instance = this;
        this.core = mod;
        this.core.getSettingsRegistry().register(Setting.class);
    }

    @Override
    public void registerKeyBindings(KeyBindingRegistry registry) {
        registry.registerKeyBinding("replaymod.input.marker", 77, new Runnable(){

            @Override
            public void run() {
                PacketListener packetListener = ReplayModRecording.this.connectionEventHandler.getPacketListener();
                if (packetListener != null) {
                    packetListener.addMarker(null);
                    ReplayModRecording.this.core.printInfoToChat("replaymod.chat.addedmarker", new Object[0]);
                }
            }
        }, false);
    }

    @Override
    public void initClient() {
        this.connectionEventHandler = new ConnectionEventHandler(LOGGER, this.core);
        new GuiHandler(this.core).register();
        NetworkRegistry.newEventChannel((ResourceLocation)Restrictions.PLUGIN_CHANNEL, () -> "0", s -> true, s -> true);
    }

    public void initiateRecording(Connection networkManager) {
        Channel channel = ((NetworkManagerAccessor)networkManager).getChannel();
        if (channel.pipeline().get("ReplayModReplay_replaySender") != null) {
            return;
        }
        if (channel.hasAttr(ATTR_CHECKED)) {
            return;
        }
        channel.attr(ATTR_CHECKED).set(null);
        this.connectionEventHandler.onConnectedToServerEvent(networkManager);
    }

    public ConnectionEventHandler getConnectionEventHandler() {
        return this.connectionEventHandler;
    }
}

