/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.mixin;

import com.replaymod.core.ReplayMod;
import com.replaymod.replay.ReplayModReplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyMapping.class})
public class Mixin_ContextualKeyBindings {
    @Shadow
    @Final
    private static Map<String, KeyMapping> f_90809_;
    @Unique
    private static final List<KeyMapping> temporarilyRemoved;

    @Unique
    private static Collection<KeyMapping> keyBindings() {
        return f_90809_.values();
    }

    @Inject(method={"updateKeysByCode"}, at={@At(value="HEAD")})
    private static void preContextualKeyBindings(CallbackInfo ci) {
        ReplayMod mod = ReplayMod.instance;
        if (mod == null) {
            return;
        }
        Set<KeyMapping> onlyInReplay = mod.getKeyBindingRegistry().getOnlyInReplay();
        if (ReplayModReplay.instance.getReplayHandler() != null) {
            Mixin_ContextualKeyBindings.keyBindings().removeIf(keyBinding -> {
                for (KeyMapping exclusiveBinding : onlyInReplay) {
                    if (!keyBinding.m_90850_(exclusiveBinding) || keyBinding == exclusiveBinding) continue;
                    temporarilyRemoved.add((KeyMapping)keyBinding);
                    return true;
                }
                return false;
            });
        } else {
            Mixin_ContextualKeyBindings.keyBindings().removeIf(keyBinding -> {
                if (onlyInReplay.contains(keyBinding)) {
                    temporarilyRemoved.add((KeyMapping)keyBinding);
                    return true;
                }
                return false;
            });
        }
    }

    @Inject(method={"updateKeysByCode"}, at={@At(value="RETURN")})
    private static void postContextualKeyBindings(CallbackInfo ci) {
        for (KeyMapping keyBinding : temporarilyRemoved) {
            f_90809_.put(keyBinding.m_90860_(), keyBinding);
        }
        temporarilyRemoved.clear();
    }

    static {
        temporarilyRemoved = new ArrayList<KeyMapping>();
    }
}

