/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.netty.handler.codec.socks;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.handler.codec.socks.SocksAuthStatus;
import com.github.steveice10.netty.handler.codec.socks.SocksResponse;
import com.github.steveice10.netty.handler.codec.socks.SocksResponseType;
import com.github.steveice10.netty.handler.codec.socks.SocksSubnegotiationVersion;
import com.github.steveice10.netty.util.internal.ObjectUtil;

public final class SocksAuthResponse
extends SocksResponse {
    private static final SocksSubnegotiationVersion SUBNEGOTIATION_VERSION = SocksSubnegotiationVersion.AUTH_PASSWORD;
    private final SocksAuthStatus authStatus;

    public SocksAuthResponse(SocksAuthStatus authStatus) {
        super(SocksResponseType.AUTH);
        this.authStatus = ObjectUtil.checkNotNull(authStatus, "authStatus");
    }

    public SocksAuthStatus authStatus() {
        return this.authStatus;
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(SUBNEGOTIATION_VERSION.byteValue());
        byteBuf.writeByte(this.authStatus.byteValue());
    }
}

