/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.ai.BarkAtDarknessGoal;
import org.violetmoon.quark.content.mobs.ai.DeliverFetchedItemGoal;
import org.violetmoon.quark.content.mobs.ai.FetchArrowGoal;
import org.violetmoon.quark.content.mobs.module.ShibaModule;
import org.violetmoon.quark.content.tweaks.ai.NuzzleGoal;
import org.violetmoon.quark.content.tweaks.ai.WantLoveGoal;

public class Shiba
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.m_135353_(Shiba.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> MOUTH_ITEM = SynchedEntityData.m_135353_(Shiba.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> FETCHING = SynchedEntityData.m_135353_(Shiba.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public BlockPos currentHyperfocus = null;
    private int hyperfocusCooldown = 0;

    public Shiba(EntityType<? extends Shiba> type, Level worldIn) {
        super(type, worldIn);
        this.m_7105_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new BarkAtDarknessGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FetchArrowGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DeliverFetchedItemGoal(this, 1.1, -1.0f, 32.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_}), false));
        this.f_21345_.m_25352_(8, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new NuzzleGoal(this, 0.5, 16.0f, 2.0f, QuarkSounds.ENTITY_SHIBA_WHINE));
        this.f_21345_.m_25352_(10, (Goal)new WantLoveGoal(this, 0.2f));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(13, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        LivingEntity owner;
        super.m_8119_();
        AbstractArrow fetching = this.getFetching();
        if (fetching != null && (this.m_5803_() || fetching.m_9236_() != this.m_9236_() || !fetching.m_6084_() || fetching.f_36705_ == AbstractArrow.Pickup.DISALLOWED)) {
            this.setFetching(null);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.hyperfocusCooldown > 0) {
                --this.hyperfocusCooldown;
            }
            if (fetching != null || this.m_5803_() || this.m_21825_() || !this.m_21824_() || this.m_21523_()) {
                this.currentHyperfocus = null;
            } else {
                owner = this.m_269323_();
                if (this.currentHyperfocus != null) {
                    boolean ownerAbsent;
                    boolean hyperfocusClear = this.m_9236_().m_45517_(LightLayer.BLOCK, this.currentHyperfocus) > 0;
                    boolean bl = ownerAbsent = owner == null || owner instanceof Player && !owner.m_21205_().m_150930_(Items.f_42000_) && !owner.m_21206_().m_150930_(Items.f_42000_);
                    if (hyperfocusClear || ownerAbsent) {
                        this.currentHyperfocus = null;
                        this.hyperfocusCooldown = 40;
                        if (hyperfocusClear && !ownerAbsent && owner instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)owner;
                            ShibaModule.shibaHelpTrigger.trigger(sp);
                        }
                    }
                }
                if (this.currentHyperfocus == null && owner instanceof Player) {
                    Player player = (Player)owner;
                    if (this.hyperfocusCooldown == 0 && (player.m_21205_().m_150930_(Items.f_42000_) || player.m_21206_().m_150930_(Items.f_42000_))) {
                        BlockPos ourPos = this.m_20183_();
                        int searchRange = 10;
                        for (int i = 0; i < 20; ++i) {
                            BlockPos test = ourPos.m_7918_(this.f_19796_.m_188503_(21) - 10, this.f_19796_.m_188503_(21) - 10, this.f_19796_.m_188503_(21) - 10);
                            if (!this.hasLineOfSight(test.m_7494_(), 10.0) || !this.m_9236_().m_8055_(test).m_60795_() || !this.m_9236_().m_8055_(test.m_7495_()).m_60804_((BlockGetter)this.m_9236_(), test.m_7495_()) || this.m_9236_().m_45517_(LightLayer.BLOCK, test) != 0 || ShibaModule.ignoreAreasWithSkylight && this.m_9236_().m_45527_(test)) continue;
                            this.currentHyperfocus = test;
                        }
                    }
                }
            }
        }
        if (!this.m_5803_() && !this.m_9236_().f_46443_ && fetching == null && this.getMouthItem().m_41619_() && (owner = this.m_269323_()) != null) {
            AABB check = owner.m_20191_().m_82400_(2.0);
            List arrows = this.m_9236_().m_6443_(AbstractArrow.class, check, a -> a.m_19749_() == owner && a.f_36705_ != AbstractArrow.Pickup.DISALLOWED);
            if (arrows.size() > 0) {
                AbstractArrow arrow = (AbstractArrow)arrows.get(this.m_9236_().f_46441_.m_188503_(arrows.size()));
                this.setFetching(arrow);
            }
        }
    }

    public boolean hasLineOfSight(BlockPos pos, double maxRange) {
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (vec31.m_82554_(vec3) > maxRange) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public AbstractArrow getFetching() {
        int id = (Integer)this.f_19804_.m_135370_(FETCHING);
        if (id == -1) {
            return null;
        }
        Entity e = this.m_9236_().m_6815_(id);
        if (!(e instanceof AbstractArrow)) {
            return null;
        }
        return (AbstractArrow)e;
    }

    public void setFetching(AbstractArrow e) {
        this.f_19804_.m_135381_(FETCHING, (Object)(e == null ? -1 : e.m_19879_()));
    }

    public boolean m_6898_(ItemStack stack) {
        Item item = stack.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(MOUTH_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(FETCHING, (Object)-1);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor collarcolor) {
        this.f_19804_.m_135381_(COLLAR_COLOR, (Object)collarcolor.m_41060_());
    }

    public ItemStack getMouthItem() {
        return (ItemStack)this.f_19804_.m_135370_(MOUTH_ITEM);
    }

    public void setMouthItem(ItemStack stack) {
        this.f_19804_.m_135381_(MOUTH_ITEM, (Object)stack);
    }

    public int m_5792_() {
        return 8;
    }

    public boolean m_7848_(@NotNull Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof Shiba)) {
            return false;
        }
        Shiba wolfentity = (Shiba)otherAnimal;
        if (!wolfentity.m_21824_()) {
            return false;
        }
        if (wolfentity.m_5803_()) {
            return false;
        }
        return this.m_27593_() && wolfentity.m_27593_();
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        CompoundTag itemcmp = new CompoundTag();
        ItemStack holding = this.getMouthItem();
        if (!holding.m_41619_()) {
            holding.m_41739_(itemcmp);
        }
        compound.m_128365_("MouthItem", (Tag)itemcmp);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("CollarColor")) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
        if (compound.m_128441_("MouthItem")) {
            CompoundTag itemcmp = compound.m_128469_("MouthItem");
            this.setMouthItem(ItemStack.m_41712_((CompoundTag)itemcmp));
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Level level = this.m_9236_();
        if (player.m_20163_() && player.m_21205_().m_41619_()) {
            if (hand == InteractionHand.MAIN_HAND && WantLoveGoal.canPet(this)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 pos = this.m_20182_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
                    this.m_5496_(QuarkSounds.ENTITY_SHIBA_WHINE, 0.6f, 0.5f + (float)Math.random() * 0.5f);
                }
                WantLoveGoal.setPetTime(this);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else {
            if (level.f_46443_) {
                boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || item == Items.f_42500_ && !this.m_21824_();
                return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            if (this.m_21824_()) {
                ItemStack mouthItem = this.getMouthItem();
                if (!mouthItem.m_41619_()) {
                    Level level2;
                    ItemStack copy = mouthItem.m_41777_();
                    if (!player.m_36356_(copy)) {
                        this.m_19983_(copy);
                    }
                    if ((level2 = player.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level2;
                        Vec3 pos = this.m_20182_();
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
                        this.m_5496_(QuarkSounds.ENTITY_SHIBA_WHINE, 0.6f, 0.5f + (float)Math.random() * 0.5f);
                    }
                    this.setMouthItem(ItemStack.f_41583_);
                    return InteractionResult.CONSUME;
                }
                if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5634_(item.m_41473_().m_38744_());
                    return InteractionResult.CONSUME;
                }
                if (!(item instanceof DyeItem)) {
                    if (!itemstack.m_41619_() && mouthItem.m_41619_() && itemstack.m_41720_() instanceof SwordItem) {
                        ItemStack copy = itemstack.m_41777_();
                        copy.m_41764_(1);
                        itemstack.m_41764_(itemstack.m_41613_() - 1);
                        this.setMouthItem(copy);
                        return InteractionResult.CONSUME;
                    }
                    InteractionResult actionresulttype = super.m_6071_(player, hand);
                    if ((!actionresulttype.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                        this.m_21839_(!this.m_21827_());
                        this.f_20899_ = false;
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        return InteractionResult.CONSUME;
                    }
                    return actionresulttype;
                }
                DyeColor dyecolor = ((DyeItem)item).m_41089_();
                if (dyecolor != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.CONSUME;
                }
            } else if (item == Items.f_42500_) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    WantLoveGoal.setPetTime(this);
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    level.m_7605_((Entity)this, (byte)7);
                } else {
                    level.m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_(QuarkSounds.ENTITY_SHIBA_STEP, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21223_() / this.m_21233_() < 0.5f ? QuarkSounds.ENTITY_SHIBA_WHINE : QuarkSounds.ENTITY_SHIBA_PANT;
        }
        return QuarkSounds.ENTITY_SHIBA_AMBIENT;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_SHIBA_HURT;
    }

    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_SHIBA_DEATH;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public AgeableMob m_142606_(@NotNull ServerLevel world, @NotNull AgeableMob mate) {
        Shiba wolfentity = (Shiba)ShibaModule.shibaType.m_20615_((Level)world);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            wolfentity.m_21816_(uuid);
            wolfentity.m_7105_(true);
        }
        return wolfentity;
    }
}

