/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.particle.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class ColorParticleTypeData
implements ParticleOptions {
    protected ParticleType<? extends ColorParticleTypeData> type;
    public static final Codec<ColorParticleTypeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.BOOL.fieldOf("disableDepthTest").forGetter(d -> d.disableDepthTest), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(d -> Float.valueOf(d.alpha)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age)).apply((Applicative)instance, ColorParticleTypeData::new));
    public ParticleColor color;
    public boolean disableDepthTest;
    public float size = 0.25f;
    public float alpha = 1.0f;
    public int age = 36;
    static final ParticleOptions.Deserializer<ColorParticleTypeData> DESERIALIZER = new ParticleOptions.Deserializer<ColorParticleTypeData>(){

        public ColorParticleTypeData fromCommand(ParticleType<ColorParticleTypeData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new ColorParticleTypeData(type, ParticleColor.fromString(reader.readString()), reader.readBoolean());
        }

        public ColorParticleTypeData fromNetwork(ParticleType<ColorParticleTypeData> type, FriendlyByteBuf buffer) {
            return new ColorParticleTypeData(type, ParticleColorRegistry.from(buffer.m_130260_()), buffer.readBoolean());
        }
    };

    public ColorParticleTypeData(float r, float g, float b, boolean disableDepthTest, float size, float alpha, int age) {
        this((ParticleType<? extends ColorParticleTypeData>)((ParticleType)ModParticles.GLOW_TYPE.get()), new ParticleColor(r, g, b), disableDepthTest, size, alpha, age);
    }

    public ColorParticleTypeData(ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        this((ParticleType<? extends ColorParticleTypeData>)((ParticleType)ModParticles.GLOW_TYPE.get()), color, disableDepthTest, size, alpha, age);
    }

    public ColorParticleTypeData(ParticleType<? extends ColorParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest) {
        this(particleTypeData, color, disableDepthTest, 0.25f, 1.0f, 36);
    }

    public ColorParticleTypeData(ParticleType<? extends ColorParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        this.type = particleTypeData;
        this.color = color;
        this.disableDepthTest = disableDepthTest;
        this.size = size;
        this.alpha = alpha;
        this.age = age;
    }

    public ParticleType<? extends ColorParticleTypeData> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.color.serialize());
    }

    public String m_5942_() {
        return RegistryHelper.getRegistryName(this.type).toString() + " " + this.color.serialize();
    }
}

