/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.radial_menu;

import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.SecondaryIconPosition;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiRadialMenu<T>
extends Screen {
    private static final float PRECISION = 5.0f;
    private static final int MAX_SLOTS = 20;
    private boolean closing;
    private boolean holdToOpenGUI;
    private RadialMenu<T> radialMenu;
    private List<RadialMenuSlot<T>> radialMenuSlots;
    final float OPEN_ANIMATION_LENGTH = 0.4f;
    private float totalTime;
    private float prevTick;
    private float extraTick;
    private int selectedItem;
    public ItemRenderer itemRenderer;

    public GuiRadialMenu(RadialMenu<T> radialMenu) {
        super((Component)Component.m_237113_((String)""));
        this.radialMenu = radialMenu;
        this.radialMenuSlots = this.radialMenu.getRadialMenuSlots();
        this.closing = false;
        this.holdToOpenGUI = (Boolean)Config.TOGGLE_RADIAL_HUD.get() == false;
        this.f_96541_ = Minecraft.m_91087_();
        this.selectedItem = -1;
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.m_91087_().f_91080_ instanceof GuiRadialMenu) {
            Options settings = Minecraft.m_91087_().f_91066_;
            Input eInput = event.getInput();
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            eInput.f_108568_ = InputConstants.m_84830_((long)window, (int)settings.f_92085_.getKey().m_84873_());
            eInput.f_108569_ = InputConstants.m_84830_((long)window, (int)settings.f_92087_.getKey().m_84873_());
            eInput.f_108570_ = InputConstants.m_84830_((long)window, (int)settings.f_92086_.getKey().m_84873_());
            eInput.f_108571_ = InputConstants.m_84830_((long)window, (int)settings.f_92088_.getKey().m_84873_());
            float f = eInput.f_108568_ == eInput.f_108569_ ? 0.0f : (eInput.f_108567_ = eInput.f_108568_ ? 1.0f : -1.0f);
            eInput.f_108566_ = eInput.f_108570_ == eInput.f_108571_ ? 0.0f : (eInput.f_108570_ ? 1.0f : -1.0f);
            eInput.f_108572_ = InputConstants.m_84830_((long)window, (int)settings.f_92089_.getKey().m_84873_());
            eInput.f_108573_ = InputConstants.m_84830_((long)window, (int)settings.f_92090_.getKey().m_84873_());
            if (Minecraft.m_91087_().f_91074_.m_108635_()) {
                eInput.f_108566_ = (float)((double)eInput.f_108566_ * 0.3);
                eInput.f_108567_ = (float)((double)eInput.f_108567_ * 0.3);
            }
        }
    }

    public void m_86600_() {
        if (this.totalTime != 0.4f) {
            this.extraTick += 1.0f;
        }
        if (this.holdToOpenGUI) {
            int openRadialKey = ModKeyBindings.OPEN_RADIAL_HUD.getKey().m_84873_();
            boolean radialKeyIsDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)openRadialKey);
            if (!radialKeyIsDown) {
                if (this.selectedItem != -1) {
                    this.radialMenu.setCurrentSlot(this.selectedItem);
                }
                this.f_96541_.f_91074_.m_6915_();
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int adjusted;
        float sliceBorderRight;
        float sliceBorderLeft;
        int i;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        PoseStack ms = graphics.m_280168_();
        float openAnimation = this.closing ? 1.0f - this.totalTime / 0.4f : this.totalTime / 0.4f;
        float currTick = this.f_96541_.m_91296_();
        this.totalTime += (currTick + this.extraTick - this.prevTick) / 20.0f;
        this.extraTick = 0.0f;
        this.prevTick = currTick;
        float animProgress = Mth.m_14036_((float)openAnimation, (float)0.0f, (float)1.0f);
        animProgress = (float)(1.0 - Math.pow(1.0f - animProgress, 3.0));
        float radiusIn = Math.max(0.1f, 45.0f * animProgress);
        float radiusOut = radiusIn * 2.0f;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;
        int centerOfScreenX = this.f_96543_ / 2;
        int centerOfScreenY = this.f_96544_ / 2;
        int numberOfSlices = Math.min(20, this.radialMenuSlots.size());
        double mousePositionInDegreesInRelationToCenterOfScreen = Math.toDegrees(Math.atan2(mouseY - centerOfScreenY, mouseX - centerOfScreenX));
        double mouseDistanceToCenterOfScreen = Math.sqrt(Math.pow(mouseX - centerOfScreenX, 2.0) + Math.pow(mouseY - centerOfScreenY, 2.0));
        float slot0 = (-0.5f / (float)numberOfSlices + 0.25f) * 360.0f;
        if (mousePositionInDegreesInRelationToCenterOfScreen < (double)slot0) {
            mousePositionInDegreesInRelationToCenterOfScreen += 360.0;
        }
        ms.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        boolean hasMouseOver = false;
        int mousedOverSlot = -1;
        if (!this.closing) {
            this.selectedItem = -1;
            for (i = 0; i < numberOfSlices; ++i) {
                sliceBorderLeft = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                sliceBorderRight = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                if (!(mousePositionInDegreesInRelationToCenterOfScreen >= (double)sliceBorderLeft) || !(mousePositionInDegreesInRelationToCenterOfScreen < (double)sliceBorderRight) || !(mouseDistanceToCenterOfScreen >= (double)radiusIn) || !(mouseDistanceToCenterOfScreen < (double)radiusOut)) continue;
                this.selectedItem = i;
                break;
            }
        }
        for (i = 0; i < numberOfSlices; ++i) {
            sliceBorderLeft = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            sliceBorderRight = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            if (this.selectedItem == i) {
                this.drawSlice(buffer, centerOfScreenX, centerOfScreenY, 10.0f, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 63, 161, 191, 60);
                hasMouseOver = true;
                mousedOverSlot = this.selectedItem;
                continue;
            }
            this.drawSlice(buffer, centerOfScreenX, centerOfScreenY, 10.0f, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 0, 0, 0, 64);
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
        if (hasMouseOver && mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices - 1;
            adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
            String string = this.radialMenuSlots.get(adjusted).slotName();
            int n = this.f_96543_ / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280137_(this.f_96547_, string, n, (this.f_96544_ - 9) / 2, 0xFFFFFF);
        }
        ms.m_85849_();
        for (i = 0; i < numberOfSlices; ++i) {
            ItemStack stack = new ItemStack((ItemLike)Blocks.f_50493_);
            float angle1 = ((float)i / (float)numberOfSlices - 0.25f) * 2.0f * (float)Math.PI;
            if (numberOfSlices % 2 != 0) {
                angle1 = (float)((double)angle1 + Math.PI / (double)numberOfSlices);
            }
            float posX = (float)(centerOfScreenX - 8) + itemRadius * (float)Math.cos(angle1);
            float posY = (float)(centerOfScreenY - 8) + itemRadius * (float)Math.sin(angle1);
            RenderSystem.disableDepthTest();
            T primarySlotIcon = this.radialMenuSlots.get(i).primarySlotIcon();
            List<T> secondarySlotIcons = this.radialMenuSlots.get(i).secondarySlotIcons();
            if (primarySlotIcon != null) {
                this.radialMenu.drawIcon(primarySlotIcon, graphics, (int)posX, (int)posY, 16);
                if (secondarySlotIcons != null && !secondarySlotIcons.isEmpty()) {
                    this.drawSecondaryIcons(graphics, (int)posX, (int)posY, secondarySlotIcons);
                }
            }
            ms.m_85836_();
            ms.m_252880_(0.0f, 0.0f, 9999.0f);
            this.drawSliceName(graphics, String.valueOf(i + 1), stack, (int)posX, (int)posY);
            ms.m_85849_();
        }
        if (mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices - 1;
            this.selectedItem = adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
        }
    }

    public void drawSecondaryIcons(GuiGraphics ms, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, List<T> secondarySlotIcons) {
        if (!this.radialMenu.isShowMoreSecondaryItems()) {
            this.drawSecondaryIcon(ms, secondarySlotIcons.get(0), positionXOfPrimaryIcon, positionYOfPrimaryIcon, this.radialMenu.getSecondaryIconStartingPosition());
        } else {
            SecondaryIconPosition currentSecondaryIconPosition = this.radialMenu.getSecondaryIconStartingPosition();
            for (T secondarySlotIcon : secondarySlotIcons) {
                this.drawSecondaryIcon(ms, secondarySlotIcon, positionXOfPrimaryIcon, positionYOfPrimaryIcon, currentSecondaryIconPosition);
                currentSecondaryIconPosition = SecondaryIconPosition.getNextPositon(currentSecondaryIconPosition);
            }
        }
    }

    public void drawSecondaryIcon(GuiGraphics poseStack, T item, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, SecondaryIconPosition secondaryIconPosition) {
        int offset = this.radialMenu.getOffset();
        switch (secondaryIconPosition) {
            case NORTH: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon - 14 + offset, 10);
                break;
            }
            case EAST: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + 14 + offset, positionYOfPrimaryIcon + offset, 10);
                break;
            }
            case SOUTH: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon + 14 + offset, 10);
                break;
            }
            case WEST: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon - 14 + offset, positionYOfPrimaryIcon + offset, 10);
            }
        }
    }

    public void drawSliceName(GuiGraphics graphics, String sliceName, ItemStack stack, int posX, int posY) {
        if (!this.radialMenu.isShowMoreSecondaryItems()) {
            graphics.m_280302_(this.f_96547_, stack, posX + 5, posY, sliceName);
        } else {
            graphics.m_280302_(this.f_96547_, stack, posX + 5, posY + 5, sliceName);
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        int adjustedKey = key - 48;
        if (adjustedKey >= 0 && adjustedKey < this.radialMenuSlots.size()) {
            this.selectedItem = adjustedKey == 0 ? this.radialMenuSlots.size() : adjustedKey;
            --this.selectedItem;
            this.m_6375_(0.0, 0.0, 0);
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.selectedItem != -1) {
            this.radialMenu.setCurrentSlot(this.selectedItem);
            this.f_96541_.f_91074_.m_6915_();
        }
        return true;
    }

    public void drawSlice(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, Mth.m_14167_((float)(angle / 5.0f)));
        startAngle = (float)Math.toRadians(startAngle);
        endAngle = (float)Math.toRadians(endAngle);
        angle = endAngle - startAngle;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.m_5483_((double)pos1OutX, (double)pos1OutY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos1InX, (double)pos1InY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos2InX, (double)pos2InY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos2OutX, (double)pos2OutY, (double)z).m_6122_(r, g, b, a).m_5752_();
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

