/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.gui;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.midi.client.ClientProxy;
import com.finchy.pipeorgans.midi.client.MidiInputDeviceManager;
import com.finchy.pipeorgans.util.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class MidiConfigGUI
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = PipeOrgans.asResource("textures/gui/midi_config.png");
    private static final int GUI_WIDTH = 208;
    private static final int GUI_HEIGHT = 134;
    private int cornerX;
    private int cornerY;
    private static final int BUTTONS_Y = 47;
    private static final int PREV_BUTTON_X = 7;
    private static final int NEXT_BUTTON_X = 149;
    private static final int REFRESH_BUTTON_X = 167;
    private static final int REFRESH_BUTTON_U = 208;
    private static final int SAVE_BUTTON_X = 185;
    private static final int SAVE_BUTTON_U = 224;
    private static final int DEVICE_LABELS_X = 10;
    private final MidiInputDeviceManager midiInputDeviceManager;
    private List<MidiDevice> availableMidiDevices = new ArrayList<MidiDevice>();
    private int selectedDeviceIndex = 0;
    private final Component title = Component.m_237115_((String)"gui.pipeorgans.midi_config");
    private final Font font;
    private String selectedDeviceName;
    private String selectedDeviceVendor;
    private String selectedDeviceVersion;
    private String selectedDeviceDesc;
    private String activeDeviceName;

    protected MidiConfigGUI(String translatableTitle) {
        super((Component)Component.m_237115_((String)translatableTitle));
        this.font = Minecraft.m_91087_().f_91062_;
        this.midiInputDeviceManager = ((ClientProxy)PipeOrgans.getProxy()).getMidiData().inputDeviceManager;
        this.reloadDevices();
        this.reevaluateCorners();
    }

    private void previousDevice() {
        this.selectedDeviceIndex = this.selectedDeviceIndex > 0 ? this.selectedDeviceIndex - 1 : this.availableMidiDevices.size() - 1;
        this.setSelectedDeviceInfo();
    }

    private void nextDevice() {
        this.selectedDeviceIndex = this.selectedDeviceIndex < this.availableMidiDevices.size() - 1 ? this.selectedDeviceIndex + 1 : 0;
        this.setSelectedDeviceInfo();
    }

    private void setSelectedDeviceInfo() {
        if (!this.availableMidiDevices.isEmpty()) {
            this.selectedDeviceName = this.availableMidiDevices.get(this.selectedDeviceIndex).getDeviceInfo().getName();
            this.selectedDeviceVendor = "Vendor: " + this.availableMidiDevices.get(this.selectedDeviceIndex).getDeviceInfo().getVendor();
            this.selectedDeviceVersion = "Version: " + this.availableMidiDevices.get(this.selectedDeviceIndex).getDeviceInfo().getVersion();
            this.selectedDeviceDesc = this.availableMidiDevices.get(this.selectedDeviceIndex).getDeviceInfo().getDescription();
        } else {
            this.selectedDeviceName = "No MIDI input devices available.";
            this.selectedDeviceVendor = "";
            this.selectedDeviceVersion = "";
            this.selectedDeviceDesc = "";
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void reloadDevices() {
        this.availableMidiDevices = this.midiInputDeviceManager.getAvailableDevices();
        this.selectedDeviceIndex = 0;
        this.setSelectedDeviceInfo();
    }

    public void saveSelection() {
        this.midiInputDeviceManager.saveDeviceSelection(this.availableMidiDevices.get(this.selectedDeviceIndex));
        this.activeDeviceName = "Current: " + this.midiInputDeviceManager.getActiveDeviceName();
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        this.reevaluateCorners();
        super.m_6574_(pMinecraft, pWidth, pHeight);
    }

    protected void m_7856_() {
        this.activeDeviceName = "Current: " + this.midiInputDeviceManager.getActiveDeviceName();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> this.previousDevice()).m_252794_(this.cornerX + 7, this.cornerY + 47).m_253046_(16, 16).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), b -> this.nextDevice()).m_252794_(this.cornerX + 149, this.cornerY + 47).m_253046_(16, 16).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), b -> this.reloadDevices()).m_252794_(this.cornerX + 167, this.cornerY + 47).m_253046_(16, 16).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), b -> this.saveSelection()).m_252794_(this.cornerX + 185, this.cornerY + 47).m_253046_(16, 16).m_253136_());
    }

    private void reevaluateCorners() {
        this.cornerX = (Minecraft.m_91087_().m_91268_().m_85445_() - 208) / 2;
        this.cornerY = (Minecraft.m_91087_().m_91268_().m_85446_() - 134) / 2;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280218_(GUI_TEXTURE, this.cornerX, this.cornerY, 0, 0, 208, 134);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderGraphics(graphics);
        this.renderText(graphics);
    }

    private void renderGraphics(GuiGraphics graphics) {
        graphics.m_280163_(GUI_TEXTURE, this.cornerX + 167, this.cornerY + 47, 208.0f, 0.0f, 16, 16, 256, 256);
        graphics.m_280163_(GUI_TEXTURE, this.cornerX + 185, this.cornerY + 47, 224.0f, 0.0f, 16, 16, 256, 256);
    }

    private void renderText(GuiGraphics graphics) {
        graphics.m_280614_(this.font, this.title, this.cornerX + 8, this.cornerY + 6, 0x404040, false);
        graphics.m_280056_(this.font, this.activeDeviceName, this.cornerX + 10, this.cornerY + 31, 0xFFFFFF, true);
        graphics.m_280056_(this.font, this.selectedDeviceName, this.cornerX + 28, this.cornerY + 51, 0xFFFFFF, true);
        graphics.m_280056_(this.font, this.selectedDeviceVendor, this.cornerX + 10, this.cornerY + 70, 0xFFFFFF, true);
        graphics.m_280056_(this.font, this.selectedDeviceVersion, this.cornerX + 10, this.cornerY + 81, 0xFFFFFF, true);
        GuiUtils.drawWordWrapDropShadow(graphics, this.font, FormattedText.m_130775_((String)this.selectedDeviceDesc), this.cornerX + 10, this.cornerY + 92, 188, 0xFFFFFF, true);
    }
}

