/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public interface WalkwayBlock {
    public static final EnumProperty<WalkwayCaps> CAPS = EnumProperty.m_61587_((String)"caps", WalkwayCaps.class);
    public static final EnumProperty<WalkwayCaps> CAPS_SHAFT = EnumProperty.m_61594_((String)"caps", WalkwayCaps.class, e -> e != WalkwayCaps.NO_SHAFT);
    public static final EnumProperty<WalkwayCaps> CAPS_SIDED = EnumProperty.m_61598_((String)"caps", WalkwayCaps.class, (Enum[])new WalkwayCaps[]{WalkwayCaps.NONE, WalkwayCaps.BOTH, WalkwayCaps.NO_SHAFT});
    public static final EnumProperty<WalkwaySlope> SLOPE = EnumProperty.m_61594_((String)"slope", WalkwaySlope.class, s -> s != WalkwaySlope.TERMINAL);

    public Direction getFacing(BlockState var1);

    public WalkwaySlope getWalkwaySlope(BlockState var1);

    public boolean hasWalkwayShaft(BlockState var1);

    public BlockState transformFromMerge(Level var1, BlockState var2, BlockPos var3, boolean var4, boolean var5, boolean var6, boolean var7);

    public boolean connectedToWalkwayOnSide(Level var1, BlockState var2, BlockPos var3, Direction var4);

    public WalkwaySet getWalkwaySet();

    public boolean isEscalator(Level var1, BlockState var2, BlockPos var3);

    default public boolean movesEntities(BlockState state) {
        return true;
    }

    public static void initWalkway(Level level, BlockPos pos) {
        int minSize;
        ServerLevel slevel;
        if (level.f_46443_ || level instanceof ServerLevel && (slevel = (ServerLevel)level).m_7726_().m_8481_() instanceof DebugLevelSource) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof WalkwayBlock)) {
            return;
        }
        int limit = 1100;
        boolean escalator = false;
        BlockPos currentPos = pos;
        boolean terminal = false;
        while (limit-- > 0) {
            BlockState currentState = level.m_8055_(currentPos);
            Block block = currentState.m_60734_();
            if (!(block instanceof WalkwayBlock)) {
                level.m_46961_(pos, true);
                return;
            }
            WalkwayBlock walkwayBlock = (WalkwayBlock)block;
            WalkwaySlope slope = walkwayBlock.getWalkwaySlope(currentState);
            escalator |= slope == WalkwaySlope.TOP || slope == WalkwaySlope.MIDDLE || slope == WalkwaySlope.BOTTOM;
            BlockPos nextSegmentPosition = WalkwayBlock.nextSegmentPosition(currentState, currentPos, true, terminal);
            terminal = true;
            if (nextSegmentPosition == null) break;
            if (!level.m_46749_(nextSegmentPosition)) {
                return;
            }
            currentPos = nextSegmentPosition;
        }
        List<BlockPos> walkwayChain = WalkwayBlock.getWalkwayChain(level, currentPos);
        int n = minSize = escalator ? 5 : 3;
        if (walkwayChain.size() < minSize) {
            level.m_46961_(currentPos, true);
            return;
        }
        for (BlockPos beltPos : walkwayChain) {
            BlockState currentState = level.m_8055_(beltPos);
            BlockEntity blockEntity = level.m_7702_(beltPos);
            if (blockEntity instanceof WalkwayBlockEntity) {
                WalkwayBlockEntity walkway = (WalkwayBlockEntity)blockEntity;
                if (currentState.m_60734_() instanceof WalkwayBlock) {
                    walkway.setController(currentPos);
                    walkway.walkwayLength = walkwayChain.size();
                    walkway.attachKinetics();
                    walkway.notifyUpdate();
                    continue;
                }
            }
            level.m_46961_(currentPos, true);
            return;
        }
    }

    public static List<BlockPos> getWalkwayChain(Level level, BlockPos controllerPos) {
        BlockState state;
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        BlockState blockState = level.m_8055_(controllerPos);
        if (!(blockState.m_60734_() instanceof WalkwayBlock)) {
            return positions;
        }
        int limit = 1000;
        BlockPos current = controllerPos;
        boolean terminal = false;
        while (limit-- > 0 && current != null && (state = level.m_8055_(current)).m_60734_() instanceof WalkwayBlock) {
            positions.add(current);
            current = WalkwayBlock.nextSegmentPosition(state, current, !terminal, terminal);
            terminal = true;
        }
        return positions;
    }

    public static BlockPos nextSegmentPosition(BlockState state, BlockPos pos, boolean forward, boolean terminal) {
        int offset;
        WalkwayBlock walkway = (WalkwayBlock)state.m_60734_();
        Direction direction = walkway.getFacing(state);
        WalkwaySlope slope = walkway.getWalkwaySlope(state);
        int n = offset = forward ? 1 : -1;
        if (slope == WalkwaySlope.TERMINAL && terminal) {
            return null;
        }
        pos = pos.m_5484_(direction, offset);
        if (slope == WalkwaySlope.MIDDLE) {
            return pos.m_6630_(offset);
        }
        if (slope == WalkwaySlope.TOP && !forward) {
            return pos.m_7495_();
        }
        if (slope == WalkwaySlope.BOTTOM && forward) {
            return pos.m_7494_();
        }
        return pos;
    }
}

