/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.smoke;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BaseAshSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.ParticleWindHandler;
import rbasamoyai.createbigcannons.effects.particles.smoke.CannonSmokeParticleData;
import rbasamoyai.createbigcannons.effects.particles.smoke.FallbackCannonSmokeParticleData;
import rbasamoyai.createbigcannons.index.CBCRenderTypes;

public class CannonSmokeParticle
extends BaseAshSmokeParticle {
    private static final ResourceLocation GRADIENT_LOCATION = CreateBigCannons.resource("textures/particle/cannon_smoke_particle_gradient.png");
    private static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.setShaderTexture((int)3, (ResourceLocation)GRADIENT_LOCATION);
            CBCRenderTypes.CANNON_SMOKE_PARTICLE.setRenderTypeForBuilder(builder);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "CANNON_SMOKE";
        }
    };
    private final float power;
    private final Vec3 wind = ParticleWindHandler.getWindForce(0.0);

    CannonSmokeParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, SpriteSet sprites, float power) {
        super(level, x, y, z, 0.1f, 0.1f, 0.1f, dx, dy, dz, 1.0f, sprites, 1.0f, 8, -0.05f, true);
        this.power = power;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
    }

    public void m_5989_() {
        super.m_5989_();
        float f = this.f_107218_ ? 1.0f : 0.5f;
        this.m_6257_(this.wind.f_82479_ * (double)f, this.wind.f_82480_, this.wind.f_82481_ * (double)f);
        float progress = Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        this.f_107230_ = this.f_107225_ == 0 || this.f_107224_ >= this.f_107225_ ? 0.0f : 1.0f - progress * progress;
    }

    public void m_108339_(SpriteSet sprite) {
        float progress = Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_ * 1.5f), (float)0.0f, (float)1.0f);
        float inv = 1.0f - progress;
        float spriteProgress = 1.0f - inv * inv * inv * inv;
        if (!this.f_107220_) {
            this.m_108337_(sprite.m_5819_((int)Math.floor(spriteProgress * (float)this.f_107225_), this.f_107225_));
        }
    }

    public float m_5902_(float scaleFactor) {
        float f = ((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_ * 32.0f;
        return this.f_107663_ * Mth.m_14179_((float)f, (float)0.9f, (float)1.0f);
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion;
        Vec3 vec3 = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float g = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float h = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = renderInfo.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
            float i = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(i));
        }
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(partialTicks);
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f2 = vector3fs[k];
            quaternion.transform(vector3f2);
            vector3f2.mul(j);
            vector3f2.add(f, g, h);
        }
        float l = this.m_5970_();
        float m = this.m_5952_();
        float n = this.m_5951_();
        float o = this.m_5950_();
        int p = this.m_6355_(partialTicks);
        int cannonPower = (int)Math.floor(this.power);
        buffer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(m, o).m_7122_(0, cannonPower).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        buffer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(m, n).m_7122_(0, cannonPower).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        buffer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(l, n).m_7122_(0, cannonPower).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        buffer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(l, o).m_7122_(0, cannonPower).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
    }

    public int m_6355_(float partialTick) {
        float progress = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + partialTick) / (float)this.f_107225_ * 1.5f), (float)0.0f, (float)1.0f);
        float brightness = progress * progress * progress * progress;
        int i = super.m_6355_(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(brightness * 240.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Provider
    implements ParticleProvider<CannonSmokeParticleData> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(CannonSmokeParticleData data, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            if (((Boolean)CBCConfigs.client().useShaderCompatibleGraphics.get()).booleanValue()) {
                level.m_6493_((ParticleOptions)new FallbackCannonSmokeParticleData(data), true, x, y, z, dx, dy, dz);
                return null;
            }
            CannonSmokeParticle particle = new CannonSmokeParticle(level, x, y, z, dx, dy, dz, this.sprites, data.power());
            particle.f_107663_ = data.size();
            particle.f_172258_ = data.friction();
            particle.m_107257_(data.lifetime());
            return particle;
        }
    }
}

