/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.ramcompat.items;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityIceShard;
import it.hurts.sskirillss.ramcompat.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class FrostRobeItem
extends RelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"warming").maxLevel(0).build()).ability(AbilityData.builder((String)"icicle").maxLevel(10).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder((String)"chance").initialValue(0.4, 0.75).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.035).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"amount").initialValue(3.0, 7.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"cooldown").initialValue(7.5, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).ability(AbilityData.builder((String)"freeze").requiredLevel(5).maxLevel(10).stat(StatData.builder((String)"chance").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"duration").initialValue(0.75, 1.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.075).formatValue(value -> MathUtils.round((double)value, (int)2)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(LootCollections.COLD).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.canUseAbility(stack, "warming")) {
            player.m_146917_(0);
        }
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (!this.canUseAbility(stack, "icicle")) {
            return;
        }
        this.throwIcicles(player, stack);
        this.addAbilityCooldown(stack, "icicle", (int)Math.round(this.getAbilityValue(stack, "icicle", "cooldown") * 20.0));
    }

    private void throwIcicles(Player player, ItemStack stack) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        boolean spawned = false;
        for (int i = 0; i < (int)this.getAbilityValue(stack, "icicle", "amount"); ++i) {
            if (i != 0 && random.m_188500_() > this.getAbilityValue(stack, "icicle", "chance")) continue;
            EntityIceShard shard = new EntityIceShard((EntityType)AMEntityRegistry.ICE_SHARD.get(), level);
            shard.setShooter((Entity)player);
            shard.m_146884_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0));
            shard.m_20334_((double)(MathUtils.randomFloat((RandomSource)random) * 0.35f), (double)(0.1f + random.m_188501_() * 0.2f), (double)(MathUtils.randomFloat((RandomSource)random) * 0.35f));
            level.m_7967_((Entity)shard);
            spawned = true;
        }
        if (spawned) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_144205_, SoundSource.MASTER, 1.0f, 2.0f);
        }
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        return this.canUseAbility(stack, "warming");
    }

    @Mod.EventBusSubscriber
    public static class FrostRobeEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.FROST_ROBE.get()));
                Item item = stack.m_41720_();
                if (!(item instanceof FrostRobeItem)) {
                    return;
                }
                FrostRobeItem relic = (FrostRobeItem)item;
                Level level = player.m_20193_();
                if (level.m_5776_()) {
                    return;
                }
                RandomSource random = level.m_213780_();
                if (relic.canUseAbility((ItemStack)stack, "freeze")) {
                    if (random.m_188500_() > relic.getAbilityValue((ItemStack)stack, "freeze", "chance")) {
                        return;
                    }
                    Entity entity = event.getSource().m_7639_();
                    if (entity instanceof LivingEntity) {
                        LivingEntity source = (LivingEntity)entity;
                        source.m_146917_((int)((double)source.m_146888_() + Math.ceil(relic.getAbilityValue((ItemStack)stack, "freeze", "duration") * 20.0)));
                    }
                    relic.throwIcicles(player, (ItemStack)stack);
                }
            } else {
                stack = event.getSource().m_7640_();
                if (stack instanceof EntityIceShard) {
                    EntityIceShard shard = (EntityIceShard)stack;
                    Entity relic = shard.getOwner();
                    if (!(relic instanceof Player)) {
                        return;
                    }
                    Player player = (Player)relic;
                    ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.FROST_ROBE.get()));
                    Item item = stack.m_41720_();
                    if (!(item instanceof FrostRobeItem)) {
                        return;
                    }
                    FrostRobeItem relic2 = (FrostRobeItem)item;
                    relic2.spreadExperience((LivingEntity)player, stack, 1);
                }
            }
        }
    }
}

