/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.cycle_menu;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuEventsHandler;
import com.railwayteam.railways.content.cycle_menu.TagCycleHandlerClient;
import com.railwayteam.railways.mixin.client.AccessorToolboxHandlerClient;
import com.railwayteam.railways.registry.CRKeys;
import com.railwayteam.railways.util.client.ClientUtils;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RadialTagCycleMenu
extends AbstractSimiScreen {
    private int ticksOpen;
    private int hoveredSlot = -1;
    private boolean scrollMode;
    private int scrollSlot = 0;
    private final TagKey<Item> tag;
    private final List<Item> cycle;
    @Nullable
    private final CompoundTag stackTag;

    RadialTagCycleMenu(TagKey<Item> tag, List<Item> cycle, @Nullable CompoundTag stackTag) {
        this.cycle = cycle;
        this.tag = tag;
        this.stackTag = stackTag;
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float hoveredY;
        float fade = Mth.m_14036_((float)(((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 10.0f), (float)0.001953125f, (float)1.0f);
        PoseStack ms = graphics.m_280168_();
        this.hoveredSlot = -1;
        Window window = Minecraft.m_91087_().m_91268_();
        float hoveredX = mouseX - window.m_85445_() / 2;
        float distance = hoveredX * hoveredX + (hoveredY = (float)(mouseY - window.m_85446_() / 2)) * hoveredY;
        if (distance > 25.0f && distance < 10000.0f) {
            this.hoveredSlot = Mth.m_14143_((float)(AngleHelper.deg((double)Mth.m_14136_((double)hoveredY, (double)hoveredX)) + 360.0f + 180.0f - 22.5f)) % 360 / 45;
        }
        if (this.scrollMode && distance > 150.0f) {
            this.scrollMode = false;
        }
        ms.m_85836_();
        ms.m_252880_((float)(this.f_96543_ / 2), (float)(this.f_96544_ / 2), 0.0f);
        MutableComponent tip = null;
        ResourceLocation tagLoc = this.tag.f_203868_();
        MutableComponent title = Components.translatable((String)("tag.item." + tagLoc.m_135827_() + "." + tagLoc.m_135815_().replace('/', '.')));
        for (int slot = 0; slot < 8; ++slot) {
            boolean selected;
            ms.m_85836_();
            double radius = -40.0f + 10.0f * (1.0f - fade) * (1.0f - fade);
            double angle = slot * 45 - 45;
            ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).rotateZ(angle)).translate(0.0, radius, 0.0)).rotateZ(-angle);
            ms.m_252880_(-12.0f, -12.0f, 0.0f);
            boolean bl = selected = slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot);
            if (slot < this.cycle.size()) {
                ItemStack stack = new ItemStack((ItemLike)this.cycle.get(slot));
                if (this.stackTag != null) {
                    stack.m_41751_(this.stackTag.m_6426_());
                }
                if (this.f_96541_ != null) {
                    AllGuiTextures.TOOLBELT_SLOT.render(graphics, 0, 0);
                    GuiGameElement.of((ItemStack)stack).at(3.0f, 3.0f).render(graphics);
                    if (selected) {
                        AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                        tip = Components.empty().m_7220_(stack.m_41786_()).m_130940_(ChatFormatting.GOLD);
                    }
                }
            } else {
                AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);
            }
            ms.m_85849_();
        }
        int i1 = (int)(fade * 255.0f);
        if (i1 > 255) {
            i1 = 255;
        }
        if (i1 > 8) {
            ms.m_85836_();
            ms.m_252880_(0.0f, -80.0f, 0.0f);
            this.drawComponent(graphics, (Component)title, i1);
        }
        ms.m_85849_();
        if (tip != null) {
            i1 = (int)(fade * 255.0f);
            if (i1 > 255) {
                i1 = 255;
            }
            if (i1 > 8) {
                ms.m_85836_();
                ms.m_252880_((float)(this.f_96543_ / 2), (float)(this.f_96544_ - 68), 0.0f);
                this.drawComponent(graphics, (Component)tip, i1);
            }
        }
    }

    private void drawComponent(GuiGraphics graphics, Component title, int i1) {
        PoseStack ms = graphics.m_280168_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int k1 = 0xFFFFFF;
        int k = i1 << 24 & 0xFF000000;
        int l = this.f_96547_.m_92852_((FormattedText)title);
        graphics.m_280430_(this.f_96547_, title, -l / 2, -4, k1 | k);
        RenderSystem.disableBlend();
        ms.m_85849_();
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        PoseStack ms = guiGraphics.m_280168_();
        int a = (int)(80.0f * Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f)) << 24;
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, 0x101010 | a, 0x101010 | a);
    }

    public void m_86600_() {
        ++this.ticksOpen;
        super.m_86600_();
    }

    public boolean m_6375_(double x, double y, int button) {
        int selected;
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (button == 0 && selected >= 0 && selected < this.cycle.size()) {
            TagCycleHandlerClient.select(this.cycle.get(selected));
            this.m_7379_();
            BogeyMenuEventsHandler.COOLDOWN = 2;
            TagCycleHandlerClient.COOLDOWN = 2;
            AccessorToolboxHandlerClient.setCOOLDOWN(2);
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        double hoveredY;
        Window window = Minecraft.m_91087_().m_91268_();
        double hoveredX = mouseX - (double)(window.m_85445_() / 2);
        double distance = hoveredX * hoveredX + (hoveredY = mouseY - (double)(window.m_85446_() / 2)) * hoveredY;
        if (distance <= 150.0) {
            this.scrollMode = true;
            this.scrollSlot = ((int)((double)this.scrollSlot - delta) + 8) % 8;
            for (int i = 0; i < 10 && this.scrollSlot >= this.cycle.size(); ++i) {
                this.scrollSlot -= Mth.m_14205_((double)delta);
                this.scrollSlot = (this.scrollSlot + 8) % 8;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7920_(int code, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)code, (int)scanCode);
        if (ClientUtils.isActiveAndMatches(CRKeys.CYCLE_MENU.getKeybind(), mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7920_(code, scanCode, modifiers);
    }
}

