/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.contraptions.blazeStove;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.schematic.nbt.PartialSafeNBT;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveGuideItem;
import plus.dragons.createcentralkitchen.foundation.config.CentralKitchenConfigs;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class BlazeStoveBlockEntity
extends BlazeBurnerBlockEntity
implements MenuProvider,
IHaveGoggleInformation,
PartialSafeNBT {
    private static final int INVENTORY_SLOT_COUNT = 9;
    public static final Vec2[] ITEM_OFFSET_NS = new Vec2[9];
    public static final Vec2[] ITEM_OFFSET_WE = new Vec2[9];
    private static final VoxelShape GRILLING_AREA = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private final ItemStackHandler inventory = this.createItemHandler();
    private final int[] cookingTimes = new int[9];
    private final int[] cookingTimesTotal = new int[9];
    private final ResourceLocation[] lastRecipeIDs = new ResourceLocation[9];
    private ItemStack guide = ItemStack.f_41583_;

    public BlazeStoveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    public void initialize() {
        super.initialize();
        this.updateGuide();
    }

    public void tick() {
        super.tick();
        BlazeBurnerBlock.HeatLevel heat = this.getHeatLevelFromBlock();
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            if (!heat.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
                for (int i = 0; i < 9; ++i) {
                    if (!(this.f_58857_.f_46441_.m_188501_() < 0.2f) || this.inventory.getStackInSlot(i).m_41619_()) continue;
                    this.addSmokeAtItem(i, 3);
                }
            }
        } else {
            boolean blockedAbove = this.isBlockedAbove();
            switch (heat) {
                case SEETHING: {
                    if (blockedAbove) {
                        this.boostCooking(4);
                        break;
                    }
                    this.burnIngredients();
                    break;
                }
                case KINDLED: 
                case FADING: {
                    if (blockedAbove) {
                        this.boostCooking(2);
                        break;
                    }
                    this.processCooking(2);
                    break;
                }
                case SMOULDERING: {
                    if (blockedAbove) break;
                    this.processCooking(1);
                    break;
                }
                default: {
                    this.decrementCooking(blockedAbove);
                }
            }
            if (blockedAbove) {
                this.dropAll();
            }
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            int[] array = compound.m_128465_("CookingTimes");
            System.arraycopy(array, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, array.length));
            array = compound.m_128465_("CookingTotalTimes");
            System.arraycopy(array, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, array.length));
        }
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        String guideKey = compound.m_128441_("Guide") ? "Guide" : "CookingGuide";
        this.setGuide(ItemStack.m_41712_((CompoundTag)compound.m_128469_(guideKey)));
        this.updateGuide();
        super.read(compound, clientPacket);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            compound.m_128385_("CookingTimes", this.cookingTimes);
            compound.m_128385_("CookingTotalTimes", this.cookingTimesTotal);
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("Guide", (Tag)this.guide.serializeNBT());
        this.updateGuide();
        super.write(compound, clientPacket);
    }

    public void writeSafe(CompoundTag compound) {
        compound.m_128365_("Guide", (Tag)this.guide.serializeNBT());
        super.writeSafe(compound);
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        return super.getRequiredItems(state).union(new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.guide));
    }

    @NotNull
    public Component m_5446_() {
        return this.guide.m_41720_().m_41466_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inventory, @NotNull Player player) {
        Item item = this.guide.m_41720_();
        if (!(item instanceof BlazeStoveGuideItem)) {
            return null;
        }
        BlazeStoveGuideItem item2 = (BlazeStoveGuideItem)item;
        return item2.createGuideMenu(syncId, inventory, this);
    }

    public boolean stillValid(Player player) {
        if (player.m_9236_().m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20238_(VecHelper.getCenterOf((Vec3i)this.f_58858_)) > 64.0);
    }

    public int getBlazeStatusCode() {
        BlazeBurnerBlock.HeatLevel heat = (BlazeBurnerBlock.HeatLevel)this.m_58900_().m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL);
        return switch (heat) {
            default -> throw new IncompatibleClassChangeError();
            case BlazeBurnerBlock.HeatLevel.NONE -> 0;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING -> 1;
            case BlazeBurnerBlock.HeatLevel.KINDLED, BlazeBurnerBlock.HeatLevel.FADING -> 2;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> 3;
        };
    }

    private void updateGuide() {
        Item item;
        if (this.f_58857_ != null && (item = this.guide.m_41720_()) instanceof BlazeStoveGuideItem) {
            BlazeStoveGuideItem item2 = (BlazeStoveGuideItem)item;
            this.guide.getCapability(item2.getGuideCapability()).ifPresent(it -> it.updateRecipe(this.f_58857_));
        }
    }

    public ItemStack getGuide() {
        return this.guide;
    }

    public void setGuide(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BlazeStoveGuideItem)) {
            return;
        }
        this.guide = stack;
        if (this.f_58857_ != null) {
            this.updateGuide();
            this.notifyUpdate();
        }
    }

    public LerpedFloat getHeadAngle() {
        return this.headAngle;
    }

    public LerpedFloat getHeadAnimation() {
        return this.headAnimation;
    }

    public boolean isBlockedAbove() {
        if (this.f_58857_ != null) {
            BlockState above = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
            return Shapes.m_83157_((VoxelShape)GRILLING_AREA, (VoxelShape)above.m_60808_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()), (BooleanOp)BooleanOp.f_82689_);
        }
        return false;
    }

    public boolean isValidBlockAbove() {
        assert (this.f_58857_ != null);
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        return AllBlocks.BASIN.has(blockState) || blockState.m_60734_() instanceof SkilletBlock || blockState.m_60734_() instanceof CookingPotBlock;
    }

    public void destroy() {
        super.destroy();
        if (this.f_58857_ instanceof ServerLevel) {
            this.dropAll();
            BlockPos pos = this.m_58899_();
            Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.guide);
        }
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void dropAll() {
        if (!ItemUtils.isInventoryEmpty((IItemHandler)this.inventory)) {
            ItemUtils.dropItems((Level)this.f_58857_, (BlockPos)this.m_58899_(), (IItemHandler)this.inventory);
            this.notifyUpdate();
        }
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel newHeat) {
        BlazeBurnerBlock.HeatLevel originalHeat = this.getHeatLevelFromBlock();
        if (originalHeat == newHeat) {
            return;
        }
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)newHeat));
        this.notifyUpdate();
    }

    public void applyCreativeFuel() {
        super.applyCreativeFuel();
    }

    public boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        return super.tryUpdateFuel(itemStack, forceOverflow, simulate);
    }

    public boolean tryAddIngredient(ItemStack inStack, boolean forceOverflow, boolean simulate) {
        int slot = this.getNextEmptySlot();
        if (slot < 0) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = this.getHeatLevelFromBlock();
        if (!heat.isAtLeast(BlazeBurnerBlock.HeatLevel.SMOULDERING) || heat.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            return false;
        }
        if (this.isBlockedAbove()) {
            return false;
        }
        Optional<CampfireCookingRecipe> optional = this.findRecipe((Container)new SimpleContainer(new ItemStack[]{inStack}), slot);
        if (optional.isPresent() && slot < this.inventory.getSlots()) {
            if (simulate) {
                return true;
            }
            CampfireCookingRecipe recipe = optional.get();
            ItemStack slotStack = this.inventory.getStackInSlot(slot);
            if (slotStack.m_41619_()) {
                ItemStack addStack = inStack.m_41777_();
                addStack.m_41764_(1);
                this.cookingTimesTotal[slot] = recipe.m_43753_();
                this.cookingTimes[slot] = 0;
                this.inventory.setStackInSlot(slot, addStack);
                this.lastRecipeIDs[slot] = recipe.m_6423_();
                this.notifyUpdate();
                return true;
            }
        }
        return false;
    }

    protected void decrementCooking(boolean blockedAbove) {
        if (blockedAbove) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            if (this.cookingTimes[i] <= 0) continue;
            this.cookingTimes[i] = Mth.m_14045_((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTimesTotal[i]);
        }
    }

    protected void processCooking(int speed) {
        assert (this.f_58857_ != null);
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack resultStack;
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + speed;
            if (this.cookingTimes[i] < this.cookingTimesTotal[i]) continue;
            SimpleContainer inventoryWrapper = new SimpleContainer(new ItemStack[]{stack});
            Optional<CampfireCookingRecipe> recipe = this.findRecipe((Container)inventoryWrapper, i);
            if (recipe.isPresent() && !(resultStack = recipe.get().m_8043_(this.f_58857_.m_9598_())).m_41619_()) {
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)resultStack.m_41777_(), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (double)(this.f_58857_.f_46441_.m_188583_() * 0.001), (double)0.1, (double)(this.f_58857_.f_46441_.m_188583_() * 0.001));
            }
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.notifyUpdate();
        }
    }

    public Optional<CampfireCookingRecipe> findRecipe(Container recipeWrapper, int slot) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeIDs[slot] != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap(RecipeType.f_44111_).get(this.lastRecipeIDs[slot])) instanceof CampfireCookingRecipe && recipe.m_5818_(recipeWrapper, this.f_58857_)) {
            return Optional.of((CampfireCookingRecipe)recipe);
        }
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, recipeWrapper, this.f_58857_);
    }

    protected void burnIngredients() {
        assert (this.f_58857_ != null);
        boolean didInventoryChange = false;
        int totalUncooked = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            totalUncooked += Math.max(0, this.cookingTimesTotal[i] - this.cookingTimes[i]);
            this.cookingTimes[0] = 0;
            this.cookingTimesTotal[i] = 0;
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            this.addSmokeAtItem(i, 5);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.remainingBurnTime += totalUncooked / 9;
            this.f_58857_.m_46796_(1501, this.m_58899_(), 0);
            this.notifyUpdate();
        }
    }

    public void addSmokeAtItem(int slot, int amount) {
        assert (this.f_58857_ != null);
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)StoveBlock.FACING);
        int directionIndex = direction.m_122416_();
        Vec2 offset = directionIndex % 2 == 0 ? ITEM_OFFSET_NS[slot] : ITEM_OFFSET_WE[slot];
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)((float)(direction.m_122427_().m_122429_() - direction.m_122429_()) * offset.f_82470_);
        double y = (double)this.f_58858_.m_123342_() + 1.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)((float)(direction.m_122427_().m_122431_() - direction.m_122431_()) * offset.f_82471_);
        for (int k = 0; k < amount; ++k) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
        }
    }

    @Nullable
    private <T extends BlockEntity> Runnable getCookingTicker(BlockEntity blockEntity, BlockEntityType<T> type) {
        assert (this.f_58857_ != null);
        BlockState state = blockEntity.m_58900_();
        EntityBlock block = (EntityBlock)state.m_60734_();
        BlockEntityTicker ticker = block.m_142354_(this.f_58857_, state, type);
        if (ticker == null) {
            return null;
        }
        return () -> ticker.m_155252_(this.f_58857_, blockEntity.m_58899_(), state, blockEntity);
    }

    protected void boostCooking(int times) {
        BlockEntity blockEntity;
        assert (this.f_58857_ != null);
        BlockPos pos = this.m_58899_().m_7494_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_204336_(ModTags.HEAT_CONDUCTORS)) {
            pos = pos.m_7494_();
        }
        if ((blockEntity = this.f_58857_.m_7702_(pos)) == null) {
            return;
        }
        BlockEntityType type = blockEntity.m_58903_();
        if (!CentralKitchenConfigs.COMMON.automation.boostingCookerList.contains(type)) {
            return;
        }
        Runnable ticker = this.getCookingTicker(blockEntity, type);
        if (ticker == null) {
            return;
        }
        for (int i = 0; i < times - 1; ++i) {
            ticker.run();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Item item = this.guide.m_41720_();
        if (!(item instanceof BlazeStoveGuideItem)) {
            return false;
        }
        BlazeStoveGuideItem item2 = (BlazeStoveGuideItem)item;
        item2.appendGuideTooltip(this.guide, tooltip, true);
        return true;
    }

    static {
        float scale = 0.3125f;
        for (int i = 0; i < 9; ++i) {
            float x = (float)(i % 3 - 1) * scale;
            float y = (float)(i / 3 - 1) * scale;
            BlazeStoveBlockEntity.ITEM_OFFSET_NS[i] = new Vec2(x, y);
            BlazeStoveBlockEntity.ITEM_OFFSET_WE[i] = new Vec2(y, x);
        }
    }
}

