/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.tile.EnhancedSkullBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DoubleSkullBlockTile
extends EnhancedSkullBlockTile {
    @Nullable
    protected SkullBlockEntity innerTileUp = null;
    private Block candleUp = null;
    private ResourceLocation waxTexture = null;

    public DoubleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModRegistry.SKULL_PILE_TILE.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveInnerTile("SkullUp", this.innerTileUp, tag);
        if (this.candleUp != null) {
            tag.m_128359_("CandleAbove", Utils.getID((Block)this.candleUp).toString());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        ResourceLocation candle;
        Optional o;
        super.m_142466_(tag);
        this.innerTileUp = this.loadInnerTile("SkullUp", this.innerTileUp, tag);
        Block b = null;
        if (tag.m_128441_("CandleAbove") && (o = BuiltInRegistries.f_256975_.m_6612_(candle = new ResourceLocation(tag.m_128461_("CandleAbove")))).isPresent()) {
            b = (Block)o.get();
        }
        this.setCandleUp(b);
    }

    public ItemStack getSkullItemUp() {
        if (this.innerTileUp != null) {
            return new ItemStack((ItemLike)this.innerTileUp.m_58900_().m_60734_());
        }
        return ItemStack.f_41583_;
    }

    public void rotateUp(Rotation rotation) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.m_58900_();
            int r = (Integer)this.innerTileUp.m_58900_().m_61143_((Property)SkullBlock.f_56314_);
            this.innerTileUp.m_155250_((BlockState)state.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(rotation.m_55949_(r, 16))));
        }
    }

    public void rotateUpStep(int step) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.m_58900_();
            int r = (Integer)this.innerTileUp.m_58900_().m_61143_((Property)SkullBlock.f_56314_);
            this.innerTileUp.m_155250_((BlockState)state.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf((r - step + 16) % 16)));
        }
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, ItemStack skullStack, Player player, InteractionHand hand) {
        BlockItem bi;
        Block block;
        super.initialize(oldTile, skullStack, player, hand);
        Item item = skullStack.m_41720_();
        if (item instanceof BlockItem && (block = (bi = (BlockItem)item).m_40614_()) instanceof SkullBlock) {
            BlockEntity entity;
            SkullBlock upSkull = (SkullBlock)block;
            BlockPlaceContext context = new BlockPlaceContext(player, hand, skullStack, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.UP, this.m_58899_(), false));
            BlockState state = upSkull.m_5573_(context);
            if (state == null) {
                state = upSkull.m_49966_();
            }
            if ((entity = upSkull.m_142194_(this.m_58899_(), state)) instanceof SkullBlockEntity) {
                SkullBlockEntity blockEntity;
                this.innerTileUp = blockEntity = (SkullBlockEntity)entity;
                GameProfile gameprofile = null;
                if (skullStack.m_41782_()) {
                    CompoundTag compoundtag = skullStack.m_41783_();
                    if (compoundtag.m_128425_("SkullOwner", 10)) {
                        gameprofile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("SkullOwner"));
                    } else if (compoundtag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.m_128461_("SkullOwner"))) {
                        gameprofile = new GameProfile(null, compoundtag.m_128461_("SkullOwner"));
                    }
                }
                this.innerTileUp.m_59769_(gameprofile);
            }
        }
    }

    public void updateWax(BlockState above) {
        this.setCandleUp(above.m_60734_());
        if (this.f_58857_ instanceof ServerLevel) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private void setCandleUp(Block above) {
        this.candleUp = null;
        if (above instanceof CandleBlock) {
            this.candleUp = above;
        }
        if (PlatHelper.getPhysicalSide().isClient()) {
            this.waxTexture = null;
            if (this.candleUp != null) {
                this.waxTexture = AmendmentsClient.SKULL_CANDLES_TEXTURES.get().get(this.candleUp);
            }
        }
    }

    public ResourceLocation getWaxTexture() {
        return this.waxTexture;
    }

    @Nullable
    public BlockState getSkullUp() {
        if (this.innerTileUp != null) {
            return this.innerTileUp.m_58900_();
        }
        return null;
    }

    @Nullable
    public BlockEntity getSkullTileUp() {
        return this.innerTileUp;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DoubleSkullBlockTile e) {
        BlockState b;
        e.tick(level, pos, state);
        BlockEntity tileUp = e.getSkullTileUp();
        if (tileUp != null && (b = tileUp.m_58900_()) instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)b;
            eb.m_142354_(level, b, tileUp.m_58903_());
        }
    }
}

