/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.contraption;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGSoundEvents;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineSoundInstance;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class DieselEngineMovementBehaviour
implements MovementBehaviour {
    @OnlyIn(value=Dist.CLIENT)
    static Map<Pair<UUID, BlockPos>, EngineSoundInstance> soundInstances;

    public boolean isActive(MovementContext context) {
        return context.contraption instanceof CarriageContraption && super.isActive(context);
    }

    @Nullable
    public ItemStack canBeDisabledVia(MovementContext context) {
        return CDGBlocks.DIESEL_ENGINE.asStack();
    }

    public void tick(MovementContext context) {
        if (!context.world.f_46443_) {
            return;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientTick(context));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientTick(MovementContext context) {
        CarriageContraption contraption = (CarriageContraption)context.contraption;
        CarriageContraptionEntity entity = (CarriageContraptionEntity)contraption.entity;
        if (soundInstances == null) {
            soundInstances = new HashMap<Pair<UUID, BlockPos>, EngineSoundInstance>();
        }
        if (!((Boolean)CDGConfig.ENGINES_EMIT_SOUND_ON_TRAINS.get()).booleanValue() || entity.getCarriage().train.derailed) {
            return;
        }
        double trainSpeed = context.motion.m_82553_() * 2.0 / (double)(entity.getCarriage().train.maxSpeed() / 28.0f);
        double lastTrainSpeed = context.data.m_128459_("TrainSpeed");
        double acceleration = trainSpeed - lastTrainSpeed;
        context.data.m_128347_("TrainSpeed", trainSpeed);
        float throttle = Mth.m_14179_((float)0.05f, (float)context.data.m_128457_("Throttle"), (float)((float)Math.max(0.0, Math.min(1.0, acceleration))));
        context.data.m_128350_("Throttle", throttle);
        EngineSoundInstance instance = soundInstances.get(Pair.of((Object)entity.m_20148_(), (Object)context.localPos));
        if (context.disabled) {
            if (instance != null) {
                instance.fadeOut();
            }
            return;
        }
        if (instance == null) {
            instance = new EngineSoundInstance((SoundEvent)CDGSoundEvents.ENGINE_NORMAL.get(), SoundSource.NEUTRAL, context.position, 0.6f);
            instance.setVolume(1.0f);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)instance);
            soundInstances.put((Pair<UUID, BlockPos>)Pair.of((Object)entity.m_20148_(), (Object)context.localPos), instance);
        } else if (instance.m_7801_()) {
            soundInstances.remove(Pair.of((Object)entity.m_20148_(), (Object)context.localPos));
        }
        instance.setPosition(context.position);
        if (instance.active()) {
            instance.keepAlive();
            float pitch = (float)Math.min(2.0, Math.max(Math.min(0.14, (double)throttle) * 5.0 + trainSpeed / 28.0, (double)0.1f));
            instance.setPitch(pitch);
        }
    }
}

