/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.modular;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class ModularDieselEngineBlock
extends HorizontalKineticBlock
implements IBE<ModularDieselEngineBlockEntity>,
SpecialBlockItemRequirement {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty PIPE = BooleanProperty.m_61465_((String)"pipe");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public ModularDieselEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)PIPE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() == state.m_60734_() || isMoving) {
            super.m_6807_(state, level, pos, oldState, isMoving);
        }
        this.withBlockEntityDo((BlockGetter)level, pos, ModularDieselEngineBlockEntity::updateConnectivity);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean moving) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(level.m_276867_(pos))));
        super.m_6861_(state, level, pos, block, otherPos, moving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        EngineUpgrades upgrade2;
        ItemStack stack = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!player.m_6144_() && player.m_36326_() && placementHelper.matchesItem(stack)) {
            placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.m_41720_(), player, hand, hitResult);
            return InteractionResult.SUCCESS;
        }
        for (EngineUpgrades upgrade2 : EngineUpgrades.allUpgrades) {
            if (upgrade2 == EngineUpgrades.EMPTY || !upgrade2.getItem().m_150930_(stack.m_41720_())) continue;
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                ModularDieselEngineBlockEntity controller = be.getControllerBE();
                if (controller == null || !upgrade2.canAddOn((IEngine)be) || controller.upgrade != EngineUpgrades.EMPTY) {
                    return;
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                be.upgrade = upgrade2;
                IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
                controller.sendData();
            });
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)CDGConfig.ENGINES_FILLED_WITH_ITEMS.get()).booleanValue() || stack.m_41619_() || !((upgrade2 = level.m_7702_(pos)) instanceof SmartBlockEntity)) {
            return InteractionResult.PASS;
        }
        SmartBlockEntity be2 = (SmartBlockEntity)upgrade2;
        IFluidHandler tank = (IFluidHandler)be2.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (tank == null) {
            return InteractionResult.PASS;
        }
        if (stack.m_41720_() instanceof BucketItem || stack.m_41720_() instanceof MilkBucketItem) {
            Fluid fluid;
            Item item = stack.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bi = (BucketItem)item;
                v0 = bi.getFluid();
            } else {
                v0 = fluid = (Fluid)ForgeMod.MILK.get();
            }
            if (!tank.getFluidInTank(0).isEmpty()) {
                return InteractionResult.FAIL;
            }
            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_7500_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            }
            return InteractionResult.SUCCESS;
        }
        IFluidHandlerItem itemTank = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (itemTank == null) {
            return InteractionResult.PASS;
        }
        itemTank.drain(tank.fill(itemTank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_() == Direction.UP) {
            KineticBlockEntity.switchToBlockState((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (BlockState)this.updateAfterWrenched((BlockState)state.m_61124_((Property)PIPE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)PIPE) == false)), context));
            IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), be -> {
            ModularDieselEngineBlockEntity controller = be.getControllerBE();
            if (controller == null || controller.upgrade == EngineUpgrades.EMPTY || context.m_43725_().m_5776_()) {
                return;
            }
            if (!context.m_43723_().m_7500_()) {
                context.m_43723_().m_150109_().m_150079_(controller.upgrade.getItem());
            }
            controller.upgrade = EngineUpgrades.EMPTY;
            controller.sendData();
            IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
        });
        return InteractionResult.SUCCESS;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PIPE, DieselEngineBlock.POWERED});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        if (pContext.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_())) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    ModularDieselEngineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)be.upgrade.getItem());
                }
            });
        }
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_()) && (blockEntity = level.m_7702_(pos)) instanceof ModularDieselEngineBlockEntity) {
            ModularDieselEngineBlockEntity be2 = (ModularDieselEngineBlockEntity)blockEntity;
            level.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)be2);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public Class<ModularDieselEngineBlockEntity> getBlockEntityClass() {
        return ModularDieselEngineBlockEntity.class;
    }

    public BlockEntityType<? extends ModularDieselEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.MODULAR_DIESEL_ENGINE.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_((Property)FACING) == Direction.NORTH || pState.m_61143_((Property)FACING) == Direction.SOUTH) {
            return Shapes.m_83110_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)-2.0, (double)0.0, (double)0.0, (double)18.0, (double)4.0, (double)16.0));
        }
        return Shapes.m_83110_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)-2.0, (double)16.0, (double)4.0, (double)18.0));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == face.m_122434_();
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.m_61143_((Property)FACING)).m_122434_();
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(CDGBlocks.MODULAR_DIESEL_ENGINE.asStack());
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, list);
    }

    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(arg_0 -> CDGBlocks.MODULAR_DIESEL_ENGINE.has(arg_0), state -> ((Direction)state.m_61143_((Property)FACING)).m_122434_(), (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CDGBlocks.MODULAR_DIESEL_ENGINE.isIn(arg_0);
        }
    }
}

