/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.huge;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineSoundInstance;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineValueBox;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.PoweredEngineShaftBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.DistExecutor;

public class HugeDieselEngineBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IEngine {
    ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    float remainingTicks = 0.0f;
    EngineUpgrades upgrade = EngineUpgrades.EMPTY;
    SmartFluidTankBehaviour tank;
    WeakReference<PoweredEngineShaftBlockEntity> target = new WeakReference<Object>(null);
    @OnlyIn(value=Dist.CLIENT)
    protected EngineSoundInstance soundInstance;

    public HugeDieselEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128350_("RemainingTicks", this.remainingTicks);
        tag.m_128359_("Upgrade", this.upgrade.getId().toString());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.remainingTicks = tag.m_128457_("RemainingTicks");
        this.upgrade = EngineUpgrades.get(new ResourceLocation(tag.m_128461_("Upgrade")));
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public void tick() {
        super.tick();
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return;
        }
        if (this.enabled()) {
            if (this.remainingTicks < 2.0f) {
                this.remainingTicks += 1.0f / this.getFuelBurnRate();
                this.tank.getPrimaryHandler().drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.remainingTicks >= 0.0f) {
                this.remainingTicks -= 1.0f;
            }
            if (shaft.movementDirection != 0 && shaft.movementDirection != (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? 1 : -1)) {
                shaft.removeGenerator(this.f_58858_);
                this.onDirectionChanged(this.movementDirection.getValue());
                return;
            }
            shaft.update(this.f_58858_, this.movementDirection.getValue() == 0 ? 1 : -1, this.upgrade.getCapacity(this.getFuelCapacity(), this), this.upgrade.getSpeed(this.getFuelSpeed(), this));
            if (this.f_58857_.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::tickClient);
            }
        } else {
            shaft.removeGenerator(this.f_58858_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient() {
        if (this.enabled()) {
            if (this.soundInstance == null || this.soundInstance.m_7801_()) {
                this.soundInstance = this.upgrade.createSoundInstance(this, Vec3.m_82512_((Vec3i)this.m_58899_()));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
            } else if (this.soundInstance.active()) {
                this.soundInstance.keepAlive();
                this.soundInstance.setPitch(this.upgrade.getPitchMultiplier(this) * this.getFuelSoundPitch() / 2.0f);
                this.soundInstance.setVolume(this.upgrade.getVolume(this));
            }
        } else if (this.soundInstance != null) {
            this.soundInstance.fadeOut();
            this.soundInstance = null;
        }
    }

    public PoweredEngineShaftBlockEntity getShaft() {
        PoweredEngineShaftBlockEntity shaft = (PoweredEngineShaftBlockEntity)((Object)this.target.get());
        if (shaft == null || shaft.m_58901_() || !shaft.canBePoweredBy()) {
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            BlockEntity anyShaftAt = this.f_58857_.m_7702_(this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING), 2));
            BlockState sState = this.f_58857_.m_8055_(this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING), 2));
            if (anyShaftAt instanceof PoweredEngineShaftBlockEntity) {
                PoweredEngineShaftBlockEntity ps;
                shaft = ps = (PoweredEngineShaftBlockEntity)anyShaftAt;
                this.target = new WeakReference<PoweredEngineShaftBlockEntity>(shaft);
            }
        }
        return shaft;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new HugeDieselEngineValueBox());
        this.movementDirection.withCallback(this::onDirectionChanged);
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)100);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    private void onDirectionChanged(int v) {
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return;
        }
        for (Pair<BlockPos, Couple<Float>> engine : shaft.engines) {
            BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)engine.getFirst());
            if (!(blockEntity instanceof HugeDieselEngineBlockEntity)) continue;
            HugeDieselEngineBlockEntity be = (HugeDieselEngineBlockEntity)blockEntity;
            be.movementDirection.setValue(v);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == null || side.m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_())) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled() || !this.enabled()) {
            return false;
        }
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return false;
        }
        float stressBase = this.upgrade.getCapacity(this.getFuelCapacity(), this) * this.upgrade.getSpeed(this.getFuelSpeed(), this);
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return false;
        }
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float stressTotal = Math.abs(stressBase);
        CreateLang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
    }

    public Float getTargetAngle() {
        BlockState state = this.m_58900_();
        if (!CDGBlocks.HUGE_DIESEL_ENGINE.has(state)) {
            return null;
        }
        Direction facing = (Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING);
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        Direction.Axis facingAxis = facing.m_122434_();
        if (shaft == null) {
            return null;
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        float angle = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)shaft, (BlockPos)shaft.m_58899_(), (Direction.Axis)axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.m_122479_() && facingAxis == Direction.Axis.X ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            angle *= -1.0f;
        }
        if (axis == Direction.Axis.X && facing == Direction.DOWN) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    @Override
    public float getRemainingTicks() {
        return this.remainingTicks;
    }

    @Override
    public SmartBlockEntity self() {
        return this;
    }

    @Override
    public FluidTank getTank() {
        return this.tank.getPrimaryHandler();
    }

    @Override
    public EngineUpgrades getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(EngineUpgrades upgrade) {
        this.upgrade = upgrade;
    }
}

