/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.carcinogenius;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import galena.oreganized.carcinogenius.data.OBlockStates;
import galena.oreganized.carcinogenius.data.OBlockTags;
import galena.oreganized.carcinogenius.data.OItemModels;
import galena.oreganized.carcinogenius.data.OLang;
import galena.oreganized.carcinogenius.data.OLootTables;
import galena.oreganized.carcinogenius.data.ORecipes;
import galena.oreganized.carcinogenius.index.OCBlocks;
import galena.oreganized.carcinogenius.index.OCEffects;
import galena.oreganized.carcinogenius.index.OCItems;
import galena.oreganized.carcinogenius.index.OCParticleTypes;
import galena.oreganized.carcinogenius.index.OCPotions;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="oreganized_carcinogenius")
public class OreganizedCarcinogenius {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String NAMESPACE = "oreganized";
    public static final String MOD_ID = "oreganized_carcinogenius";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("oreganized");
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"oreganized");

    public static ResourceLocation modLoc(String location) {
        return new ResourceLocation(NAMESPACE, location);
    }

    public OreganizedCarcinogenius() {
        DeferredRegister[] registers;
        IEventBus modBus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        modBus.addListener(this::buildCreativeModeTabContents);
        for (DeferredRegister register : registers = new DeferredRegister[]{OCEffects.EFFECTS, OCParticleTypes.PARTICLES, OCPotions.POTIONS, LOOT_MODIFIERS}) {
            register.register(modBus);
        }
        REGISTRY_HELPER.register(modBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> PotionBrewing.m_43513_((Potion)Potions.f_43599_, (Item)((Item)OCItems.REFINED_ASBESTOS.get()), (Potion)((Potion)OCPotions.LUNG_DAMAGE.get())));
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture future = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        OLang lang = new OLang(output);
        generator.addProvider(client, (DataProvider)new OBlockStates(output, helper));
        generator.addProvider(client, (DataProvider)new OItemModels(output, helper));
        generator.addProvider(client, (DataProvider)lang);
        generator.addProvider(server, (DataProvider)new ORecipes(output));
        generator.addProvider(server, (DataProvider)new OLootTables(output));
        OBlockTags blockTags = new OBlockTags(output, future, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Oreganized Carcinogenius resources"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
    }

    @SubscribeEvent
    public void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        OreganizedCarcinogenius.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.LEAD_BLOCK.get(), OCBlocks.ASBESTOS_BLOCK);
        OreganizedCarcinogenius.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.RAW_SILVER_BLOCK.get(), OCBlocks.RAW_ASBESTOS_BLOCK);
        OreganizedCarcinogenius.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.DEEPSLATE_SILVER_ORE.get(), OCBlocks.ASBESTOS_ORE);
        OreganizedCarcinogenius.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OCBlocks.ASBESTOS_ORE.get(), OCBlocks.DEEPSLATE_ASBESTOS_ORE);
        OreganizedCarcinogenius.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.RAW_SILVER.get(), OCItems.RAW_ASBESTOS);
        OreganizedCarcinogenius.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OCItems.RAW_ASBESTOS.get(), OCItems.REFINED_ASBESTOS);
    }

    private static void putAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike after, Supplier<? extends ItemLike> supplier) {
        ItemLike key = supplier.get();
        if (!entries.contains((Object)new ItemStack(after))) {
            return;
        }
        entries.putAfter((Object)new ItemStack(after), (Object)new ItemStack(key), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

