/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.base.holders.AmmoType;
import com.nukateam.ntgl.common.base.holders.FireMode;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GunStateHelper {
    public static final String AMMO_TAG = "Projectile";
    public static final String FIRE_MODE = "FireMode";

    public static int getAmmoCount(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128451_("AmmoCount");
    }

    public static void switchAmmo(GunData data) {
        Set<ResourceLocation> ammoItems = GunModifierHelper.getAmmoItems(data);
        ResourceLocation current = GunStateHelper.getAmmoId(data);
        ResourceLocation newAmmo = GunStateHelper.cycleSet(ammoItems, current);
        GunStateHelper.setCurrentAmmo(data, newAmmo);
    }

    public static ResourceKey<DamageType> getDamageType(GunData data) {
        Ammo ammo = GunStateHelper.getAmmoConfig(data);
        return ammo.getDamageType();
    }

    public static void setCurrentAmmo(GunData data, ResourceLocation ammo) {
        CompoundTag tag = data.gun.m_41784_();
        tag.m_128359_(AMMO_TAG, ammo.toString());
        data.gun.m_41751_(tag);
    }

    public static ResourceLocation getAmmoId(GunData data) {
        CompoundTag tag = data.gun.m_41784_();
        Set<ResourceLocation> ammoItems = GunModifierHelper.getAmmoItems(data);
        ResourceLocation currentAmmo = GunStateHelper.getAmmoId(tag);
        if (currentAmmo == null) {
            return GunStateHelper.getFirst(ammoItems);
        }
        return currentAmmo;
    }

    @Nullable
    private static ResourceLocation getAmmoId(CompoundTag tag) {
        if (tag.m_128425_(AMMO_TAG, 8)) {
            return ResourceLocation.m_135820_((String)tag.m_128461_(AMMO_TAG));
        }
        return null;
    }

    public static boolean isCurrentAmmo(GunData gunData, Item item) {
        return GunStateHelper.getAmmoId(gunData).equals((Object)ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public static Item getAmmoItem(GunData data) {
        return (Item)ForgeRegistries.ITEMS.getValue(GunStateHelper.getAmmoId(data));
    }

    public static AmmoType getAmmoType(GunData data) {
        Ammo ammo = GunStateHelper.getAmmoConfig(data);
        return ammo.getType();
    }

    @NotNull
    public static Ammo getAmmoConfig(GunData data) {
        ResourceLocation ammoId = GunStateHelper.getAmmoId(data);
        return GunModifierHelper.getAmmoConfig(ammoId, data);
    }

    public static void switchFireMode(GunData data) {
        Set<FireMode> fireModes = GunModifierHelper.getFireModes(data);
        FireMode current = GunStateHelper.getFireMode(data);
        FireMode newFireMode = GunStateHelper.cycleSet(fireModes, current);
        GunStateHelper.setFireMode(data, newFireMode);
    }

    public static void setFireMode(GunData data, FireMode fireMode) {
        CompoundTag tag = data.gun.m_41784_();
        tag.m_128359_(FIRE_MODE, fireMode.toString());
        data.gun.m_41751_(tag);
    }

    public static FireMode getFireMode(GunData data) {
        Set<FireMode> fireModes = GunModifierHelper.getFireModes(data);
        FireMode currentFireMode = GunStateHelper.getFireMode(data.gun);
        if (currentFireMode == null || !fireModes.contains(currentFireMode)) {
            GunStateHelper.setFireMode(data, GunStateHelper.getFirst(fireModes));
            return GunStateHelper.getFirst(fireModes);
        }
        return currentFireMode;
    }

    @Nullable
    private static FireMode getFireMode(ItemStack gun) {
        CompoundTag tag = gun.m_41784_();
        if (tag.m_128425_(FIRE_MODE, 8)) {
            return FireMode.getType(tag.m_128461_(FIRE_MODE));
        }
        return null;
    }

    private static <T> T cycleSet(Set<T> set, T value) {
        ArrayList buff = new ArrayList(set.stream().toList());
        int i = buff.indexOf(value);
        i = i == set.size() - 1 ? 0 : ++i;
        return (T)buff.get(i);
    }

    public static <T> T getFirst(Set<T> set) {
        return set.iterator().next();
    }
}

