/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.base.holders.AttachmentType;
import com.nukateam.ntgl.common.base.holders.FireMode;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.holders.GripType;
import com.nukateam.ntgl.common.base.holders.LoadingType;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.attachment.impl.Attachment;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.data.config.Fuel;
import com.nukateam.ntgl.common.data.config.attachment.Modifiers;
import com.nukateam.ntgl.common.data.config.gun.General;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IAmmo;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class GunModifierHelper {
    private static final IGunModifier[] EMPTY = new IGunModifier[0];
    public static final Ammo PROJECTILE = new Ammo();

    @Deprecated
    public static Ammo getCurrentAmmo(GunData data) {
        return GunStateHelper.getAmmoConfig(data);
    }

    public static boolean isAuto(GunData itemStack) {
        return GunStateHelper.getFireMode(itemStack) == FireMode.AUTO;
    }

    public static boolean isWeaponFull(GunData data) {
        CompoundTag tag = data.gun.m_41784_();
        Gun gun = ((GunItem)data.gun.m_41720_()).getModifiedGun(data.gun);
        return tag.m_128451_("AmmoCount") >= GunEnchantmentHelper.getAmmoCapacity(data);
    }

    public static boolean canRenderInOffhand(LivingEntity player) {
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        return GunModifierHelper.isOneHanded(new GunData(mainHandItem, player)) && GunModifierHelper.isOneHanded(new GunData(offhandItem, player));
    }

    public static boolean isOneHanded(GunData data) {
        if (data.gun.m_41720_() instanceof GunItem) {
            return GunModifierHelper.getGripType(data).isOneHanded();
        }
        return true;
    }

    public static boolean isGun(ItemStack data) {
        Item gunItem = data.m_41720_();
        return gunItem instanceof GunItem;
    }

    public static Gun getGun(ItemStack stack) {
        GunItem gunItem = (GunItem)stack.m_41720_();
        return gunItem.getModifiedGun(stack);
    }

    public static General getGeneral(Gun gun) {
        return gun.getGeneral();
    }

    public static Map<AttachmentType, ArrayList<Modules.Attachment>> getAttachmentTypes(GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        return gun.getModules().getAttachments();
    }

    public static ArrayList<AttachmentType> getSortedAttachmentTypes(GunData data) {
        Map<AttachmentType, ArrayList<Modules.Attachment>> attachments = GunModifierHelper.getAttachmentTypes(data);
        ArrayList<AttachmentType> sortedTypes = new ArrayList<AttachmentType>(attachments.keySet());
        sortedTypes.sort(Comparator.comparing(AttachmentType::toString));
        return sortedTypes;
    }

    public static boolean isAlwaysSpread(GunData data) {
        AtomicBoolean isAlwaysSpread = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isAlwaysSpread());
        return isAlwaysSpread.get();
    }

    public static int getMaxAmmo(GunData data) {
        AtomicInteger finalMaxAmmo = new AtomicInteger(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getMaxAmmo());
        Ammo config = GunStateHelper.getAmmoConfig(data);
        if (data != null && config != null && data.gun.m_41720_() instanceof GunItem && GunStateHelper.getAmmoConfig(data).isMagazineMode()) {
            ResourceLocation id = GunStateHelper.getAmmoId(data);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            finalMaxAmmo.set(item.getMaxDamage(new ItemStack((ItemLike)item)));
        }
        GunModifierHelper.forEachAttachment(data, modifier -> finalMaxAmmo.set(modifier.modifyMaxAmmo(finalMaxAmmo.get(), data)));
        return finalMaxAmmo.get();
    }

    public static boolean isAutoReloading(GunData data) {
        AtomicBoolean autoReloading = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isAutoReloading());
        GunModifierHelper.forEachAttachment(data, modifier -> autoReloading.set(modifier.modifyAutoReloading(autoReloading.get(), data)));
        return autoReloading.get();
    }

    public static ResourceLocation getFireSound(GunData data) {
        AtomicReference<ResourceLocation> fireSound = new AtomicReference<ResourceLocation>(GunModifierHelper.getGun(data.gun).getSounds().getFire());
        GunModifierHelper.forEachAttachment(data, modifier -> fireSound.set(modifier.modifyFireSound((ResourceLocation)fireSound.get(), data)));
        return fireSound.get();
    }

    public static boolean shouldRenderHud(GunData data) {
        AtomicBoolean renderHud = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).shouldRenderHud());
        GunModifierHelper.forEachAttachment(data, modifier -> renderHud.set(modifier.modifyShouldRenderHud(renderHud.get(), data)));
        return renderHud.get();
    }

    public static LoadingType getLoadingType(GunData data) {
        AtomicReference<LoadingType> loadingType = new AtomicReference<LoadingType>(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getLoadingType());
        GunModifierHelper.forEachAttachment(data, modifier -> loadingType.set(modifier.modifyLoadingType((LoadingType)loadingType.get(), data)));
        return loadingType.get();
    }

    public static int getProjectileAmount(GunData data) {
        int gunProjectileAmount = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getProjectileAmount();
        int ammoProjectileAmount = GunStateHelper.getAmmoConfig(data).getProjectileAmount();
        AtomicInteger finalProjectileAmount = new AtomicInteger(gunProjectileAmount * ammoProjectileAmount);
        GunModifierHelper.forEachAttachment(data, modifier -> finalProjectileAmount.set(modifier.modifyProjectileAmount(finalProjectileAmount.get(), data)));
        return finalProjectileAmount.get();
    }

    public static Set<FireMode> getFireModes(GunData data) {
        Set<FireMode> fireMode = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getFireModes();
        AtomicReference<Set<FireMode>> finalFireMode = new AtomicReference<Set<FireMode>>(fireMode);
        GunModifierHelper.forEachAttachment(data, modifier -> finalFireMode.set(modifier.modifyFireModes((Set)finalFireMode.get(), data)));
        return finalFireMode.get();
    }

    public static GripType getGripType(GunData data) {
        GripType gripType = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getGripType();
        AtomicReference<GripType> finalGripType = new AtomicReference<GripType>(gripType);
        GunModifierHelper.forEachAttachment(data, modifier -> finalGripType.set(modifier.modifyGripType((GripType)finalGripType.get(), data)));
        return finalGripType.get();
    }

    public static int getFireDelay(GunData data) {
        AtomicInteger chargeTime = new AtomicInteger(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getFireDelay());
        GunModifierHelper.forEachAttachment(data, modifier -> chargeTime.set(modifier.modifyFireDelay(chargeTime.get(), data)));
        return chargeTime.get();
    }

    public static Set<FuelType> getFuelTypes(GunData data) {
        Set<FuelType> keys = GunModifierHelper.getGun(data.gun).getFuel().keySet();
        AtomicReference<Set<FuelType>> fuel = new AtomicReference<Set<FuelType>>(keys);
        GunModifierHelper.forEachAttachment(data, modifier -> fuel.set(modifier.modifyFuel((Set)fuel.get(), data)));
        return fuel.get();
    }

    public static Integer getMaxFuel(GunData data, FuelType type) {
        Fuel fuel = GunModifierHelper.getGun(data.gun).getFuel().get(type);
        int max = fuel != null ? fuel.getMax() : 0;
        AtomicReference<Integer> result = new AtomicReference<Integer>(max);
        GunModifierHelper.forEachAttachment(data, modifier -> result.set(modifier.modifyMaxFuel((Integer)result.get(), type, data)));
        return result.get();
    }

    public static boolean needsFullCharge(GunData data) {
        AtomicBoolean needsFullCharge = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isFullCharge());
        GunModifierHelper.forEachAttachment(data, modifier -> needsFullCharge.set(modifier.modifyNeedsFullCharge(needsFullCharge.get(), data)));
        return needsFullCharge.get();
    }

    public static boolean isOneTimeCharge(GunData data) {
        AtomicBoolean oneTimeCharge = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isOneTimeCharge());
        GunModifierHelper.forEachAttachment(data, modifier -> oneTimeCharge.set(modifier.modifyIsOneTimeCharge(oneTimeCharge.get(), data)));
        return oneTimeCharge.get();
    }

    public static Set<ResourceLocation> getAmmoItems(GunData data) {
        Set<ResourceLocation> items = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getAmmo();
        AtomicReference<Set<ResourceLocation>> ammoItem = new AtomicReference<Set<ResourceLocation>>(items);
        GunModifierHelper.forEachAttachment(data, modifier -> ammoItem.set(modifier.modifyAmmoItems((Set)ammoItem.get(), data)));
        return ammoItem.get();
    }

    public static ResourceLocation getFirstAmmoItem(GunData data) {
        Set<ResourceLocation> items = GunModifierHelper.getAmmoItems(data);
        return items.iterator().next();
    }

    public static int getReloadStart(GunData data) {
        int reloadTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getReloadStart();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadStart(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getReloadTime(GunData data) {
        int reloadTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getReloadTime();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadTime(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getReloadEnd(GunData data) {
        int reloadTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getReloadEnd();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadEnd(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getEquipTime(GunData data) {
        int equipTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getEquipTime();
        AtomicInteger finalEquipTime = new AtomicInteger(equipTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalEquipTime.set(modifier.modifyEquipTime(finalEquipTime.get(), data)));
        return finalEquipTime.get();
    }

    public static int getAmmoPerShot(GunData data) {
        int equipTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getAmmoPerShot();
        AtomicInteger finalEquipTime = new AtomicInteger(equipTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalEquipTime.set(modifier.modifyAmmoPerShot(finalEquipTime.get(), data)));
        return finalEquipTime.get();
    }

    public static int getModifiedProjectileLife(GunData data, int life) {
        AtomicInteger finalLife = new AtomicInteger(life);
        GunModifierHelper.forEachAttachment(data, modifier -> finalLife.set(modifier.modifyProjectileLife(finalLife.get(), data)));
        return finalLife.get();
    }

    public static double getModifiedProjectileGravity(GunData data, double gravity) {
        AtomicReference<Double> finalGravity = new AtomicReference<Double>(gravity);
        GunModifierHelper.forEachAttachment(data, modifier -> finalGravity.set(modifier.modifyProjectileGravity((Double)finalGravity.get(), data)));
        GunModifierHelper.forEachAttachment(data, modifier -> finalGravity.updateAndGet(v -> v + modifier.additionalProjectileGravity(data)));
        return finalGravity.get();
    }

    public static float getModifiedSpread(GunData data) {
        float gunSpread = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getSpread();
        float ammoSpread = GunStateHelper.getAmmoConfig(data).getSpread();
        float spread = Math.max(gunSpread + ammoSpread, 0.0f);
        AtomicReference<Float> finalSpread = new AtomicReference<Float>(Float.valueOf(spread));
        GunModifierHelper.forEachAttachment(data, modifier -> finalSpread.set(Float.valueOf(modifier.modifyProjectileSpread(((Float)finalSpread.get()).floatValue(), data))));
        return finalSpread.get().floatValue();
    }

    public static double getModifiedProjectileSpeed(GunData data, double speed) {
        AtomicReference<Double> finalSpeed = new AtomicReference<Double>(speed);
        GunModifierHelper.forEachAttachment(data, modifier -> finalSpeed.set(modifier.modifyProjectileSpeed((Double)finalSpeed.get(), data)));
        return finalSpeed.get();
    }

    public static float getFireSoundVolume(GunData data) {
        AtomicReference<Float> volume = new AtomicReference<Float>(Float.valueOf(1.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> volume.set(Float.valueOf(modifier.modifyFireSoundVolume(((Float)volume.get()).floatValue(), data))));
        return Mth.m_14036_((float)volume.get().floatValue(), (float)0.0f, (float)16.0f);
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public static double getMuzzleFlashSize(GunData data, double size) {
        AtomicReference<Double> finalSize = new AtomicReference<Double>(size);
        GunModifierHelper.forEachAttachment(data, modifier -> finalSize.set(modifier.modifyMuzzleFlashSize((Double)finalSize.get(), data)));
        return finalSize.get();
    }

    public static double getMuzzleFlashScale(GunData data, double scale) {
        AtomicReference<Double> finalScale = new AtomicReference<Double>(scale);
        GunModifierHelper.forEachAttachment(data, modifier -> finalScale.set(modifier.modifyMuzzleFlashScale(scale, data)));
        return finalScale.get();
    }

    public static float getKickReduction(GunData data) {
        AtomicReference<Float> kickReduction = new AtomicReference<Float>(Float.valueOf(1.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> kickReduction.updateAndGet(v -> Float.valueOf(v.floatValue() * Mth.m_14036_((float)modifier.kickModifier(data), (float)0.0f, (float)1.0f))));
        return 1.0f - kickReduction.get().floatValue();
    }

    public static float getRecoilModifier(GunData data) {
        AtomicReference<Float> recoilReduction = new AtomicReference<Float>(Float.valueOf(1.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> recoilReduction.updateAndGet(v -> Float.valueOf(v.floatValue() * Mth.m_14036_((float)modifier.recoilModifier(data), (float)0.0f, (float)1.0f))));
        return 1.0f - recoilReduction.get().floatValue();
    }

    public static boolean isSilencedFire(GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        Map<AttachmentType, ArrayList<Modules.Attachment>> attachments = gun.getModules().getAttachments();
        for (AttachmentType attachmentType : attachments.keySet()) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getAttachmentModifiers(data.gun, attachmentType)) {
                if (!modifier.silencedFire(data)) continue;
                return true;
            }
        }
        return false;
    }

    public static double getModifiedFireSoundRadius(GunData data, double radius) {
        AtomicReference<Double> minRadius = new AtomicReference<Double>(radius);
        GunModifierHelper.forEachAttachment(data, modifier -> {
            double newRadius = modifier.modifyFireSoundRadius(radius, data);
            if (newRadius < (Double)minRadius.get()) {
                minRadius.set(newRadius);
            }
        });
        return Mth.m_14008_((double)minRadius.get(), (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getAdditionalDamage(GunData data) {
        AtomicReference<Float> additionalDamage = new AtomicReference<Float>(Float.valueOf(0.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> additionalDamage.updateAndGet(v -> Float.valueOf(v.floatValue() + modifier.additionalDamage(data))));
        return additionalDamage.get().floatValue();
    }

    public static float getModifiedDamage(GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        float damage = GunModifierHelper.getGeneral(gun).getDamage();
        AtomicReference<Float> finalDamage = new AtomicReference<Float>(Float.valueOf(damage *= GunModifierHelper.getAmmoDamageMultiplier(data)));
        GunModifierHelper.forEachAttachment(data, modifier -> finalDamage.set(Float.valueOf(modifier.modifyDamage(((Float)finalDamage.get()).floatValue(), data))));
        GunModifierHelper.forEachAttachment(data, modifier -> finalDamage.updateAndGet(v -> Float.valueOf(v.floatValue() + modifier.additionalDamage(data))));
        return finalDamage.get().floatValue();
    }

    public static float getAmmoDamageMultiplier(GunData data) {
        return GunStateHelper.getAmmoConfig(data).getDamage();
    }

    public static double getModifiedAimDownSightSpeed(GunData data, double speed) {
        AtomicReference<Double> buffSpeed = new AtomicReference<Double>(speed);
        GunModifierHelper.forEachAttachment(data, modifier -> buffSpeed.set(modifier.modifyAimDownSightSpeed((Double)buffSpeed.get(), data)));
        return Mth.m_14008_((double)buffSpeed.get(), (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getRate(GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        int rate = GunEnchantmentHelper.getRate(data.gun, gun);
        AtomicInteger buffRate = new AtomicInteger(rate);
        GunModifierHelper.forEachAttachment(data, modifier -> buffRate.set(modifier.modifyFireRate(buffRate.get(), data)));
        return Mth.m_14045_((int)buffRate.get(), (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(GunData data) {
        AtomicReference<Float> chance = new AtomicReference<Float>(Float.valueOf(0.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> chance.updateAndGet(v -> Float.valueOf(v.floatValue() + modifier.criticalChance(data))));
        chance.updateAndGet(v -> Float.valueOf(v.floatValue() + GunEnchantmentHelper.getPuncturingChance(data.gun)));
        return Mth.m_14036_((float)chance.get().floatValue(), (float)0.0f, (float)1.0f);
    }

    private static void forEachAttachment(GunData data, Consumer<IGunModifier> consumer) {
        ItemStack gun = data.gun;
        Gun config = GunModifierHelper.getGun(gun);
        Map<AttachmentType, ArrayList<Modules.Attachment>> attachments = config.getModules().getAttachments();
        for (AttachmentType attachmentType : attachments.keySet()) {
            IGunModifier[] modifiers = GunModifierHelper.getAttachmentModifiers(gun, attachmentType);
            GunModifierHelper.applyModifiers(consumer, modifiers);
        }
        GunItem gunItem = (GunItem)gun.m_41720_();
        GunModifierHelper.applyModifiers(consumer, gunItem.getGunModifiers());
    }

    private static IGunModifier[] getAttachmentModifiers(ItemStack gun, AttachmentType type) {
        Item item;
        ItemStack attachmentItem = Gun.getAttachmentItem(type, gun);
        if (!attachmentItem.m_41619_() && (item = attachmentItem.m_41720_()) instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item;
            Object[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
            Modifiers configModifiers = attachment.getAttachmentConfig().getModifiers();
            return (IGunModifier[])ArrayUtils.add((Object[])modifiers, (Object)configModifiers);
        }
        return EMPTY;
    }

    private static void applyModifiers(Consumer<IGunModifier> consumer, IGunModifier ... gunModifiers) {
        for (IGunModifier modifier : gunModifiers) {
            consumer.accept(modifier);
        }
    }

    public static Ammo getAmmoConfig(ResourceLocation ammoId, GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        Ammo config = null;
        Item item = GunStateHelper.getAmmoItem(data);
        if (gun.hasAmmo(ammoId)) {
            config = gun.getAmmoConfig(ammoId);
        } else if (item instanceof IAmmo) {
            IAmmo ammoItem = (IAmmo)item;
            config = ammoItem.getAmmo();
        }
        return config != null ? config : new Ammo();
    }
}

