/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.helpers.compatibility;

import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.util.helpers.context.IAmmoContext;
import com.nukateam.ntgl.common.util.helpers.context.SophisticatedAmmoContext;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class SophisticatedHelper {
    @Nullable
    private static ItemStack getBackpackItem(Player player) {
        Optional backpackCurio = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> stack.m_41720_() instanceof BackpackItem);
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        if (backpackCurio.isPresent()) {
            return ((SlotResult)backpackCurio.get()).stack();
        }
        if (chestStack.m_41720_() instanceof BackpackItem) {
            return chestStack;
        }
        return null;
    }

    public static IBackpackWrapper getBackpackWrapper(ItemStack stack) {
        return stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).resolve().orElse(null);
    }

    @Nullable
    private static IItemHandler getBackpackInventory(Player player) {
        ItemStack backpackStack = SophisticatedHelper.getBackpackItem(player);
        if (backpackStack != null) {
            IBackpackWrapper wrapper = SophisticatedHelper.getBackpackWrapper(backpackStack);
            return wrapper != null ? wrapper.getInventoryHandler() : null;
        }
        return null;
    }

    public static IAmmoContext findAmmo(Player player, ResourceLocation id) {
        IItemHandler inventory = SophisticatedHelper.getBackpackInventory(player);
        if (inventory == null) {
            return SophisticatedAmmoContext.NONE;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!Gun.isAmmo(stack, id)) continue;
            return new SophisticatedAmmoContext(stack, inventory);
        }
        return SophisticatedAmmoContext.NONE;
    }

    public static IAmmoContext findMagazine(Player player, ResourceLocation id) {
        IItemHandler inventory = SophisticatedHelper.getBackpackInventory(player);
        if (inventory == null) {
            return SophisticatedAmmoContext.NONE;
        }
        ItemStack ammo = null;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!Gun.isAmmo(stack, id)) continue;
            if (stack.m_41773_() == 0) {
                return new SophisticatedAmmoContext(stack, inventory);
            }
            if (ammo != null && (stack.m_41773_() >= ammo.m_41773_() || ammo.m_41773_() >= ammo.m_41776_())) continue;
            ammo = stack;
        }
        return ammo == null ? SophisticatedAmmoContext.NONE : new SophisticatedAmmoContext(ammo, inventory);
    }
}

