/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import com.nukateam.ntgl.common.base.NetworkAmmoManager;
import com.nukateam.ntgl.common.base.utils.loaders.CustomAmmoLoader;
import com.nukateam.ntgl.common.base.utils.loaders.CustomGunLoader;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.data.config.CustomAmmo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class S2CMessageUpdateAmmo
extends PlayMessage<S2CMessageUpdateAmmo> {
    private ImmutableMap<ResourceLocation, Ammo> registeredGuns;
    private ImmutableMap<ResourceLocation, CustomAmmo> customGuns;

    public void encode(S2CMessageUpdateAmmo message, FriendlyByteBuf buffer) {
        Validate.notNull((Object)((Object)NetworkAmmoManager.get()));
        Validate.notNull((Object)((Object)CustomGunLoader.get()));
        NetworkAmmoManager.get().writeRegisteredAmmo(buffer);
        CustomGunLoader.get().writeCustomGuns(buffer);
    }

    public S2CMessageUpdateAmmo decode(FriendlyByteBuf buffer) {
        S2CMessageUpdateAmmo message = new S2CMessageUpdateAmmo();
        message.registeredGuns = NetworkAmmoManager.readRegisteredAmmo(buffer);
        message.customGuns = CustomAmmoLoader.readCustomAmmo(buffer);
        return message;
    }

    public void handle(S2CMessageUpdateAmmo message, MessageContext supplier) {
        supplier.execute(() -> ClientPlayHandler.handleUpdateAmmo(message));
        supplier.setHandled(true);
    }

    public ImmutableMap<ResourceLocation, Ammo> getRegisteredAmmo() {
        return this.registeredGuns;
    }

    public ImmutableMap<ResourceLocation, CustomAmmo> getCustomAmmo() {
        return this.customGuns;
    }
}

