/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.handlers;

import com.nukateam.ntgl.common.base.utils.ShootTracker;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class ServerEvent {
    @SubscribeEvent
    public static void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase != TickEvent.Phase.START) {
            ServerEvent.handleAutoReload((ServerPlayer)event.player, InteractionHand.MAIN_HAND);
            ServerEvent.handleAutoReload((ServerPlayer)event.player, InteractionHand.OFF_HAND);
        }
    }

    private static void handleAutoReload(ServerPlayer player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ShootTracker shootTracker = ShootTracker.getShootTracker((LivingEntity)player, hand);
        if (!player.m_7500_() && GunModifierHelper.isGun(stack) && GunModifierHelper.isAutoReloading(new GunData(stack, (LivingEntity)player)) && shootTracker.hasCooldown()) {
            ServerPlayHandler.reloadGun(hand, player);
        }
    }
}

