/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.init;

import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModDamageTypes {
    public static final ResourceKey<DamageType> BULLET = ModDamageTypes.create("bullet");
    public static final ResourceKey<DamageType> ENERGY = ModDamageTypes.create("energy");
    public static final ResourceKey<DamageType> EXPLOSIVE = ModDamageTypes.create("explosive");
    public static final ResourceKey<DamageType> FIRE = ModDamageTypes.create("fire");

    @NotNull
    private static ResourceKey<DamageType> create(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)ResourceLocation.m_214293_((String)"ntgl", (String)name));
    }

    public static void bootstrap(BootstapContext<DamageType> bootstapContext) {
        bootstapContext.m_255272_(BULLET, (Object)new DamageType("bullet", 0.1f));
    }

    public static class Sources {
        private static Holder.Reference<DamageType> getHolder(RegistryAccess access, ResourceKey<DamageType> damageTypeKey) {
            return access.m_175515_(Registries.f_268580_).m_246971_(damageTypeKey);
        }

        public static DamageSource source(RegistryAccess access, ResourceKey<DamageType> damageTypeKey, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
            return new BulletDamageSource((Holder<DamageType>)Sources.getHolder(access, damageTypeKey), directEntity, causingEntity);
        }

        public static DamageSource projectile(RegistryAccess access, ProjectileEntity projectile, LivingEntity entity) {
            return Sources.source(access, BULLET, projectile, (Entity)entity);
        }

        public static class BulletDamageSource
        extends DamageSource {
            private static final String[] msgSuffix = new String[]{"ntgl.bullet.killed", "ntgl.bullet.eliminated", "ntgl.bullet.executed", "ntgl.bullet.annihilated", "ntgl.bullet.decimated"};

            public BulletDamageSource(Holder<DamageType> pType, Entity pDirectEntity, Entity pCausingEntity) {
                super(pType, pDirectEntity, pCausingEntity);
            }

            public Component m_6157_(LivingEntity pLivingEntity) {
                ItemStack itemStack;
                String s = "death.attack." + this.m_19385_();
                if (this.m_7639_() == null && this.m_7640_() == null) {
                    LivingEntity living = pLivingEntity.m_21232_();
                    return living != null ? Component.m_237110_((String)(s + ".player"), (Object[])new Object[]{pLivingEntity.m_5446_(), living.m_5446_()}) : Component.m_237110_((String)s, (Object[])new Object[]{pLivingEntity.m_5446_()});
                }
                Component component = this.m_7639_() == null ? this.m_7640_().m_5446_() : this.m_7639_().m_5446_();
                Entity entity = this.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    itemStack = livingentity.m_21205_();
                } else {
                    itemStack = ItemStack.f_41583_;
                }
                ItemStack stack = itemStack;
                return !stack.m_41619_() && stack.m_41788_() ? Component.m_237110_((String)(s + ".item"), (Object[])new Object[]{pLivingEntity.m_5446_(), component, stack.m_41611_()}) : Component.m_237110_((String)s, (Object[])new Object[]{pLivingEntity.m_5446_(), component});
            }

            public String m_19385_() {
                return msgSuffix[ThreadLocalRandom.current().nextInt(5)];
            }
        }
    }
}

