/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.common.base.utils.DeathType;
import com.nukateam.ntgl.common.foundation.entity.misc.AshPile;
import com.nukateam.ntgl.common.foundation.entity.projectile.GoreData;
import com.nukateam.ntgl.common.foundation.init.ModDamageTypes;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageEntityDeathFx;
import java.util.HashMap;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class DeathEffect {
    public static HashMap<Integer, GoreData> goreStats = new HashMap();

    public static void addGoreData(Entity entity, GoreData data) {
        goreStats.put(entity.m_19879_(), data);
    }

    public static GoreData getGoreData(LivingEntity entity) {
        GoreData data = goreStats.get(entity.m_19879_());
        if (data == null) {
            data = new GoreData();
            goreStats.put(entity.m_19879_(), data);
        }
        return data;
    }

    public static void createDeathEffect(LivingEntity entity, DamageSource deathType) {
        GoreData data = DeathEffect.getGoreData(entity);
        if (deathType.m_276093_(ModDamageTypes.EXPLOSIVE)) {
            entity.m_5496_((SoundEvent)ModSounds.DEATH_GORE.get(), 8.0f, 1.0f);
            data.deathType = DeathType.GORE;
        } else if (deathType.m_276093_(ModDamageTypes.ENERGY)) {
            DeathEffect.createAshPile(entity);
            entity.m_5496_((SoundEvent)ModSounds.DEATH_LASER.get(), 1.0f, 1.0f);
            data.deathType = DeathType.LASER;
        } else if (deathType.m_276093_(ModDamageTypes.FIRE)) {
            DeathEffect.createAshPile(entity);
            entity.m_5496_((SoundEvent)ModSounds.DEATH_LASER.get(), 1.0f, 1.0f);
            data.deathType = DeathType.FIRE;
        }
        PacketHandler.getPlayChannel().sendToTrackingEntity(() -> entity, (IMessage)new S2CMessageEntityDeathFx(entity.m_19879_(), data));
    }

    private static void createAshPile(LivingEntity entity) {
        if (!entity.m_20069_()) {
            Vec3 pos = new Vec3(entity.m_20185_(), (double)entity.m_146904_(), entity.m_20189_());
            AshPile ashPile = new AshPile(entity.m_9236_(), pos);
            entity.m_9236_().m_7967_((Entity)ashPile);
        }
    }
}

