/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.common.base.utils.BoundingBoxManager;
import com.nukateam.ntgl.common.base.utils.SpreadTracker;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.data.config.gun.General;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.event.GunProjectileHitEvent;
import com.nukateam.ntgl.common.foundation.ModTags;
import com.nukateam.ntgl.common.foundation.init.ModDamageTypes;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageBlood;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitBlock;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitEntity;
import com.nukateam.ntgl.common.network.message.S2CMessageRemoveProjectile;
import com.nukateam.ntgl.common.util.interfaces.IDamageable;
import com.nukateam.ntgl.common.util.interfaces.IExplosionDamageable;
import com.nukateam.ntgl.common.util.interfaces.IHeadshotBox;
import com.nukateam.ntgl.common.util.util.BufferUtil;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.common.util.util.ReflectionUtil;
import com.nukateam.ntgl.common.util.util.math.ExtendedEntityRayTraceResult;
import com.nukateam.ntgl.common.util.world.ProjectileExplosion;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import com.nukateam.ntgl.modules.enchantment.ModEnchantments;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    protected static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_();
    protected static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    protected boolean isServerSide = !this.m_9236_().m_5776_();
    protected boolean isRightHand;
    protected int shooterId;
    protected LivingEntity shooter;
    protected Gun modifiedGun;
    protected General general;
    protected Ammo projectile;
    protected ItemStack weapon = ItemStack.f_41583_;
    protected ItemStack ammo = ItemStack.f_41583_;
    protected float additionalDamage = 0.0f;
    protected EntityDimensions entitySize;
    protected double modifiedGravity;
    protected int life;

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    protected Predicate<BlockState> getBlockFilter() {
        return value -> false;
    }

    public boolean isVisible() {
        return this.projectile.isVisible();
    }

    public boolean isRightHand() {
        return true;
    }

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level level, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        this(entityType, level);
        GunData data = new GunData(weapon, shooter);
        this.shooterId = shooter.m_19879_();
        this.shooter = shooter;
        this.weapon = weapon;
        this.general = GunModifierHelper.getGeneral(GunModifierHelper.getGun(weapon));
        this.projectile = GunStateHelper.getAmmoConfig(data);
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
        this.modifiedGravity = this.projectile.isGravity() ? GunModifierHelper.getModifiedProjectileGravity(data, -0.04) : 0.0;
        this.life = GunModifierHelper.getModifiedProjectileLife(data, this.projectile.getLife());
        this.isRightHand = shooter.m_21120_(InteractionHand.MAIN_HAND) == weapon;
        this.ammo = this.setupAmmo(data);
        Vec3 dir = this.getDirection(shooter, weapon, item);
        double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(weapon);
        double speed = GunModifierHelper.getModifiedProjectileSpeed(data, (double)this.projectile.getSpeed() * speedModifier);
        this.m_20334_(dir.f_82479_ * speed, dir.f_82480_ * speed, dir.f_82481_ * speed);
        this.updateHeading();
        this.setupDirection(shooter, weapon, item);
        this.setupStartPosition(shooter);
    }

    private ItemStack setupAmmo(GunData data) {
        ItemStack weapon = data.gun;
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(GunStateHelper.getAmmoId(data));
        if (ammo != null) {
            ItemStack model;
            int customModelData = -1;
            if (weapon.m_41783_() != null && weapon.m_41783_().m_128425_("Model", 10) && (model = ItemStack.m_41712_((CompoundTag)weapon.m_41783_().m_128469_("Model"))).m_41783_() != null && model.m_41783_().m_128441_("CustomModelData")) {
                customModelData = model.m_41783_().m_128451_("CustomModelData");
            }
            ItemStack ammoStack = new ItemStack((ItemLike)ammo);
            if (customModelData != -1) {
                ammoStack.m_41784_().m_128405_("CustomModelData", customModelData);
            }
            return ammoStack;
        }
        return ItemStack.f_41583_;
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Weapon", (Tag)this.weapon.m_41739_(new CompoundTag()));
        compound.m_128365_("Ammo", (Tag)this.ammo.m_41739_(new CompoundTag()));
        compound.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        compound.m_128365_("General", (Tag)this.general.serializeNBT());
        compound.m_128347_("ModifiedGravity", this.modifiedGravity);
        compound.m_128405_("MaxLife", this.life);
    }

    protected void m_7378_(CompoundTag compound) {
        this.weapon = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Weapon"));
        this.ammo = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Ammo"));
        this.projectile = Ammo.create(compound.m_128469_("Projectile"));
        this.general = General.create(compound.m_128469_("General"));
        this.modifiedGravity = compound.m_128459_("ModifiedGravity");
        this.life = compound.m_128451_("MaxLife");
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.projectile.serializeNBT());
        buffer.m_130079_(this.general.serializeNBT());
        buffer.writeInt(this.shooterId);
        BufferUtil.writeItemStackToBufIgnoreTag((ByteBuf)buffer, this.ammo);
        buffer.writeDouble(this.modifiedGravity);
        buffer.m_130130_(this.life);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.projectile = new Ammo();
        this.projectile.deserializeNBT(buffer.m_130260_());
        this.general = new General();
        this.general.deserializeNBT(buffer.m_130260_());
        this.shooterId = buffer.readInt();
        this.ammo = BufferUtil.readItemStackFromBufIgnoreTag((ByteBuf)buffer);
        this.modifiedGravity = buffer.readDouble();
        this.life = buffer.m_130242_();
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.entitySize;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void onRemovedFromWorld() {
        if (!this.m_9236_().f_46443_) {
            PacketHandler.getPlayChannel().sendToNearbyPlayers(this::getDeathTargetPoint, (IMessage)new S2CMessageRemoveProjectile(this.m_19879_()));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon.m_41777_();
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setItem(ItemStack item) {
        this.ammo = item;
    }

    public ItemStack getItem() {
        return this.ammo;
    }

    public void setAdditionalDamage(float additionalDamage) {
        this.additionalDamage = additionalDamage;
    }

    public double getModifiedGravity() {
        return this.modifiedGravity;
    }

    public int getLife() {
        return this.projectile.getLife();
    }

    public Ammo getProjectile() {
        return this.projectile;
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getDamage() {
        if (this.weapon.m_41619_()) {
            return 0.0f;
        }
        GunData data = new GunData(this.weapon, this.shooter);
        float initialDamage = GunModifierHelper.getModifiedDamage(data) + this.additionalDamage;
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier = ((float)this.projectile.getLife() - (float)(this.f_19797_ - 1)) / (float)this.projectile.getLife();
            initialDamage *= modifier;
        }
        int projectileAmount = GunModifierHelper.getProjectileAmount(data);
        float damage = initialDamage / (float)projectileAmount;
        damage = GunEnchantmentHelper.getAcceleratorDamage(this.weapon, damage);
        return Math.max(0.0f, damage);
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateHeading();
        this.onProjectileTick();
        if (this.shooter != null) {
            if (this.isServerSide) {
                Vec3 startVec = this.m_20182_();
                Vec3 endVec = startVec.m_82549_(this.m_20184_());
                Object result = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), this.getBlockFilter());
                if (result.m_6662_() != HitResult.Type.MISS) {
                    endVec = result.m_82450_();
                }
                List<EntityResult> hitEntities = null;
                int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)this.weapon);
                if (level == 0) {
                    EntityResult entityResult = this.findEntityOnPath(this.shooter, startVec, endVec);
                    if (entityResult != null) {
                        hitEntities = Collections.singletonList(entityResult);
                    }
                } else {
                    hitEntities = this.findEntitiesOnPath(startVec, endVec);
                }
                if (hitEntities != null && hitEntities.size() > 0) {
                    for (EntityResult entityResult : hitEntities) {
                        result = new ExtendedEntityRayTraceResult(entityResult);
                        if (((EntityHitResult)result).m_82443_() instanceof Player) {
                            Player player = (Player)((EntityHitResult)result).m_82443_();
                            if (this.shooter instanceof Player && !((Player)this.shooter).m_7099_(player)) {
                                result = null;
                            }
                        }
                        if (result == null) continue;
                        this.onHit((HitResult)result, startVec, endVec);
                    }
                } else {
                    this.onHit((HitResult)result, startVec, endVec);
                }
            }
            double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
            double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
            double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
            this.m_6034_(nextPosX, nextPosY, nextPosZ);
            if (this.projectile.isGravity()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
            }
        }
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void onProjectileTick() {
    }

    protected void onExpired() {
    }

    protected void doImpactEffects(Vec3 hitVec) {
    }

    protected boolean removeOnHit() {
        return true;
    }

    @Nullable
    protected EntityResult findEntityOnPath(LivingEntity shooter, Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> PROJECTILE_TARGETS.test((Entity)entity) && shooter.m_20202_() != entity);
        double closestDistance = Double.MAX_VALUE;
        for (Entity target : entities) {
            Vec3 hitPos;
            double distanceToHit;
            EntityResult result;
            if (target.equals((Object)this.shooter) || (result = this.getHitResult(target, startVec, endVec)) == null || !((distanceToHit = startVec.m_82554_(hitPos = result.getHitPos())) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = target;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)this.shooter) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    protected void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, this))) {
            return;
        }
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            Vec3 hitVec = result.m_82450_();
            BlockPos pos = blockHitResult.m_82425_();
            BlockState state = this.m_9236_().m_8055_(pos);
            Block block = state.m_60734_();
            this.handleBlockBreaking(pos, state);
            if (!state.m_247087_() && this.removeOnHit()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (block instanceof IDamageable) {
                ((IDamageable)block).onBlockDamaged(this.m_9236_(), state, pos, this, this.getDamage(), (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
            }
            this.onHitBlock(state, pos, blockHitResult.m_82434_(), hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_);
            if (block instanceof TargetBlock) {
                TargetBlock targetBlock = (TargetBlock)block;
                int power = ReflectionUtil.updateTargetBlock(targetBlock, (LevelAccessor)this.m_9236_(), state, blockHitResult, this);
                LivingEntity livingEntity = this.shooter;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    serverPlayer.m_36220_(Stats.f_12953_);
                    CriteriaTriggers.f_10561_.m_70211_(serverPlayer, (Entity)this, blockHitResult.m_82450_(), power);
                }
            }
            if (block instanceof BellBlock) {
                BellBlock bell = (BellBlock)block;
                bell.m_49712_(this.m_9236_(), pos, blockHitResult.m_82434_());
            }
            return;
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            Player player;
            ExtendedEntityRayTraceResult entityHitResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityHitResult.m_82443_();
            if (entity.m_19879_() == this.shooter.m_19879_()) {
                return;
            }
            LivingEntity state = this.shooter;
            if (state instanceof Player && entity.m_20367_((Entity)(player = (Player)state))) {
                return;
            }
            int fireStarterLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.FIRE_STARTER.get()), (ItemStack)this.weapon);
            if (fireStarterLevel > 0) {
                entity.m_20254_(2);
            }
            this.onHitEntity(entity, result.m_82450_(), startVec, endVec, entityHitResult.isHeadshot());
            int collateralLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)this.weapon);
            if (collateralLevel == 0 && this.removeOnHit()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            entity.f_19802_ = 0;
        }
    }

    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        float newDamage;
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.weapon, this.f_19796_, damage));
        damage = newDamage;
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        DamageSource source = ModDamageTypes.Sources.source(this.m_9236_().m_9598_(), this.projectile.getDamageType(), this, (Entity)this.shooter);
        entity.m_6469_(source, damage);
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer playerShooter = (ServerPlayer)livingEntity;
            int bodyHitType = headshot ? 1 : 0;
            int hitType = critical ? 2 : bodyHitType;
            PacketHandler.getPlayChannel().sendToPlayer(() -> playerShooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_));
        this.doImpactEffects(hitVec);
    }

    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
        this.doImpactEffects(new Vec3(x, y, z));
    }

    protected void handleBlockBreaking(BlockPos pos, BlockState state) {
        float destroySpeed;
        if (((Boolean)Config.COMMON.gameplay.griefing.enableGlassBreaking.get()).booleanValue() && state.m_204336_(ModTags.Blocks.FRAGILE) && (destroySpeed = state.m_60800_((BlockGetter)this.m_9236_(), pos)) >= 0.0f) {
            float chance = ((Double)Config.COMMON.gameplay.griefing.fragileBaseBreakChance.get()).floatValue() / (destroySpeed + 1.0f);
            if (this.f_19796_.m_188501_() < chance) {
                this.m_9236_().m_46961_(pos, ((Boolean)Config.COMMON.gameplay.griefing.fragileBlockDrops.get()).booleanValue());
            }
        }
    }

    protected void updateHeading() {
        double horizontalDistance = this.m_20184_().m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)this.m_20184_().m_7098_(), (double)horizontalDistance) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public static void createExplosion(Entity entity, float radius, boolean forceNone) {
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, false, Explosion.BlockInteraction.DESTROY_WITH_DECAY);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        explosion.m_46081_().forEach(pos -> {
            if (world.m_8055_(pos).m_60734_() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.m_8055_(pos).m_60734_()).onProjectileExploded(world, world.m_8055_(pos), (BlockPos)pos, entity);
            }
        });
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (ServerPlayer player : ((ServerLevel)world).m_6907_()) {
            if (!(player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }

    public static void createFireExplosion(Entity entity, float radius, boolean forceNone) {
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        Explosion.BlockInteraction mode = Explosion.BlockInteraction.KEEP;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, true, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    protected static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d.f_82479_, (double)Vector3d.f_82480_, (double)Vector3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
    }

    private void setupStartPosition(LivingEntity shooter) {
        double posX = shooter.f_19790_ + (shooter.m_20185_() - shooter.f_19790_) / 2.0;
        double posY = shooter.f_19791_ + (shooter.m_20186_() - shooter.f_19791_) / 2.0 + (double)shooter.m_20192_();
        double posZ = shooter.f_19792_ + (shooter.m_20189_() - shooter.f_19792_) / 2.0;
        this.m_6034_(posX, posY, posZ);
    }

    private LevelLocation getDeathTargetPoint() {
        return LevelLocation.create((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)256.0);
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> onFinish) {
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (!startVec.equals((Object)(endVec = context.m_45693_()))) {
            int blockZ;
            int blockY;
            double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
            double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
            double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
            double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
            double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
            double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
            int blockX = Mth.m_14107_((double)endX);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
            T t = hitFunction.apply(context, (BlockPos)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = Mth.m_14205_((double)deltaX);
            int signY = Mth.m_14205_((double)deltaY);
            int signZ = Mth.m_14205_((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return onFinish.apply(context);
    }

    protected void setupDirection(LivingEntity shooter, ItemStack weapon, GunItem item) {
        Vec3 dir = this.getDirection(shooter, weapon, item);
        double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(weapon);
        GunData data = new GunData(weapon, shooter);
        double speed = GunModifierHelper.getModifiedProjectileSpeed(data, (double)this.projectile.getSpeed() * speedModifier);
        this.m_20334_(dir.f_82479_ * speed, dir.f_82480_ * speed, dir.f_82481_ * speed);
        this.updateHeading();
    }

    protected float getCriticalDamage(ItemStack weapon, RandomSource rand, float damage) {
        GunData data = new GunData(weapon, this.shooter);
        float chance = GunModifierHelper.getCriticalChance(data);
        if (rand.m_188501_() < chance) {
            return (float)((double)damage * (Double)Config.COMMON.gameplay.criticalDamageMultiplier.get());
        }
        return damage;
    }

    protected Vec3 getDirection(LivingEntity shooter, ItemStack weapon, GunItem item) {
        GunData data = new GunData(weapon, shooter);
        float gunSpread = GunModifierHelper.getModifiedSpread(data);
        if (gunSpread == 0.0f) {
            return this.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        }
        if (!GunModifierHelper.isAlwaysSpread(data)) {
            gunSpread *= SpreadTracker.get(shooter).getSpread(item);
        }
        if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)shooter)).booleanValue()) {
            gunSpread *= 0.5f;
        }
        return this.getVectorFromRotation(shooter.m_146909_() - gunSpread / 2.0f + this.f_19796_.m_188501_() * gunSpread, shooter.m_6080_() - gunSpread / 2.0f + this.f_19796_.m_188501_() * gunSpread);
    }

    @Nullable
    private EntityResult getHitResult(Entity target, Vec3 startVec, Vec3 endVec) {
        double expandHeight = target instanceof Player && !target.m_6047_() ? 0.0625 : 0.0;
        AABB boundingBox = target.m_20191_();
        if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue() && target instanceof ServerPlayer) {
            ServerPlayer targetPlayer = (ServerPlayer)target;
            LivingEntity livingEntity = this.shooter;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer shooterPlayer = (ServerPlayer)livingEntity;
                int ping = (int)Math.floor((double)shooterPlayer.f_8943_ / 1000.0 * 20.0 + 0.5);
                boundingBox = BoundingBoxManager.getBoundingBox((Player)targetPlayer, ping);
            }
        }
        boundingBox = boundingBox.m_82363_(0.0, expandHeight, 0.0);
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        Vec3 grownHitPos = boundingBox.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue()).m_82371_(startVec, endVec).orElse(null);
        if (hitPos == null && grownHitPos != null) {
            ClipContext clipContext = new ClipContext(startVec, grownHitPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
            BlockHitResult rayTraceResult = ProjectileEntity.rayTraceBlocks(this.m_9236_(), clipContext, this.getBlockFilter());
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                return null;
            }
            hitPos = grownHitPos;
        }
        boolean headshot = false;
        if (((Boolean)Config.COMMON.gameplay.enableHeadShots.get()).booleanValue() && target instanceof LivingEntity) {
            AABB box;
            LivingEntity livingEntity = (LivingEntity)target;
            IHeadshotBox<LivingEntity> headshotBox = BoundingBoxManager.getHeadshotBoxes(target.m_6095_());
            if (headshotBox != null && (box = headshotBox.getHeadshotBox(livingEntity)) != null) {
                Optional headshotHitPos = (box = box.m_82386_(boundingBox.m_82399_().f_82479_, boundingBox.f_82289_, boundingBox.m_82399_().f_82481_)).m_82371_(startVec, endVec);
                if (!headshotHitPos.isPresent()) {
                    box = box.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue());
                    headshotHitPos = box.m_82371_(startVec, endVec);
                }
                if (headshotHitPos.isPresent() && (hitPos == null || ((Vec3)headshotHitPos.get()).m_82554_(hitPos) < 0.5)) {
                    hitPos = (Vec3)headshotHitPos.get();
                    headshot = true;
                }
            }
        }
        if (hitPos == null) {
            return null;
        }
        return new EntityResult(target, hitPos, headshot);
    }

    private Vec3 getVectorFromRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static class EntityResult {
        private final Entity entity;
        private final Vec3 hitVec;
        private final boolean headshot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }
}

