/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.base.holders.AmmoType;
import com.nukateam.ntgl.common.base.holders.ProjectileType;
import com.nukateam.ntgl.common.base.utils.json.JsonDeserializers;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.foundation.init.ModDamageTypes;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class Ammo
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    private float damage = 1.0f;
    private float size;
    @Optional
    private float speed = 20.0f;
    private int life = 20;
    @Optional
    private AmmoType type = AmmoType.STANDARD;
    @Optional
    private ProjectileType projectile = ProjectileType.BULLET;
    @Optional
    private ResourceKey<DamageType> damageType = ModDamageTypes.BULLET;
    @Optional
    private boolean visible;
    @Optional
    private boolean gravity;
    @Optional
    private boolean damageReduceOverLife;
    @Optional
    private boolean magazineMode;
    @Optional
    private int trailColor = 16765577;
    @Optional
    private double trailLengthMultiplier = 1.0;
    @Optional
    int projectileAmount = 1;
    @Optional
    float spread;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", this.type.toString());
        tag.m_128359_("Projectile", this.projectile.toString());
        tag.m_128359_("DamageType", this.damageType.m_135782_().toString());
        tag.m_128350_("Damage", this.damage);
        tag.m_128379_("Visible", this.visible);
        tag.m_128350_("Size", this.size);
        tag.m_128350_("Speed", this.speed);
        tag.m_128405_("Life", this.life);
        tag.m_128379_("Gravity", this.gravity);
        tag.m_128379_("DamageReduceOverLife", this.damageReduceOverLife);
        tag.m_128379_("MagazineMode", this.magazineMode);
        tag.m_128405_("TrailColor", this.trailColor);
        tag.m_128347_("TrailLengthMultiplier", this.trailLengthMultiplier);
        tag.m_128405_("ProjectileAmount", this.projectileAmount);
        tag.m_128350_("Spread", this.spread);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Visible", 99)) {
            this.visible = tag.m_128471_("Visible");
        }
        if (tag.m_128425_("DamageType", 8)) {
            this.damageType = JsonDeserializers.getDamageTypeResourceKey(tag.m_128461_("DamageType"));
        }
        if (tag.m_128425_("Damage", 99)) {
            this.damage = tag.m_128457_("Damage");
        }
        if (tag.m_128425_("Size", 99)) {
            this.size = tag.m_128457_("Size");
        }
        if (tag.m_128425_("Speed", 99)) {
            this.speed = tag.m_128457_("Speed");
        }
        if (tag.m_128425_("Life", 99)) {
            this.life = tag.m_128451_("Life");
        }
        if (tag.m_128425_("Gravity", 99)) {
            this.gravity = tag.m_128471_("Gravity");
        }
        if (tag.m_128425_("DamageReduceOverLife", 99)) {
            this.damageReduceOverLife = tag.m_128471_("DamageReduceOverLife");
        }
        if (tag.m_128425_("MagazineMode", 99)) {
            this.magazineMode = tag.m_128471_("MagazineMode");
        }
        if (tag.m_128425_("TrailColor", 99)) {
            this.trailColor = tag.m_128451_("TrailColor");
        }
        if (tag.m_128425_("TrailLengthMultiplier", 99)) {
            this.trailLengthMultiplier = tag.m_128459_("TrailLengthMultiplier");
        }
        if (tag.m_128425_("Type", 8)) {
            this.type = AmmoType.getType(tag.m_128461_("Type"));
        }
        if (tag.m_128425_("Projectile", 8)) {
            this.projectile = ProjectileType.getType(tag.m_128461_("Projectile"));
        }
        if (tag.m_128425_("ProjectileAmount", 99)) {
            this.projectileAmount = tag.m_128451_("ProjectileAmount");
        }
        if (tag.m_128425_("Spread", 99)) {
            this.spread = tag.m_128457_("Spread");
        }
    }

    public JsonObject toJsonObject() {
        Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must be more than or equal to zero");
        Preconditions.checkArgument((this.size >= 0.0f ? 1 : 0) != 0, (Object)"Projectile size must be more than or equal to zero");
        Preconditions.checkArgument(((double)this.speed >= 0.0 ? 1 : 0) != 0, (Object)"Projectile speed must be more than or equal to zero");
        Preconditions.checkArgument((this.life > 0 ? 1 : 0) != 0, (Object)"Projectile life must be more than zero");
        Preconditions.checkArgument((this.trailLengthMultiplier >= 0.0 ? 1 : 0) != 0, (Object)"Projectile trail length multiplier must be more than or equal to zero");
        Preconditions.checkArgument((this.projectileAmount >= 1 ? 1 : 0) != 0, (Object)"Projectile amount must be more than or equal to one");
        Preconditions.checkArgument((this.spread >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
        JsonObject object = new JsonObject();
        if (this.visible) {
            object.addProperty("visible", Boolean.valueOf(true));
        }
        object.addProperty("damage", (Number)Float.valueOf(this.damage));
        object.addProperty("size", (Number)Float.valueOf(this.size));
        object.addProperty("speed", (Number)Float.valueOf(this.speed));
        object.addProperty("life", (Number)this.life);
        object.addProperty("type", this.type.toString());
        object.addProperty("projectile", this.projectile.toString());
        object.addProperty("damageType", this.damageType.m_135782_().toString());
        if (this.gravity) {
            object.addProperty("gravity", Boolean.valueOf(true));
        }
        if (this.damageReduceOverLife) {
            object.addProperty("damageReduceOverLife", Boolean.valueOf(this.damageReduceOverLife));
        }
        if (this.magazineMode) {
            object.addProperty("magazineMode", Boolean.valueOf(this.magazineMode));
        }
        if (this.trailColor != 16765577) {
            object.addProperty("trailColor", (Number)this.trailColor);
        }
        if (this.trailLengthMultiplier != 1.0) {
            object.addProperty("trailLengthMultiplier", (Number)this.trailLengthMultiplier);
        }
        if (this.projectileAmount != 1) {
            object.addProperty("projectileAmount", (Number)this.projectileAmount);
        }
        if (this.spread != 0.0f) {
            object.addProperty("spread", (Number)Float.valueOf(this.spread));
        }
        return object;
    }

    public Ammo copy() {
        Ammo projectile = new Ammo();
        projectile.visible = this.visible;
        projectile.damage = this.damage;
        projectile.size = this.size;
        projectile.speed = this.speed;
        projectile.life = this.life;
        projectile.gravity = this.gravity;
        projectile.damageReduceOverLife = this.damageReduceOverLife;
        projectile.magazineMode = this.magazineMode;
        projectile.trailColor = this.trailColor;
        projectile.trailLengthMultiplier = this.trailLengthMultiplier;
        projectile.type = this.type;
        projectile.projectile = this.projectile;
        projectile.damageType = this.damageType;
        projectile.projectileAmount = this.projectileAmount;
        projectile.spread = this.spread;
        return projectile;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getLife() {
        return this.life;
    }

    public boolean isGravity() {
        return this.gravity;
    }

    public boolean isDamageReduceOverLife() {
        return this.damageReduceOverLife;
    }

    public boolean isMagazineMode() {
        return this.magazineMode;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }

    public int getProjectileAmount() {
        return this.projectileAmount;
    }

    public float getSpread() {
        return this.spread;
    }

    public AmmoType getType() {
        return this.type;
    }

    public ProjectileType getProjectile() {
        return this.projectile;
    }

    public ResourceKey<DamageType> getDamageType() {
        return this.damageType;
    }

    public static Ammo create(CompoundTag tag) {
        Ammo ammo = new Ammo();
        ammo.deserializeNBT(tag);
        return ammo;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Projectile");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final Ammo projectile;

        private Builder() {
            this.projectile = new Ammo();
        }

        private Builder(Ammo projectile) {
            this.projectile = projectile.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(Ammo projectile) {
            return new Builder(projectile);
        }

        public Ammo build() {
            return this.projectile.copy();
        }

        public Builder setProjectileVisible(ResourceLocation id, boolean visible) {
            this.projectile.visible = visible;
            return this;
        }

        public Builder setProjectileSize(ResourceLocation id, float size) {
            this.projectile.size = size;
            return this;
        }

        public Builder setProjectileSpeed(ResourceLocation id, float speed) {
            this.projectile.speed = speed;
            return this;
        }

        public Builder setProjectileLife(ResourceLocation id, int life) {
            this.projectile.life = life;
            return this;
        }

        public Builder setProjectileAffectedByGravity(ResourceLocation id, boolean gravity) {
            this.projectile.gravity = gravity;
            return this;
        }

        public Builder setProjectileTrailColor(ResourceLocation id, int trailColor) {
            this.projectile.trailColor = trailColor;
            return this;
        }

        public Builder setProjectileTrailLengthMultiplier(ResourceLocation id, int trailLengthMultiplier) {
            this.projectile.trailLengthMultiplier = trailLengthMultiplier;
            return this;
        }

        public Builder setDamage(ResourceLocation id, float damage) {
            this.projectile.damage = damage;
            return this;
        }

        public Builder setReduceDamageOverLife(ResourceLocation id, boolean damageReduceOverLife) {
            this.projectile.damageReduceOverLife = damageReduceOverLife;
            return this;
        }

        public Builder setMagazineMode(ResourceLocation id, boolean magazineMode) {
            this.projectile.magazineMode = magazineMode;
            return this;
        }
    }
}

