/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils.loaders;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.base.utils.json.JsonDeserializers;
import com.nukateam.ntgl.common.data.config.gun.CustomGun;
import com.nukateam.ntgl.common.util.annotation.Validator;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class CustomGunLoader
extends SimpleJsonResourceReloadListener {
    private static CustomGunLoader instance;
    private Map<ResourceLocation, CustomGun> customGunMap = new HashMap<ResourceLocation, CustomGun>();

    public CustomGunLoader() {
        super(JsonDeserializers.GSON_INSTANCE, "custom_guns");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((resourceLocation, object) -> {
            try {
                CustomGun customGun = (CustomGun)JsonDeserializers.GSON_INSTANCE.fromJson(object, CustomGun.class);
                if (customGun != null && Validator.isValidObject(customGun)) {
                    builder.put(resourceLocation, (Object)customGun);
                } else {
                    Ntgl.LOGGER.error("Couldn't load data file {} as it is missing or malformed", resourceLocation);
                }
            }
            catch (InvalidObjectException e) {
                Ntgl.LOGGER.error("Missing required properties for {}", resourceLocation);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        this.customGunMap = builder.build();
    }

    public void writeCustomGuns(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.customGunMap.size());
        this.customGunMap.forEach((id, gun) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, CustomGun> readCustomGuns(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                CustomGun customGun = new CustomGun();
                customGun.deserializeNBT(buffer.m_130260_());
                builder.put((Object)id, (Object)customGun);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        CustomGunLoader customGunLoader = new CustomGunLoader();
        event.addListener((PreparableReloadListener)customGunLoader);
        instance = customGunLoader;
    }

    @Nullable
    public static CustomGunLoader get() {
        return instance;
    }
}

