/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ntgl")
public class SpreadTracker {
    private static final Map<LivingEntity, SpreadTracker> TRACKER_MAP = new WeakHashMap<LivingEntity, SpreadTracker>();
    private final Map<GunItem, Pair<MutableLong, MutableInt>> SPREAD_TRACKER_MAP = new HashMap<GunItem, Pair<MutableLong, MutableInt>>();

    public void update(LivingEntity entity, GunItem item) {
        Pair entry = this.SPREAD_TRACKER_MAP.computeIfAbsent(item, gun -> Pair.of((Object)new MutableLong(-1L), (Object)new MutableInt()));
        MutableLong lastFire = (MutableLong)entry.getLeft();
        if (lastFire.getValue() != -1L) {
            MutableInt spreadCount = (MutableInt)entry.getRight();
            long deltaTime = System.currentTimeMillis() - lastFire.getValue();
            if (deltaTime < (long)((Integer)Config.COMMON.projectileSpread.spreadThreshold.get()).intValue()) {
                if (spreadCount.getValue() < (Integer)Config.COMMON.projectileSpread.maxCount.get()) {
                    spreadCount.increment();
                    if (spreadCount.getValue() < (Integer)Config.COMMON.projectileSpread.maxCount.get() && !((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)entity)).booleanValue()) {
                        spreadCount.increment();
                    }
                }
            } else {
                spreadCount.setValue(0);
            }
        }
        lastFire.setValue(System.currentTimeMillis());
    }

    public float getSpread(GunItem item) {
        Pair<MutableLong, MutableInt> entry = this.SPREAD_TRACKER_MAP.get(item);
        if (entry != null) {
            return (float)((MutableInt)entry.getRight()).getValue().intValue() / (float)((Integer)Config.COMMON.projectileSpread.maxCount.get()).intValue();
        }
        return 0.0f;
    }

    public static SpreadTracker get(LivingEntity entity) {
        return TRACKER_MAP.computeIfAbsent(entity, player1 -> new SpreadTracker());
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> TRACKER_MAP.remove(event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        MinecraftServer server = entity.m_20194_();
        if (server != null) {
            server.execute(() -> TRACKER_MAP.remove(entity));
        }
    }
}

