/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ShootTracker {
    private static final Map<Pair<LivingEntity, InteractionHand>, ShootTracker> SHOOT_TRACKER_MAP = new WeakHashMap<Pair<LivingEntity, InteractionHand>, ShootTracker>();
    private Pair<Long, Integer> cooldownMap = Pair.of((Object)0L, (Object)0);
    private final InteractionHand hand;

    public ShootTracker(InteractionHand hand) {
        this.hand = hand;
    }

    public static ShootTracker getShootTracker(LivingEntity entity, InteractionHand hand) {
        return SHOOT_TRACKER_MAP.computeIfAbsent((Pair<LivingEntity, InteractionHand>)Pair.of((Object)entity, (Object)hand), key -> new ShootTracker(hand));
    }

    public void putCooldown(ItemStack weapon, LivingEntity shooter) {
        GunData data = new GunData(weapon, shooter);
        int rate = GunModifierHelper.getRate(data);
        this.cooldownMap = Pair.of((Object)Util.m_137550_(), (Object)(rate * 50));
    }

    public boolean hasCooldown() {
        if (this.cooldownMap != null) {
            return Util.m_137550_() - (Long)this.cooldownMap.getLeft() < (long)((Integer)this.cooldownMap.getRight() - 50);
        }
        return false;
    }

    public long getRemaining() {
        if (this.cooldownMap != null) {
            return (long)((Integer)this.cooldownMap.getRight()).intValue() - (Util.m_137550_() - (Long)this.cooldownMap.getLeft());
        }
        return 0L;
    }
}

