/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.nukateam.ntgl.common.base.holders.AttachmentType;
import com.nukateam.ntgl.common.base.holders.FireMode;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.holders.ResourceHolder;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.data.config.Fuel;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class NbtUtils {
    public static CompoundTag serializeStringArray(ArrayList<String> array) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < array.size(); ++i) {
            tag.m_128359_(String.valueOf(i), array.get(i));
        }
        return tag;
    }

    public static ArrayList<String> deserializeStringArray(CompoundTag tag) {
        ArrayList<String> array = new ArrayList<String>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            array.add(tag.m_128461_(key));
        }
        return array;
    }

    public static <T> CompoundTag serializeSet(Set<T> array) {
        CompoundTag tag = new CompoundTag();
        Iterator<T> iterator = array.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            tag.m_128359_(String.valueOf(i), iterator.next().toString());
            ++i;
        }
        return tag;
    }

    public static Set<FireMode> deserializeFireMode(CompoundTag tag) {
        HashSet<FireMode> array = new HashSet<FireMode>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            array.add(FireMode.getType(ResourceLocation.m_135820_((String)tag.m_128461_(key))));
        }
        return array;
    }

    public static Set<ResourceLocation> deserializeAmmoSet(CompoundTag tag) {
        HashSet<ResourceLocation> array = new HashSet<ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            array.add(ResourceLocation.m_135820_((String)tag.m_128461_(key)));
        }
        return array;
    }

    public static <T extends INBTSerializable> CompoundTag serializeArray(ArrayList<T> array) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < array.size(); ++i) {
            tag.m_128365_(String.valueOf(i), ((INBTSerializable)array.get(i)).serializeNBT());
        }
        return tag;
    }

    public static <T extends ResourceHolder> CompoundTag serializeHolderArray(ArrayList<T> array) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < array.size(); ++i) {
            tag.m_128359_(String.valueOf(i), ((ResourceHolder)array.get(i)).toString());
        }
        return tag;
    }

    public static <T extends ResourceHolder> ArrayList<T> deserializeHolderArray(CompoundTag tag, Function<ResourceLocation, T> deserializer) {
        ArrayList<ResourceHolder> array = new ArrayList<ResourceHolder>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            String value = tag.m_128461_(key);
            ResourceHolder holder = (ResourceHolder)deserializer.apply(ResourceLocation.m_135820_((String)value));
            array.add(holder);
        }
        return array;
    }

    public static HashMap<FuelType, Fuel> deserializeFuelMap(CompoundTag tag) {
        HashMap<FuelType, Fuel> map = new HashMap<FuelType, Fuel>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            Fuel fuel = new Fuel();
            FuelType resource = FuelType.getType(key);
            fuel.deserializeNBT(tag.m_128469_(key));
            map.put(resource, fuel);
        }
        return map;
    }

    public static HashMap<ResourceLocation, Ammo> deserializeProjectileMap(CompoundTag tag) {
        HashMap<ResourceLocation, Ammo> map = new HashMap<ResourceLocation, Ammo>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            Ammo projectile = new Ammo();
            ResourceLocation resource = ResourceLocation.m_135820_((String)key);
            projectile.deserializeNBT(tag.m_128469_(key));
            map.put(resource, projectile);
        }
        return map;
    }

    public static ArrayList<Modules.Attachment> deserializeArray(CompoundTag tag) {
        ArrayList<Modules.Attachment> array = new ArrayList<Modules.Attachment>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            Modules.Attachment val = new Modules.Attachment();
            val.deserializeNBT(tag.m_128469_(key));
            array.add(val);
        }
        return array;
    }

    public static <K, R extends INBTSerializable> CompoundTag serializeMap(Map<K, R> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<K, R> entry : map.entrySet()) {
            tag.m_128365_(entry.getKey().toString(), ((INBTSerializable)entry.getValue()).serializeNBT());
        }
        return tag;
    }

    public static <K, R> CompoundTag serializeStringMap(Map<K, R> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<K, R> entry : map.entrySet()) {
            tag.m_128359_(entry.getKey().toString(), entry.getValue().toString());
        }
        return tag;
    }

    public static HashMap<String, String> deserializeStringMap(CompoundTag tag) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            map.put(key, tag.m_128461_(key));
        }
        return map;
    }

    public static HashMap<String, ResourceLocation> deserializeRLMap(CompoundTag tag) {
        HashMap<String, ResourceLocation> map = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            map.put(key, ResourceLocation.m_135820_((String)tag.m_128461_(key)));
        }
        return map;
    }

    public static <K, R extends INBTSerializable, T extends ArrayList<R>> CompoundTag serializeArrayMap(Map<K, T> map) {
        CompoundTag tag = new CompoundTag();
        for (K key : map.keySet()) {
            tag.m_128365_(key.toString(), (Tag)NbtUtils.serializeArray((ArrayList)map.get(key)));
        }
        return tag;
    }

    public static Map<AttachmentType, ArrayList<Modules.Attachment>> deserializeAttachmentMap(CompoundTag tag) {
        HashMap<AttachmentType, ArrayList<Modules.Attachment>> array = new HashMap<AttachmentType, ArrayList<Modules.Attachment>>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            array.put(AttachmentType.getType(key), NbtUtils.deserializeArray(tag.m_128469_(key)));
        }
        return array;
    }
}

