/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class FuelUtils {
    public static final String FUEL = "Fuel";

    public static CompoundTag getOrCreateFuelTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(FUEL, 10)) {
            return tag.m_128469_(FUEL);
        }
        return new CompoundTag();
    }

    public static boolean hasFuel(GunData data) {
        Set<FuelType> allFuel = GunModifierHelper.getFuelTypes(data);
        for (FuelType fuelType : allFuel) {
            int fuel = FuelUtils.getFuel(data.gun, fuelType);
            if (fuel > 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFull(GunData data, FuelType fuelType) {
        Integer max;
        int fuel = FuelUtils.getFuel(data.gun, fuelType);
        return fuel >= (max = GunModifierHelper.getMaxFuel(data, fuelType));
    }

    public static int getFuel(ItemStack stack, FuelType fuelType) {
        CompoundTag fuelTag = FuelUtils.getOrCreateFuelTag(stack);
        if (fuelTag.m_128425_(fuelType.toString(), 3)) {
            return fuelTag.m_128451_(fuelType.toString());
        }
        return 0;
    }

    public static void setFuel(ItemStack stack, FuelType fuelType, int value) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag fuelTag = FuelUtils.getOrCreateFuelTag(stack);
        fuelTag.m_128405_(fuelType.toString(), value);
        tag.m_128365_(FUEL, (Tag)fuelTag);
        stack.m_41751_(tag);
    }

    public static void addFuel(GunData data, FuelType fuelType, int value) {
        int oldValue = FuelUtils.getFuel(data.gun, fuelType);
        Integer max = GunModifierHelper.getMaxFuel(data, fuelType);
        FuelUtils.setFuel(data.gun, fuelType, Mth.m_14045_((int)(oldValue + value), (int)0, (int)max));
    }

    public static float getFuelPercent(ItemStack stack, FuelType fuelType, GunData gunData) {
        int fuel = FuelUtils.getFuel(stack, fuelType);
        Integer maxFuel = GunModifierHelper.getMaxFuel(gunData, fuelType);
        float fuelPercent = (float)fuel / (float)maxFuel.intValue();
        return fuelPercent;
    }
}

