/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.LivingEntityUtils;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class EquipTracker {
    private static final Map<Pair<HumanoidArm, Player>, EquipTracker> TRACKER_MAP = new WeakHashMap<Pair<HumanoidArm, Player>, EquipTracker>();
    private final HumanoidArm arm;
    private final ItemStack stack;
    private final GunItem gunItem;
    private final int slot;
    public int equipTick;

    private EquipTracker(Player player, HumanoidArm arm, boolean switchGuns) {
        this.arm = arm;
        this.stack = player.m_21120_(LivingEntityUtils.getInteractionHand(arm));
        this.gunItem = (GunItem)this.stack.m_41720_();
        this.slot = arm == HumanoidArm.RIGHT ? player.m_150109_().f_35977_ : 40;
        GunData data = new GunData(this.stack, (LivingEntity)player);
        this.equipTick = GunModifierHelper.getEquipTime(data);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
                Player player = event.player;
                EquipTracker.handTick(player, HumanoidArm.RIGHT);
                EquipTracker.handTick(player, HumanoidArm.LEFT);
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> TRACKER_MAP.remove(event.getEntity()));
        }
    }

    private static void handTick(Player entity, HumanoidArm arm) {
        Pair key = new Pair((Object)arm, (Object)entity);
        EquipTracker tracker = TRACKER_MAP.get(key);
        if (tracker != null) {
            if (tracker.equipTick > 0) {
                --tracker.equipTick;
            } else {
                EquipTracker.stopEquip(entity, arm);
            }
        } else {
            EquipTracker.stopEquip(entity, arm);
        }
    }

    private static SyncedDataKey<LivingEntity, Boolean> getDataKey(HumanoidArm arm) {
        SyncedDataKey<LivingEntity, Boolean> dataKey = arm == HumanoidArm.RIGHT ? ModSyncedDataKeys.EQUIP_RIGHT : ModSyncedDataKeys.EQUIP_LEFT;
        return dataKey;
    }

    public static boolean isEquiping(Player entity, HumanoidArm arm) {
        Boolean isEquiping = (Boolean)EquipTracker.getDataKey(arm).getValue((Entity)entity);
        return isEquiping;
    }

    public static void startEquip(Player entity, HumanoidArm arm) {
        EquipTracker.startEquip(entity, arm, false);
    }

    public static void startEquip(Player entity, HumanoidArm arm, boolean switchGuns) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = EquipTracker.getDataKey(arm);
        reloadKey.setValue((Entity)entity, (Object)true);
        EquipTracker.addTracker(entity, arm, switchGuns);
    }

    private static void stopEquip(Player entity, HumanoidArm arm) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = EquipTracker.getDataKey(arm);
        reloadKey.setValue((Entity)entity, (Object)false);
        TRACKER_MAP.remove(new Pair((Object)arm, (Object)entity));
    }

    private static boolean addTracker(Player entity, HumanoidArm arm, boolean switchGuns) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = EquipTracker.getDataKey(arm);
        Item gunItem = arm == HumanoidArm.RIGHT ? entity.m_21205_().m_41720_() : entity.m_21206_().m_41720_();
        Pair key = new Pair((Object)arm, (Object)entity);
        if (!TRACKER_MAP.containsKey(key)) {
            if (!(gunItem instanceof GunItem)) {
                reloadKey.setValue((Entity)entity, (Object)false);
                return true;
            }
            TRACKER_MAP.put((Pair<HumanoidArm, Player>)key, new EquipTracker(entity, arm, switchGuns));
        }
        return false;
    }
}

