/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.LivingEntityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class EntityReloadTracker {
    private final HumanoidArm arm;
    private final ItemStack stack;
    private final GunItem gunItem;
    private final Gun gun;
    private int reloadTick;
    private static final Map<LivingEntity, EntityReloadTracker> RELOAD_TRACKER_MAP = new HashMap<LivingEntity, EntityReloadTracker>();
    private static final ArrayList<LivingEntity> FOR_REMOVE = new ArrayList();

    private EntityReloadTracker(LivingEntity entity, HumanoidArm arm) {
        this.arm = arm;
        this.stack = entity.m_21120_(LivingEntityUtils.getInteractionHand(arm));
        this.gunItem = (GunItem)this.stack.m_41720_();
        this.gun = this.gunItem.getModifiedGun(this.stack);
        this.reloadTick = this.gun.getGeneral().getReloadTime();
    }

    public static boolean isReloading(LivingEntity entity) {
        return RELOAD_TRACKER_MAP.containsKey(entity);
    }

    public static void addTracker(LivingEntity entity, HumanoidArm arm) {
        EntityReloadTracker.setReloading(entity, arm, true);
        RELOAD_TRACKER_MAP.put(entity, new EntityReloadTracker(entity, arm));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START) {
                for (Map.Entry<LivingEntity, EntityReloadTracker> entry : RELOAD_TRACKER_MAP.entrySet()) {
                    EntityReloadTracker tracker = entry.getValue();
                    LivingEntity entity = entry.getKey();
                    EntityReloadTracker.onTick(entity, tracker);
                }
                EntityReloadTracker.removeTrackers();
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void removeTrackers() {
        for (LivingEntity removed : FOR_REMOVE) {
            RELOAD_TRACKER_MAP.remove(removed);
        }
        FOR_REMOVE.clear();
    }

    private static void onTick(LivingEntity entity, EntityReloadTracker tracker) {
        if (tracker.reloadTick > 0) {
            tracker.reloadTick = Math.max(tracker.reloadTick - 1, 0);
        } else {
            GunData data = new GunData(tracker.stack, entity);
            Gun.fillAmmo(data);
            EntityReloadTracker.setReloading(entity, tracker.arm, false);
            FOR_REMOVE.add(entity);
        }
    }

    private static SyncedDataKey<LivingEntity, Boolean> getReloadSataKey(HumanoidArm arm) {
        return arm == HumanoidArm.RIGHT ? ModSyncedDataKeys.RELOADING_RIGHT : ModSyncedDataKeys.RELOADING_LEFT;
    }

    private static void setReloading(LivingEntity entity, HumanoidArm arm, boolean value) {
        EntityReloadTracker.getReloadSataKey(arm).setValue((Entity)entity, (Object)value);
    }
}

