/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.holders;

import com.nukateam.ntgl.common.base.holders.ResourceHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeHooks;

public class FuelType
extends ResourceHolder {
    public static final FuelType BURNABLE = new FuelType("burnable", FuelType::isBurnable);
    public static final FuelType WATER = new FuelType("water", FuelType::isWater);
    private static final Map<ResourceLocation, FuelType> ammoTypeMap = new HashMap<ResourceLocation, FuelType>();
    private Function<ItemStack, Boolean> isAcceptable = i -> false;

    private FuelType(String id, Function<ItemStack, Boolean> isAcceptable) {
        super(ResourceLocation.m_214293_((String)"ntgl", (String)id));
        this.isAcceptable = isAcceptable;
    }

    public FuelType(ResourceLocation id, Function<ItemStack, Boolean> isAcceptable) {
        super(id);
        this.isAcceptable = isAcceptable;
    }

    public boolean isAcceptable(ItemStack ammoStack) {
        return this.isAcceptable.apply(ammoStack);
    }

    public ResourceLocation getIcon() {
        return ResourceLocation.m_214293_((String)this.id.m_135827_(), (String)("textures/hud/ammo_type/" + this.id.m_135815_() + ".png"));
    }

    public static void registerType(FuelType mode) {
        ammoTypeMap.putIfAbsent(mode.getId(), mode);
    }

    public static FuelType getType(ResourceLocation id) {
        return ammoTypeMap.getOrDefault(id, BURNABLE);
    }

    public static FuelType getType(String id) {
        return FuelType.getType(ResourceLocation.m_135820_((String)id));
    }

    public String getDescriptionId() {
        return "info." + this.id.m_135827_() + "." + this.id.m_135815_();
    }

    private static boolean isBurnable(ItemStack ammoStack) {
        int burnTime = ForgeHooks.getBurnTime((ItemStack)ammoStack, null);
        return burnTime > 0;
    }

    private static boolean isWater(ItemStack ammoStack) {
        return ammoStack.m_41720_() == Items.f_42447_;
    }

    static {
        FuelType.registerType(BURNABLE);
        FuelType.registerType(WATER);
    }
}

