/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.common.base.ConfigUtils;
import com.nukateam.ntgl.common.base.NetworkManager;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.foundation.item.interfaces.IAmmo;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAmmo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="ntgl")
public class NetworkAmmoManager
extends SimplePreparableReloadListener<Map<IAmmo, Ammo>> {
    public static final String PATH = "ammo";
    private static List<IAmmo> clientRegisteredAmmo = new ArrayList<IAmmo>();
    private static NetworkAmmoManager instance;
    private Map<ResourceLocation, Ammo> registeredAmmo = new HashMap<ResourceLocation, Ammo>();

    protected Map<IAmmo, Ammo> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return ConfigUtils.getConfigMap(manager, v -> v instanceof IAmmo, Ammo.class, PATH);
    }

    protected void apply(Map<IAmmo, Ammo> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, ammo) -> {
            Validate.notNull((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)item)));
            builder.put((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)item)), ammo);
            item.setConfig(new NetworkManager.Supplier<Ammo>((Ammo)ammo));
        });
        this.registeredAmmo = builder.build();
    }

    public void writeRegisteredAmmo(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredAmmo.size());
        this.registeredAmmo.forEach((id, ammo) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(ammo.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Ammo> readRegisteredAmmo(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                Ammo ammo = Ammo.create(buffer.m_130260_());
                builder.put((Object)id, (Object)ammo);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredAmmo(S2CMessageUpdateAmmo message) {
        return NetworkAmmoManager.updateRegisteredAmmo(message.getRegisteredAmmo());
    }

    private static boolean updateRegisteredAmmo(Map<ResourceLocation, Ammo> registeredAmmo) {
        clientRegisteredAmmo.clear();
        if (registeredAmmo != null) {
            for (Map.Entry<ResourceLocation, Ammo> entry : registeredAmmo.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof IAmmo)) {
                    return false;
                }
                ((IAmmo)item).setConfig(new NetworkManager.Supplier<Ammo>(entry.getValue()));
                clientRegisteredAmmo.add((IAmmo)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, Ammo> getRegisteredAmmo() {
        return this.registeredAmmo;
    }

    public static List<IAmmo> getClientRegisteredAmmo() {
        return ImmutableList.copyOf(clientRegisteredAmmo);
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        instance = null;
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkAmmoManager networkGunManager = new NetworkAmmoManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.getPlayChannel().sendToAll((IMessage)new S2CMessageUpdateAmmo());
        }
    }

    @Nullable
    public static NetworkAmmoManager get() {
        return instance;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkAmmoManager.get()));
            NetworkAmmoManager.get().writeRegisteredAmmo(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, Ammo> registeredAmmo = NetworkAmmoManager.readRegisteredAmmo(buffer);
            NetworkAmmoManager.updateRegisteredAmmo(registeredAmmo);
            return Optional.empty();
        }
    }

    public static class Supplier {
        private Ammo projectile;

        private Supplier(Ammo projectile) {
            this.projectile = projectile;
        }

        public Ammo getAmmo() {
            return this.projectile;
        }
    }
}

