/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.ibm.icu.impl.Pair;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.handler.ControllerHandler;
import com.nukateam.ntgl.client.util.handler.RecoilHandler;
import com.nukateam.ntgl.client.util.handler.ShootingData;
import com.nukateam.ntgl.common.base.holders.FireMode;
import com.nukateam.ntgl.common.base.holders.GripType;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessagePreFireSound;
import com.nukateam.ntgl.common.network.message.C2SMessageShoot;
import com.nukateam.ntgl.common.network.message.C2SMessageShooting;
import com.nukateam.ntgl.common.util.helpers.PlayerHelper;
import com.nukateam.ntgl.common.util.helpers.compatibility.PlayerReviveHelper;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ShootingHandler {
    private static ShootingHandler instance;
    public static float shootMsGap;
    private final HashMap<Pair<HumanoidArm, LivingEntity>, Integer> entityShootGaps = new HashMap();
    private final Map<HumanoidArm, ShootingData> shootingData = Map.of(HumanoidArm.RIGHT, new ShootingData(0, null), HumanoidArm.LEFT, new ShootingData(0, null));
    private boolean shooting;

    private ShootingHandler() {
    }

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    public static boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.MouseButton event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        boolean isRightHand = event.getButton() == mc.f_91066_.f_92096_.getKey().m_84873_();
        boolean isLeftHand = event.getButton() == mc.f_91066_.f_92095_.getKey().m_84873_();
        ItemStack heldItem = isRightHand ? player.m_21205_() : player.m_21206_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (event.getAction() == 1) {
                if (isRightHand) {
                    this.setupShootingData(heldItem, (Player)player, HumanoidArm.RIGHT);
                }
                if (isLeftHand) {
                    this.setupShootingData(heldItem, (Player)player, HumanoidArm.LEFT);
                }
            } else if (event.getAction() == 0) {
                if (isRightHand) {
                    this.resetShootingData(heldItem, (Player)player, HumanoidArm.RIGHT);
                }
                if (isLeftHand) {
                    this.resetShootingData(heldItem, (Player)player, HumanoidArm.LEFT);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        if (event.isAttack()) {
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof GunItem) {
                this.handleGunInput(event);
            }
        } else if (event.isUseItem()) {
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offhandItem = player.m_21206_();
            if (offhandItem.m_41720_() instanceof GunItem && GunModifierHelper.canRenderInOffhand((LivingEntity)player)) {
                this.handleGunInput(event);
                return;
            }
            if (mainHandItem.m_41720_() instanceof GunItem) {
                if (event.getHand() == InteractionHand.OFF_HAND) {
                    if (offhandItem.m_41720_() == Items.f_42740_ && GunModifierHelper.getGripType(new GunData(mainHandItem, (LivingEntity)player)) == GripType.ONE_HANDED) {
                        return;
                    }
                    event.setCanceled(true);
                    event.setSwingHand(false);
                    return;
                }
                if (AimingHandler.get().isZooming() && AimingHandler.get().isLookingAtInteractableBlock()) {
                    event.setCanceled(true);
                    event.setSwingHand(false);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!ShootingHandler.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        if (mainHandItem.m_41720_() instanceof GunItem && ShootingHandler.isKeyAttackDown()) {
            this.handleAutoFire(player, mainHandItem, HumanoidArm.RIGHT);
        }
        if (offhandItem.m_41720_() instanceof GunItem && GunModifierHelper.canRenderInOffhand((LivingEntity)player) && ShootingHandler.isUseKeyDown()) {
            this.handleAutoFire(player, offhandItem, HumanoidArm.LEFT);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderTickLow(TickEvent.RenderTickEvent evt) {
        if (!evt.type.equals((Object)TickEvent.Type.RENDER) || evt.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (shootMsGap > 0.0f) {
            shootMsGap -= evt.renderTickTime * ShootingHandler.visualCooldownMultiplier();
        } else if (shootMsGap < -0.05f) {
            shootMsGap = 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleGunInput(InputEvent.InteractionKeyMappingTriggered event) {
        event.setSwingHand(false);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            this.reduceGaps();
            if (!ShootingHandler.isInGame()) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                ItemStack mainHandItem = player.m_21205_();
                if (mainHandItem.m_41720_() instanceof GunItem && (Gun.hasAmmo(mainHandItem) || player.m_7500_())) {
                    boolean shooting = ShootingHandler.isKeyAttackDown();
                    if (Ntgl.controllableLoaded) {
                        shooting |= ControllerHandler.isShooting();
                    }
                    if (shooting ^ this.shooting) {
                        this.shooting = shooting;
                        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(shooting));
                    }
                } else if (this.shooting) {
                    this.shooting = false;
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
                }
            } else {
                this.shooting = false;
            }
        }
    }

    public ShootingData getShootingData(HumanoidArm arm) {
        return this.shootingData.get(arm);
    }

    public boolean isOnCooldown(LivingEntity entity, HumanoidArm arm) {
        return this.getCooldown(entity, arm) > 0;
    }

    public int getCooldown(LivingEntity entity, InteractionHand hand) {
        return this.getCooldown(entity, PlayerHelper.convertHand(hand));
    }

    public float getCooldownPercent(LivingEntity entity, InteractionHand hand) {
        ItemStack heldItem = entity.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            GunData data = new GunData(heldItem, entity);
            int rate = GunModifierHelper.getRate(data);
            int cooldown = this.getCooldown(entity, PlayerHelper.convertHand(hand));
            return (float)cooldown / (float)rate;
        }
        return 0.0f;
    }

    public void setCooldown(LivingEntity entity, HumanoidArm arm, int cooldown) {
        this.entityShootGaps.put((Pair<HumanoidArm, LivingEntity>)Pair.of((Object)arm, (Object)entity), cooldown);
    }

    public int getCooldown(LivingEntity entity, HumanoidArm arm) {
        return this.entityShootGaps.getOrDefault(Pair.of((Object)arm, (Object)entity), 0);
    }

    public boolean isShooting(LivingEntity entity, HumanoidArm arm) {
        return this.getCooldown(entity, arm) > 0;
    }

    @Deprecated
    public boolean isShooting() {
        return this.shooting;
    }

    public static float calcShootTickGap(int rpm) {
        float shootTickGap = 60.0f / (float)rpm * 20.0f;
        return shootTickGap;
    }

    public void fire(LivingEntity shooter, ItemStack heldItem) {
        Player player;
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        if (!Gun.hasAmmo(heldItem)) {
            return;
        }
        if (!Gun.hasAmmo(heldItem) && shooter instanceof Player && !(player = (Player)shooter).m_7500_()) {
            return;
        }
        if (shooter.m_5833_()) {
            return;
        }
        boolean isMainHand = shooter.m_21205_() == heldItem;
        HumanoidArm hand = isMainHand ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        Integer shootGap = this.entityShootGaps.getOrDefault(Pair.of((Object)hand, (Object)shooter), 0);
        ShootingData data = this.shootingData.get(hand);
        if (shootGap <= 0) {
            GunItem gunItem = (GunItem)heldItem.m_41720_();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(shooter, heldItem, hand))) {
                return;
            }
            GunData gunData = new GunData(heldItem, shooter);
            int rpm = GunModifierHelper.getRate(gunData);
            shootGap = shootGap + rpm;
            this.entityShootGaps.put((Pair<HumanoidArm, LivingEntity>)Pair.of((Object)hand, (Object)shooter), shootGap);
            shootMsGap = ShootingHandler.calcShootTickGap(rpm);
            RecoilHandler.get().lastRandPitch = RecoilHandler.get().lastRandPitch;
            RecoilHandler.get().lastRandYaw = RecoilHandler.get().lastRandYaw;
            try {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShoot(shooter.m_19879_(), shooter.m_5675_(1.0f), shooter.m_5686_(1.0f), RecoilHandler.get().lastRandPitch, RecoilHandler.get().lastRandYaw, isMainHand));
            }
            catch (NullPointerException e) {
                Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(shooter, heldItem, hand));
        }
    }

    private static boolean isKeyAttackDown() {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
    }

    private static boolean isUseKeyDown() {
        return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
    }

    private void reduceGaps() {
        this.entityShootGaps.forEach((key, val) -> {
            if (val > 0) {
                Integer n = val;
                val = val - 1;
            }
            this.entityShootGaps.put((Pair<HumanoidArm, LivingEntity>)key, (Integer)val);
        });
    }

    private void setupShootingData(ItemStack stack, Player player, HumanoidArm arm) {
        if (!Gun.hasAmmo(stack)) {
            return;
        }
        ShootingData data = this.shootingData.get(arm);
        GunData gunData = new GunData(stack, (LivingEntity)player);
        data.fireTimer = GunModifierHelper.getFireDelay(gunData);
        data.gun = (GunItem)stack.m_41720_();
    }

    private void resetShootingData(ItemStack stack, Player player, HumanoidArm arm) {
        ShootingData data = this.shootingData.get(arm);
        GunData gunData = new GunData(stack, (LivingEntity)player);
        if (data.fireTimer != 0 && !GunModifierHelper.needsFullCharge(gunData)) {
            this.fire((LivingEntity)Minecraft.m_91087_().f_91074_, stack);
        }
        data.fireTimer = 0;
        data.gun = null;
    }

    private void handleAutoFire(LocalPlayer player, ItemStack heldItem, HumanoidArm arm) {
        Minecraft mc = Minecraft.m_91087_();
        KeyMapping key = arm == HumanoidArm.RIGHT ? mc.f_91066_.f_92096_ : mc.f_91066_.f_92095_;
        ShootingData data = this.shootingData.get(arm);
        GunData gunData = new GunData(heldItem, (LivingEntity)player);
        FireMode fireMode = GunStateHelper.getFireMode(gunData);
        int maxChargeTime = GunModifierHelper.getFireDelay(gunData);
        if (maxChargeTime != 0) {
            boolean isOnCooldown = ShootingHandler.get().isOnCooldown((LivingEntity)player, arm);
            if (data.fireTimer > 0 && !isOnCooldown) {
                if (data.fireTimer == maxChargeTime - 2) {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessagePreFireSound((Player)player));
                }
                --data.fireTimer;
            } else {
                this.fire((LivingEntity)player, heldItem);
                if (data.fireTimer == 0 && !GunModifierHelper.isOneTimeCharge(gunData)) {
                    this.setupShootingData(heldItem, (Player)player, arm);
                }
                if (maxChargeTime > 0 && fireMode != FireMode.AUTO) {
                    key.m_7249_(false);
                }
            }
        } else {
            this.fire((LivingEntity)player, heldItem);
            if (fireMode != FireMode.AUTO) {
                key.m_7249_(false);
            }
        }
    }

    private static float visualCooldownMultiplier() {
        int fps = Minecraft.m_91087_().m_260875_();
        if (fps < 11) {
            return 8.0f;
        }
        if (fps < 21) {
            return 6.25f;
        }
        if (fps < 31) {
            return 1.25f;
        }
        if (fps < 61) {
            return 0.95f;
        }
        if (fps < 121) {
            return 0.625f;
        }
        if (fps < 181) {
            return 0.425f;
        }
        if (fps < 201) {
            return 0.35f;
        }
        return 0.25f;
    }

    static {
        shootMsGap = 0.0f;
    }
}

