/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.event.ControllerEvents;
import com.mrcrayfish.controllable.event.Value;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.input.GunButtonBindings;
import com.nukateam.ntgl.client.render.screen.WorkbenchScreen;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.handler.ClientActions;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.ShootingHandler;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageAttachments;
import com.nukateam.ntgl.common.network.message.C2SMessageUnload;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class ControllerHandler {
    private static int reloadCounter = -1;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
        ControllerEvents.INPUT.register((IFrameworkEvent)((ControllerEvents.Input)ControllerHandler::handleInput));
        ControllerEvents.UPDATE_CAMERA.register((IFrameworkEvent)((ControllerEvents.UpdateCamera)ControllerHandler::handleCamera));
        ControllerEvents.GATHER_ACTIONS.register((IFrameworkEvent)((ControllerEvents.GatherActions)ControllerHandler::handleActions));
        ControllerEvents.GATHER_NAVIGATION_POINTS.register((IFrameworkEvent)((ControllerEvents.GatherNavigationPoints)ControllerHandler::handleNavigationPoints));
    }

    private static void handleNavigationPoints(List<NavigationPoint> points) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof WorkbenchScreen) {
            int i;
            WorkbenchScreen workbench = (WorkbenchScreen)screen;
            int startX = workbench.getGuiLeft();
            int startY = workbench.getGuiTop();
            for (i = 0; i < workbench.getTabs().size(); ++i) {
                int tabX = startX + 28 * i + 14;
                int tabY = startY - 14;
                points.add((NavigationPoint)new BasicNavigationPoint((double)tabX, (double)tabY));
            }
            for (i = 0; i < 6; ++i) {
                int itemX = startX + 172 + 40;
                int itemY = startY + i * 19 + 63 + 9;
                points.add((NavigationPoint)new BasicNavigationPoint((double)itemX, (double)itemY));
            }
        }
    }

    private static void handleActions(Map<ButtonBinding, Action> actions, ActionVisibility visibility) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem) {
            Scope scope;
            actions.put(GunButtonBindings.AIM, new Action((Component)Component.m_237115_((String)"ntgl.action.aim"), Action.Side.RIGHT));
            actions.put(GunButtonBindings.SHOOT, new Action((Component)Component.m_237115_((String)"ntgl.action.shoot"), Action.Side.RIGHT));
            CompoundTag tag = heldItem.m_41783_();
            GunData data = new GunData(heldItem, (LivingEntity)player);
            if (tag != null && Gun.getAmmo(heldItem) < GunEnchantmentHelper.getAmmoCapacity(data)) {
                actions.put(GunButtonBindings.RELOAD, new Action((Component)Component.m_237115_((String)"ntgl.action.reload"), Action.Side.LEFT));
            }
            if ((scope = Gun.getScope(heldItem)) != null && scope.isStable() && AimingHandler.get().isAiming()) {
                actions.put(GunButtonBindings.STEADY_AIM, new Action((Component)Component.m_237115_((String)"ntgl.action.steady_aim"), Action.Side.RIGHT));
            }
        }
    }

    private static boolean handleCamera(Value<Float> yawSpeed, Value<Float> pitchSpeed) {
        ItemStack heldItem;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem && AimingHandler.get().isAiming()) {
            double adsSensitivity = (Double)Config.CLIENT.controls.aimDownSightSensitivity.get();
            yawSpeed.set((Object)Float.valueOf(10.0f * (float)adsSensitivity));
            pitchSpeed.set((Object)Float.valueOf(7.5f * (float)adsSensitivity));
            Scope scope = Gun.getScope(heldItem);
            Controller controller = Controllable.getController();
            if (scope != null && scope.isStable() && controller != null && controller.isButtonPressed(GunButtonBindings.STEADY_AIM.getButton())) {
                yawSpeed.set((Object)Float.valueOf(((Float)yawSpeed.get()).floatValue() / 2.0f));
                pitchSpeed.set((Object)Float.valueOf(((Float)pitchSpeed.get()).floatValue() / 2.0f));
            }
        }
        return false;
    }

    private static boolean handleInput(Controller controller, Value<Integer> newButton, int originalButton, boolean state) {
        InteractionHand hand;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        boolean shouldCancel = false;
        boolean shiftDown = ButtonBindings.SNEAK.isButtonDown();
        InteractionHand interactionHand = hand = shiftDown ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (player != null && world != null && Minecraft.m_91087_().f_91080_ == null) {
            ItemStack heldItem = player.m_21205_();
            if (!(heldItem.m_41720_() instanceof GunItem)) {
                return false;
            }
            if (ControllerHandler.isEquals(originalButton, GunButtonBindings.SHOOT)) {
                shouldCancel = true;
                if (state) {
                    ShootingHandler.get().fire((LivingEntity)player, heldItem);
                }
            } else if (ControllerHandler.isEquals(originalButton, GunButtonBindings.AIM)) {
                shouldCancel = true;
            } else if (ControllerHandler.isEquals(originalButton, GunButtonBindings.STEADY_AIM)) {
                shouldCancel = true;
            } else if (ControllerHandler.isEquals(originalButton, GunButtonBindings.RELOAD)) {
                shouldCancel = true;
                if (state) {
                    reloadCounter = 0;
                }
            } else if (ControllerHandler.isEquals(originalButton, GunButtonBindings.OPEN_ATTACHMENTS)) {
                shouldCancel = true;
                if (state) {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAttachments());
                }
            } else if (ControllerHandler.isEquals(originalButton, GunButtonBindings.INSPECT)) {
                shouldCancel = true;
                ClientActions.inspectWeapon(player);
            } else if (ControllerHandler.isEquals(originalButton, GunButtonBindings.SELECT_FIRE)) {
                shouldCancel = true;
                ClientActions.switchFireMode(hand);
            } else if (ControllerHandler.isEquals(originalButton, GunButtonBindings.SELECT_AMMO)) {
                shouldCancel = true;
                ClientActions.switchFireMode(hand);
            }
        }
        return shouldCancel;
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        Controller controller = Controllable.getController();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (player == null) {
            return;
        }
        if (controller.isButtonPressed(GunButtonBindings.SHOOT.getButton()) && Minecraft.m_91087_().f_91080_ == null) {
            ItemStack heldItem = player.m_21205_();
            GunData gunData = new GunData(heldItem, (LivingEntity)player);
            if (heldItem.m_41720_() instanceof GunItem && GunModifierHelper.isAuto(gunData)) {
                ShootingHandler.get().fire((LivingEntity)player, heldItem);
            }
        }
        if (mc.f_91080_ == null && reloadCounter != -1 && controller.isButtonPressed(GunButtonBindings.RELOAD.getButton())) {
            ++reloadCounter;
        }
        if (reloadCounter > 40) {
            ClientReloadHandler.get().setReloading(false, InteractionHand.MAIN_HAND);
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageUnload());
            reloadCounter = -1;
        } else if (reloadCounter > 0 && !controller.isButtonPressed(GunButtonBindings.RELOAD.getButton())) {
            ClientReloadHandler.get().setReloading((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)player) == false, InteractionHand.MAIN_HAND);
            reloadCounter = -1;
        }
    }

    private static boolean isEquals(int originalButton, ButtonBinding aim) {
        return originalButton == aim.getButton();
    }

    public static boolean isAiming() {
        Controller controller = Controllable.getController();
        return controller != null && controller.isButtonPressed(GunButtonBindings.AIM.getButton());
    }

    public static boolean isShooting() {
        Controller controller = Controllable.getController();
        return controller != null && controller.isButtonPressed(GunButtonBindings.SHOOT.getButton());
    }
}

